<?php

namespace ODE\Sms;

require_once(__DIR__ . '/../erreur_api_sms.php');
require_once(__DIR__ . '/../../../../../vendor/autoload.php');

use \Ovh\Api;

/**
 * Classe pour l'envoi de SMS par l'API OVH
 *
 * @author Aurélien ALVES <aurelien.alves@lanteas.com>
 * @author Lanteas <contact@lanteas.com>
 * @version 1.0
 */
class Ovh
{

    private $endpoint;
    private $applicationKey;
    private $applicationSecret;
    private $consumer_key;
    private $compte_api;
    private $expediteur_api;

    /**
     * __construct
     *
     * @return void
     */
    public function __construct($config = false)
    {
        if(!$config)
        {
            global $sugar_config;
            
            // On configure les différentes variables nécessaires à l'envoi du SMS
            $this->endpoint          = $sugar_config['ops_sms']['url_appel_api'];
            $this->applicationKey    = $sugar_config['ops_sms']['application_key'];
            $this->applicationSecret = $sugar_config['ops_sms']['application_secret'];
            $this->consumer_key      = $sugar_config['ops_sms']['consumer_key'];
            $this->compte_api        = $sugar_config['ops_sms']['compte_api'];
            $this->expediteur_api    = $sugar_config['ops_sms']['expediteur_api'];
        }
        else
        {
            $this->endpoint          = $config['url_appel_api'];
            $this->applicationKey    = $config['application_key'];
            $this->applicationSecret = $config['application_secret'];
            $this->consumer_key      = $config['consumer_key'];
            $this->compte_api        = $config['compte_api'];
            $this->expediteur_api    = $config['expediteur_api'];
        }
    }

    /**
     * post_sms
     *
     * @param  mixed $numeros
     * @param  mixed $message
     *
     * @return void
     */
    public function post_sms($numeros, $message)
    {

        $conn = new Api(
            $this->applicationKey,
            $this->applicationSecret,
            $this->endpoint,
            $this->consumer_key
        );

        // On tente la récupération de la connexion à l'api, sinon on récupère l'erreur pour l'envoyer dans les logs SuiteCRM
        try {
            $smsServices = $conn->get('/sms/');
        } catch (GuzzleHttp\Exception\ClientException $e) {
            $reponse = $e->getResponse();
            $reponseErreurTexte = json_decode($reponse->getBody()->getContents());
            $GLOBALS['log']->fatal('OPS_SMS - ovh.php - Impossible d\'envoyer le SMS - Erreur : : ' . $reponseErreurTexte->message);
            return false;
        }

        $content = (object) array(
            "charset" => "UTF-8",
            "class" => "phoneDisplay",
            "coding" => "7bit",
            "message" => $message,
            "noStopClause" => false,
            "priority" => "high",
            "sender" => $this->expediteur_api,
            "receivers" => ["$numeros"],
            "noStopClause" => true,
        );

        // On tente l'envoi du SMS, sinon on récupère l'erreur pour l'envoyer dans les logs SuiteCRM
        try {
            $resultPostJob = $conn->post('/sms/' . $smsServices[0] . '/users/' . $this->compte_api . '/jobs', $content);
        } catch (GuzzleHttp\Exception\ClientException $e) {
            $reponse = $e->getResponse();
            $reponseErreurTexte = json_decode($reponse->getBody()->getContents());
        }

        // Si le sms a bien été envoyé
        if (isset($resultPostJob) && (isset($resultPostJob['ids']) && !empty($resultPostJob['ids']))) {
            $sms_envoye = true;
        } elseif (isset($reponseErreurTexte)) { // Sinon, on affiche l'erreur retournée par l'API
            $GLOBALS['log']->fatal('OPS_SMS - ovh.php - Impossible d\'envoyer le SMS?? - Erreur : : ' . $reponseErreurTexte->message);
            $sms_envoye = false;
        }

        return $sms_envoye;
    }
}
