/**
 * OPS_Dossier[geoloc]/GeoMarker
 *
 * Conrolleur applicatif de la vue « geoloc » permettant les interactions la cartographie et ses filtres.
 * - Définition de 2 descripteurs accesseurs permettant la récupération d'éléments dans un tableau complexe ({twm} Blister toolset )
 * - Etendage fonctionnelle du getter jQuery pour lui associer 2 générateurs de clés
 * - Socle Blister AppUI pour l'environnement App-UIX
 *
 * @uses /entryPoint#geo_marker
 *
**/


/** Allows to get item in Array by a key reference **/
Object.defineProperty(
	Array.prototype,
	"getObjectBy",
	{enumerable:!1,writable:!0,value:function(e,t){for(var r=0;r<this.length;r++)if(this[r][e]===t)return this[r];return"undefined"}}
);

/** Allows to get all items in Array by a key reference in a scope node having a given value - scope must be a single one level **/
Object.defineProperty(
	Array.prototype,
	"getAllObjectBy",
	{enumerable:!1,writable:!0,value:function(k,v,scope){b=[];for(var r=0;r<this.length;r++)if(this[r][scope][k]===v)b.push(this[r]);return b;}}
);

/** Allows to get item in Array by a key reference in a scope node **/
Object.defineProperty(
	Array.prototype,
	"getObjectByIn",
	{enumerable:!1,writable:!0,value:function(k,v,scope){for(var r=0;r<this.length;r++)if(this[r][scope][k]===v)return this[r];return"undefined"}}
);

/** Allows to get Array index by a key reference **/
Object.defineProperty(
	Array.prototype,
	"getIndexBy",
	{enumerable:!1,writable:!0,value:function(e,r){for(var t=0;t<this.length;t++)if(this[t][e]===r)return t;return null}}
);

/** Allows to get Array index by a key reference **/
Object.defineProperty(
	Array.prototype,
	"unique",
	{enumerable:!1,writable:!0,value:function(e,r){return this.filter(function (v,i,s){return s.indexOf(v)===i;});}}
);


/** Allows to generate an identifier alpha-numeric based with a given length. $.fn.getUniqueId(12) **/
$.fn.extend({getUniqueId:function(n){charSet="abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",charSetSize=charSet.length,charCount=n;for(var t="",a=1;a<=charCount;a++){var e=Math.floor(Math.random()*charSetSize);t+=charSet[e]} return t}});

/** Allows to generate an identifier alpha-caps-numeric-ponctuation based with a given length and an usage. $.fn.getUniqueKey(8, ['alpha','pct']) **/
$.fn.extend({getUniqueKey:function(n,u){var charSet=Array();charSet['alpha']="abcdefghijklmnopqrstuvwxyz";charSet['caps']="ABCDEFGHIJKLMNOPQRSTUVWXYZ";charSet['num']="0123456789";charSet['pct']="{([+/-|%$!%#&@-_])}";var charUse="";charUse+=(u.indexOf('alpha')>-1)?charSet['alpha']:'';charUse+=(u.indexOf('caps')>-1)?charSet['caps']:'';charUse+=(u.indexOf('num')>-1)?charSet['num']:'';charUse+=(u.indexOf('pct')>-1)?charSet['pct']:'';charSetSize=charUse.length,charCount=n;for(var t="",a=1;a<=charCount;a++){var e=Math.floor(Math.random()*charSetSize);t+=charUse[e]}return t}});





// Application User Interface
if( typeof(AppUI) == 'undefined' ){ var AppUI = { loaded:false }; }




/**
 * Déclaration des Helpers applicatif
**/
AppUI.getVar = function(varname){
	return jQuery('input[role="data-var"][data-var="'+varname+'"]').attr('data-value');
}
Object.defineProperty(
	AppUI,
	"options",
	{enumerable:!1,writable:!1,value:function(){
		this.options = {
			module_name	: AppUI.getVar('module_name'),
			center_point   : [ parseFloat( AppUI.getVar('geo_initial_lng') ) , parseFloat( AppUI.getVar('geo_initial_lat') )],
			center_zoom	: parseInt( AppUI.getVar('geo_initial_zoom') ),
			maximum_points : parseInt( AppUI.getVar('geo_maximum_points') ),
			min_zoom	   : parseInt( AppUI.getVar('geo_min_zoom') ),
			max_zoom	   : parseInt( AppUI.getVar('geo_max_zoom') )
		};
		return this.options
	}}
);


Object.defineProperty(
	AppUI,
	"GeoMarker",
	{enumerable:!1,writable:!1,value:function(){
		this.filters = {}
	}}
);


var map	       = null;
var popup	   = null;
var info	   = null;
AppUI.JsonOPS  = {}; // Must be initialized « AppUI.initDataJson ».
AppUI.folders  = []; // Must be initialized « AppUI.initDataJson ».
AppUI.filters  = []; // Must be initialized « AppUI.initDataJson ».



// View UIX handlers...
AppUI.Overlay = {

	show: function(){ jQuery('[role="overlay"]').fadeIn(); },
	hide: function(){ jQuery('[role="overlay"]').fadeOut(); }

}


// Initialize the provided JSON data !
AppUI.initDataJson = function(){

	let JSON_OPS_dossier = jQuery.parseJSON( $('textarea[role="geo-dossiers"]').val() || JSON.stringify( {} ) );

	if( typeof(JSON_OPS_dossier.date) == 'undefined' || typeof(JSON_OPS_dossier.folders) == 'undefined' ){
		JSON_OPS_dossier = {
			"date": new Date(),
			"folders": [],
			"filters": []
		};
	}

	AppUI.JsonOPS = JSON_OPS_dossier;
	AppUI.folders = JSON_OPS_dossier.folders;
	AppUI.filters = JSON_OPS_dossier.filters;

}



AppUI.getDossiers = function(){

	return AppUI.folders;

}

AppUI.getFilters = function(){

	return AppUI.filters;

}


AppUI.createMap = function(){

	map = L.map('map').setView( AppUI.options.call().center_point, AppUI.options.call().center_zoom );

	L.tileLayer('http://{s}.tile.osm.org/{z}/{x}/{y}.png', {
		minZoom: AppUI.options.call().min_zoom,
		maxZoom: AppUI.options.call().max_zoom,
		id: 'sa-map-iD'
	}).addTo(map);

}



AppUI.createMarkerIcon = function(args){

	markerIcon = L.icon({
		iconUrl	 : '/index.php?entryPoint=geo_marker&fill='+args.fill+'&inner='+args.inner,
		iconSize	: [35, 42],
		iconAnchor  : [18, 42],
		popupAnchor : [-1, -43],
		riseOnHover : true,
		className   : 'geo-marker '+args.className
	});

	return markerIcon;
}


AppUI.setMarker = function(marker_icon,latitude,longitude){ //<LatLng>

	var marker = L.marker([latitude, longitude], {icon: marker_icon});
	return marker;

}



AppUI.createMapPoints = function(){

	let folders = AppUI.getDossiers();

	jQuery.each( folders , function(i,folder) {

		//console.log( "AppUI.createMapPoints" , folder.point );

		var markerIcon = AppUI.createMarkerIcon( {
			fill	  : String( folder.point.marker_color ).replace(/\s/g,''),
			inner	  : String( 'rgba(0, 0, 0, 0.14)' ).replace(/\s/g,''),
			className : 'geo-marker-' + folder.identity.id
		} ); // The className allows to put an absolute and unique referece class selector tfor this marker.
		
		marker = AppUI.setMarker( markerIcon , folder.point.latitude , folder.point.longitude );
		marker.addTo(map);
		$( 'img.leaflet-marker-icon.geo-marker.geo-marker-'+folder.identity.id ).fadeOut();

		AppUI.folders[i].point.marker = marker; // Update to the JSON data node the related new marker to retreive it after...

	} );

}


AppUI.initFilters = function(){

	//console.log("OPS_dossier[GeoDossier] - /GeoMarker$AppUI.initFilters" , true );

	// Prepare UIX Component init mode. All disabled except master filter.
	$('[role="filter"][data-master=""]').attr('disabled','disabled').css('opacity', '0.5');
	$('[role="filter"][data-master="master"]').attr('disabled',false).removeAttr( "disabled" ).css('opacity', '1');


	$('[role="filter"]').each(function(i,o){

		let select_filter = {
			id	   : o.id,
			role	 : $(o).attr('role'),
			property : $(o).attr('data-property'),
			node	 : $(o).attr('data-node'),
			callback : $(o).attr('data-filter-cb'),
			master   : ( $(o).attr('data-master') == 'master' )? true:false
		}
		//console.log( 'select_filter' , select_filter );

		nodes = jsonPath( AppUI.getDossiers() , "$[*]."+select_filter.property+"."+select_filter.node ) || [];
		//console.log( 'nodes' , nodes );

		items = nodes.unique();
		//console.log( 'items' , items );

		filter_labels = items.sort();
		//console.log( 'filter_labels' , filter_labels );


		// Builds all option items for this filter select
		if( i == 0 ){
			var opt = new Option( '--' , '--' );
			/// jquerify the DOM object 'o' so we can use the html method
			$(opt).html( '--' );
			$( "#"+select_filter.id ).append( opt );
		}


		// Builds all option items for this filter select
		var opt = new Option( 'Tous' , '*' );
		/// jquerify the DOM object 'o' so we can use the html method
		$(opt).html( 'Tous' );
		$( "#"+select_filter.id ).append( opt );


		// Builds all option items for this filter select
		jQuery.each( filter_labels , function(i,o){

			data_node = AppUI.getDossiers().getObjectByIn( select_filter.node, String(o) , select_filter.property );

			//console.log( 'data_node' , data_node , data_node[select_filter.property][select_filter.node] );


			var opt = new Option( data_node[select_filter.property][select_filter.node] , data_node[select_filter.property]['id'] );
			/// jquerify the DOM object 'o' so we can use the html method
			$(opt).html( data_node[select_filter.property][select_filter.node] );
			$( "#"+select_filter.id ).append( opt );


		} );


		// Adds fast binder selector.
		$( "#"+select_filter.id ).off().on( 'change' , function () {
			
			f_item = $(this).find( "option:selected" );
			console.log( "Change filter: ", f_item.text() , f_item.val() );

			if( $( "#"+select_filter.master ) ){ 

				if( f_item.val() == "--" ){
					$('[role="filter"][data-master=""]').attr('disabled','disabled').css('opacity', '0.5');
				}else{
					$('[role="filter"][data-master=""]').attr('disabled',false).removeAttr( "disabled" ).css('opacity', '1');
				}

			}

			void AppUI.applyFilters();

		} ).change();

	});

	// Prepare UIX Component init mode. All disabled except master filter.
	$('[role="filter"][data-master=""]').attr('disabled','disabled').css('opacity', '0.5');
	$('[role="filter"][data-master="master"]').attr('disabled',false).removeAttr( "disabled" ).css('opacity', '1');

}


AppUI.applyFilters = function(){

	//console.log("OPS_dossier[GeoDossier] - /GeoMarker$AppUI.applyFilters" , true );

	$('img.leaflet-marker-icon.geo-marker').fadeOut(); // Fade off all Markers...

	if( !AppUI.loaded ){ 
		return false; // Do not apply any filters if App was not fully loaded.
	}

	map.closePopup(); // Attempts to close opened popup.


	// Filtering processes when AppUI was loaded only...

	filter_rules		  = [];
	constraint_rules	  = "";
	active_filter_results = [];


	$('[role="filter"]').each( function(i,o){

		let select_filter = {
			id	   : o.id,
			role	 : $(o).attr('role'),
			property : $(o).attr('data-property'),
			node	 : $(o).attr('data-node'),
			callback : $(o).attr('data-filter-cb'),
			master   : ( $(o).attr('data-master') == 'master' )? true:false,
			_key	 : 'id',
			_val	 : $( "#"+o.id ).find( "option:selected" ).val()
		}


		filter_rules.push( select_filter );

		constraint_rules += ( String( select_filter._val ) == '' )? '0000000-0000-0000-0000-000000000000' : select_filter._val;

	} );



	let combined_filter_results = []; // Receive all results for combined filters, doublon, not at all full filtered !
	$.each( filter_rules , function(j,rule){

		filter_rule_result = AppUI.getDossiers().getAllObjectBy( rule._key , rule._val, rule.property );
	//	//console.log("OPS_dossier[GeoDossier] - /GeoMarker$AppUI.applyFilters" , rule._key , rule._val, rule.property , filter_rule_result );
		
		combined_filter_results = combined_filter_results.concat(filter_rule_result);

	} );

	
	// Checks if all the filters are selected on ALL, so *willcard* must be returns ALL the « Folders »
	if( constraint_rules.replace( /[*]/ig, '') == "" && AppUI.getDossiers().length <= AppUI.options.call().maximum_points ){

		combined_filter_results = AppUI.getDossiers();

	}



	// Remove duplicates.
	all_filter_results = combined_filter_results.unique();
	//console.log("OPS_dossier[GeoDossier] - /GeoMarker$AppUI.applyFilters ALL: " , all_filter_results );


	// Ensure that the constraint does not contain « All * »
	if( constraint_rules.replace( /[*]/ig, '') == "" && all_filter_results.length > AppUI.options.call().maximum_points ){

		// Except if total Folders does not ecceds a defined quantity...
		alert( "Trop d'éléments à afficher simultanément !" );
		console.log("%cTOOBIG!!!", "color:#a21139; font-size:80px;", all_filter_results.length +' vs '+ AppUI.options.call().maximum_points );

		return false;

	}


	// Iterates over "all_filter_results" and performs matches on all filters.
	filtered_results = [];
	filtered_errors  = [];
	$.each( all_filter_results , function(j,folder){

		//console.log("OPS_dossier[GeoDossier] - /GeoMarker$AppUI.applyFilters ...folder: " , folder );

		// Verify if all filters matches combined on the folder...
		b_filter_matches = true;
		$.each( filter_rules , function(j,rule){		
			if( folder[rule.property][rule._key] !== rule._val && rule._val != '*' ){ b_filter_matches &= false }
		} );

		
		if( folder.point.longitude == '0' && folder.point.latitude == '0' ){ 

			b_filter_matches &= false; // Flag it as not match (gps coordonates error) !
			filtered_errors.push( folder );

		}


		// Adds this Folder if the test is verified... and... Show easy the marker.
		if( Boolean(b_filter_matches) ){
			
			filtered_results.push( folder );

			$( 'img.leaflet-marker-icon.geo-marker.geo-marker-'+folder.identity.id ).fadeIn();


/*
			html  = '';
			html += '<div style="margin-bottom: 0.5rem;"><span data-id="'+ folder.identity.id +'" title="'+ folder.identity.id +'" class="glyphicon glyphicon-map-marker" style="cursor:help;margin-right:0.75rem;"></span><strong>N° '+ folder.identity.name +'</strong></div>';
		//	html += '<div><code style="background-color:transparent;color:#35b3c5;padding: 2px 0;">'+ folder.identity.id +'</code></div>';
			html += '<div><span style="color:#003a6c;">'+ folder.identity.date +'</span></div>';
			html += '<hr style="background-color: transparent;color:#003a6c;padding: 0;margin: 2px 0;border-bottom: dotted #aaa 1px;"></hr>';
			html += '<div><strong>'+ folder.dispositif.name +'</strong></div>';
			html += '<div><span>'+ folder.demandeur.label +'</span></div>';
			html += '<div><span class="glyphicon glyphicon-tags" style="margin-right:0.75rem;color:'+ folder.point.marker_color +';"></span> <span>'+ jQuery.trim(folder.instruction.etape) +'</span> (<span>'+ jQuery.trim(folder.instruction.statut) +'</span>)</div>';
			html += '<div style="text-align:right;margin-top: 1rem;"><a href="/?module='+ AppUI.options.call().module_name +'&action=DetailView&record='+ folder.identity.id +'">Consulter ce dossier</a><span class="glyphicon glyphicon-folder-open" style="margin-left:0.75rem;"></span></div>';
			html += '<div style="margin-bottom: 2rem;"></div>';

			//folder.point.marker.bindPopup( html );
/**/

			console.group("%cBindind click event on the icon marker..." ,'color:#a27838;', folder.identity.name );
			console.log( folder );

			$( folder.point.marker.getElement() ).off().on( 'click' , AppUI.showMarkerPopup( folder ) );
			void AppUI.updateMarkerIcon( folder ); // Update color and shape of a the Marker Icon (Single|Multi marker-s)

			console.groupEnd();

		}
		
	} );



	/* Allows to map to fit properly to the marker bounds (filtered) */
	var bound_markers = [];
	jQuery.each( filtered_results , function(i,n){

		latlng = L.marker([ n.point.marker.getLatLng().lat , n.point.marker.getLatLng().lng ]);
		bound_markers.push( n.point.marker );

	} );

	if( bound_markers.length > 0 ){

		var group = new L.featureGroup(bound_markers);
		map.fitBounds(group.getBounds());

	}


	// Verbose some control infos...
	$('[role="count-results"]').html( filtered_results.length + AppUI.Syntaxer.plural(' dossier', filtered_results.length) + AppUI.Syntaxer.plural(' disponible', filtered_results.length) );

	$('[role="count-errors"]').html( (filtered_errors.length > 0)? String( filtered_errors.length + AppUI.Syntaxer.plural(' non localisé', filtered_errors.length) ) : $('[role="count-errors"]').attr('data-label') );
	$('[role="see-errors"]').css( 'display' , ((filtered_errors.length>0)? 'inline-block':'none') );

}


AppUI.showMarkerPopup = function(folder){

	var html = 'Popup Vide';
	var is_multiple = false;

	if( AppUI.isMarkerMultiple(folder) ){

		html = AppUI.getContentMultiMarkers( folder );
		var custom_options = { 'className' : 'leaflet-custom-popup-multi' }
		is_multiple = true;

	}else{
		
		html = AppUI.getContentMarker( folder );
		var custom_options = { 'className' : 'leaflet-custom-popup-single' }
		is_multiple = false;

	}


	var popup = L.popup().setContent( html );


	var popup = L.DomUtil.create('div', 'infoWindow');
	popup.innerHTML = html;



	marker = folder.point.marker;
	marker.bindPopup(popup , custom_options);	


	// Bind an event that allows to the folder link (view more ❱ when MULTI)
	// The DOM has already been created from the L.DomUtil, so we can attach event on each icon « ❱ » to sitch to an single popup
	if( is_multiple ){
		console.log( 'Bind role="leaflet-popup-vue-switcher"' , folder );
		
		marker.off('popupopen').on('popupopen', function (popup) {

			console.log( 'on.popupopen', "Prepare to switch to detail with single view", popup );
			$('.leaflet-popup .leaflet-popup-content a[role="leaflet-popup-vue-switcher"]').each(function(index) {
				$(this).off().on("click", function(le){

					// Prevents the default action from occuring.
					le.preventDefault();
					switched_folder_id = $(this).attr('data-folder-id');
					switched_folder = filtered_results.getObjectByIn( 'id' , switched_folder_id , 'identity' );
					AppUI.showMarkerSinglePopup( switched_folder , true );

				} );

			} );

		});
	}




}


AppUI.showMarkerSinglePopup = function(folder, backable){

	var html = 'Popup Vide';

	html = AppUI.getContentMarker( folder , backable );
	var custom_options = { 'className' : 'leaflet-custom-popup-single' }

	var popup = L.popup().setContent( html );

	var popup = L.DomUtil.create('div', 'infoWindow');
	popup.innerHTML = html;



	marker = folder.point.marker;
	marker.bindPopup(popup , custom_options);

	marker.off('popupopen').on('popupopen', function (_popup) {

		origin_folder_id = "";
		classes = $( _popup.sourceTarget.getElement() ).attr("class").split(/\s+/);
		console.log( "Found classes :" , classes );
		classes.forEach(function (c_class) {
		    console.log( "Throw class :" , c_class );
		    _matches = c_class.match(/geo-marker-([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})/); // geo-marker-[0-9a-f]{8}-b3d9-1f49-cfeb-5ef46dd0ebca
		    if( _matches && _matches[0] == 'geo-marker-'+_matches[1] ){
		        console.log( "Checked class :" , c_class , "Extracted folder id :", _matches[1] );
		        origin_folder_id = _matches[1];

		        // Re attach (rebind) the popup event when marker will be clicked to show popup for 'all' related folders.
				reversed_folder = filtered_results.getObjectByIn( 'id' , origin_folder_id , 'identity' );
				$( _popup.sourceTarget.getElement() ).off().on( 'click' , AppUI.showMarkerPopup( reversed_folder ) );

				// Attach (bind) the popup event when the 'arrow back' will be clicked to show popup for 'all' related folders too.
				$reverse = $('.leaflet-popup .leaflet-popup-content a[role="leaflet-popup-vue-reverse"][data-folder-id="'+origin_folder_id+'"]');
				$reverse.off().on( 'click' , function(){ $( _popup.sourceTarget.getElement() ).trigger( "click" ) } ); // triggering mode.

		    }
		});

	} );

	marker.openPopup();

}


AppUI.isMarkerMultiple = function(folder){

	console.log( "%c⯈ Verify if another markers exists at the same place than this marker... « "+folder.identity.name +" »", 'color:#e29014;font-weight:bold;' );
	_qt = 0 || AppUI.getMarkersSameCoord(folder).length;

	return ( _qt > 0)? true : false;

}


AppUI.getMarkersSameCoord = function(folder){

	var same_markers = []; // Collection of markers having same Longitude & Latitude.

	console.group( "%cSearching other marker like « "+ folder.identity.name +" »...", 'color:#e29014;;font-weight:bold;font-style: italic;' );
	$.each( filtered_results , function(i,f){

		if( folder.point.latitude == f.point.latitude && folder.point.longitude == f.point.longitude && folder.identity.id != f.identity.id ){

			same_markers.push( f );
			console.log(" ⮱ Find : « "+ f.identity.name +" »");

		}

	} );

	/**/
	if( same_markers.length > 0 ){
		console.log( same_markers.length + " marker(s) found !" , same_markers);
	}else{ 
		console.log( "No marker found at the same coordonate." );
	}
	/**/
	console.groupEnd();


	return same_markers;

}


AppUI.getContentMarker = function(folder , backable){

	html  = '';

	if( backable ){
	html += '<div class="multi-folder-entry">';
	html += '<div role="folder-entry-info">';
	}

	html += '<div style="margin-bottom: 0.5rem;"><span data-id="'+ folder.identity.id +'" title="'+ folder.identity.id +'" class="glyphicon glyphicon-map-marker" style="cursor:help;margin-right:0.75rem;"></span><strong>N° '+ folder.identity.name +'</strong></div>';
//	html += '<div><code style="background-color:transparent;color:#35b3c5;padding: 2px 0;">'+ folder.identity.id +'</code></div>';
	html += '<div><span style="color:#003a6c;">'+ folder.identity.date +'</span></div>';
	html += '<hr style="background-color: transparent;color:#003a6c;padding: 0;margin: 2px 0;border-bottom: dotted #aaa 1px;"></hr>';
	html += '<div><strong>'+ folder.dispositif.name +'</strong></div>';
	html += '<div><span>'+ folder.demandeur.label +'</span></div>';
	html += '<div><span class="glyphicon glyphicon-tags" style="margin-right:0.75rem;color:'+ folder.point.marker_color +';"></span> <span>'+ jQuery.trim(folder.instruction.etape) +'</span> (<span>'+ jQuery.trim(folder.instruction.statut) +'</span>)</div>';
	html += '<div style="text-align:right;margin-top: 1rem;" class="'+ ( ( backable )? 'backable':'' ) +'" >';

	if( backable ){
	html += '<div style="overflow: hidden; font-size: 25px;">';
	html += '<a href="#" role="leaflet-popup-vue-reverse" data-folder-id="'+ folder.identity.id +'">❰</a>';
	html += '</div>';
	}

	html += '<span role="leaflet-popup-see-detail"><a href="/?module='+ AppUI.options.call().module_name +'&action=DetailView&record='+ folder.identity.id +'">Consulter ce dossier</a><span class="glyphicon glyphicon-folder-open" style="margin-left:0.75rem;"></span></span>';
	
	html += '</div>';
	html += '<div style="margin-bottom: 2rem;"></div>';



	if( backable ){
	html += '</div>';
	html += '</div>';
	}

	return html;

}



AppUI.getContentMultiMarkers = function(folder){

	same_markers = AppUI.getMarkersSameCoord(folder);
	same_markers.push( folder );
	view_markers = same_markers.unique();

	const sortByMapped = (map,compareFn) => (a,b) => compareFn(map(a),map(b));
	const byValue = (a,b) => a - b;
	const toNum = e => parseInt(e.identity.num);
	const byNum = sortByMapped(toNum,byValue);

	view_markers = [...same_markers].sort(byNum);


	html  = '';

	$.each( view_markers , function(i,f){

		html += '<div class="multi-folder-entry">';
		html += '<div role="folder-entry-info">';
		html += '<div style="margin-bottom: 0.5rem;"><span data-id="'+ f.identity.id +'" title="'+ f.identity.id +'" class="glyphicon glyphicon-map-marker" style="cursor:help;margin-right:0.75rem;"></span><strong>N° '+ f.identity.name +'</strong></div>';
		html += '<div><strong>'+ f.dispositif.name +'</strong></div>';
		html += '<div><span>'+ f.demandeur.label +'</span></div>';
		html += '<div><span class="glyphicon glyphicon-tags" style="margin-right:0.75rem;color:'+ f.point.marker_color +';"></span> <span>'+ jQuery.trim(f.instruction.etape) +'</span> (<span>'+ jQuery.trim(f.instruction.statut) +'</span>)</div>';
		html += '<div style="margin-bottom: 1rem;"></div>';
		html += '</div>';
		html += '<div style="overflow: hidden; font-size: 50px;">';
		html += '<a href="#" role="leaflet-popup-vue-switcher" data-folder-id="'+ f.identity.id +'">❱</a>';
		html += '</div>';
		html += '</div>';

		if( i < view_markers.length -1 ){
		html += '<hr style="background-color: transparent;color:#003a6c;padding: 0;margin: 2px 0 1rem;border-bottom: dotted #aaa 1px;"></hr>';
		}

	} );

	return html;

}


AppUI.updateMarkerIcon = function(folder){
	
	if( AppUI.isMarkerMultiple(folder) ){
		console.log( "%c➥ Some brothers found "  ,'font-style: italic;' );

		var args = {
			fill	  : String( 'rgb(148, 166, 181)' ).replace(/\s/g,''),
			inner	  : String( 'rgba(0, 0, 0, 0.14)' ).replace(/\s/g,''),
			mode      : 'multi',
			className : 'geo-marker-' + folder.identity.id
		};

        $( folder.point.marker.getElement() ).attr( 'mode' , args.mode );

		new_multi_marker_icon_src = '/index.php?entryPoint=geo_marker&fill='+args.fill+'&inner='+args.inner+'&mode='+args.mode;
		$( folder.point.marker.getElement() ).attr( 'src' , new_multi_marker_icon_src);
		$( folder.point.marker.getElement() ).get(0).src = new_multi_marker_icon_src;


	}else{
        if( $( folder.point.marker.getElement() ).attr( 'mode' ) == 'multi' ){
        	console.log( "%c➥ No brother, restore this marker"  ,'font-style: italic;' );
       
            var args = {
                fill      : String( folder.point.marker_color ).replace(/\s/g,''),
                inner     : String( 'rgba(0, 0, 0, 0.14)' ).replace(/\s/g,''),
                mode      : 'single',
                className : 'geo-marker-' + folder.identity.id
            };

            $( folder.point.marker.getElement() ).attr('mode',false).removeAttr( "mode" );

            new_single_marker_icon_src = '/index.php?entryPoint=geo_marker&fill='+args.fill+'&inner='+args.inner+'&mode='+args.mode;
            $( folder.point.marker.getElement() ).attr( 'src' , new_single_marker_icon_src);
            $( folder.point.marker.getElement() ).get(0).src = new_single_marker_icon_src;

        }else{
            $( folder.point.marker.getElement() ).attr('mode',false).removeAttr( "mode" );
        }
    }

}



// Enjoy plurals on terms !
AppUI.Syntaxer = {

	plural : function(word, oc){
		return String( word + ((oc>1)? 's' : '' ) );
	}

}




jQuery(document).ready(function($){
	console.log('Hello from jQuery!');

	void AppUI.initDataJson(); // Initialize the provided JSON data from the App controler.
	void AppUI.createMap(); // Create the Leaflet map (empty).


	void AppUI.initFilters(); // Init the filters and controls.

	void AppUI.createMapPoints(); // Create the map points.

	AppUI.Overlay.hide(); // When all is ready, done.
	AppUI.loaded = true;

});

