<?php
if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

/**
 *
 * Ce package est la propriété de la société Lanteas, inscrit au RCS de Versailles sous le numéro de SIREN 802 750 331 
 * dont le siège social est situé au 57 boulevard de la République, 78400 Chatou.
 */
//require_once('modules/AOS_PDF_Templates/PDF_Lib/mpdf.php');
require_once('modules/AOS_PDF_Templates/templateParser.php');
require_once('modules/AOS_PDF_Templates/AOS_PDF_Templates.php');

use Mpdf\Mpdf;

use ODE\Helper\ReplaceVariable;

abstract class OPS_generate_PDF
{
    /**
     * @access public
     * get_valid_slugfile()
     * Fonction qui génère un slug name sur la base d'un nom  de template et d'un uid
     * 
     *  @param String   $template_name  - Nom humain du template
     *  @return String  $pdf_slugfile   - Slug file valid sur la base des règles définies
    */
    function get_valid_slugfile( $template_name ){

        // A mastered and complete dashed slugify | Implementation Lanteas (by Sebounet)
        $pdf_slugfile = strtoupper( $template_name );
        if( class_exists('Transliterator') ){
            try {
                $pdf_slugfile =  \Transliterator::create('NFD; [:Nonspacing Mark:] Remove; NFC')->transliterate( $pdf_slugfile );
            } catch (Exception $e) {
                if ( class_exists( 'Normalizer' ) ) {
                    try {
                        $pdf_slugfile = Normalizer::normalize( $pdf_slugfile, Normalizer::NFD );
                    } catch (Exception $e) {
                        $pdf_slugfile = preg_replace( '@[^\0-\x80]@u' , "", $pdf_slugfile );
                    }
                }
            }
        }
        $pdf_slugfile = trim( $pdf_slugfile );
        $pdf_slugfile = preg_replace( '/[.]|(\s)/', "",  $pdf_slugfile );
        $pdf_slugfile = preg_replace( '/[\']/', "",  $pdf_slugfile );
        $pdf_slugfile = preg_replace( '/[-]/', "_",  $pdf_slugfile );
        $pdf_slugfile = preg_replace( '/[^a-zA-Z0-9_]/', "_",  $pdf_slugfile );
        $pdf_slugfile = preg_replace( '/([_]+)/', "_",  $pdf_slugfile );
        $pdf_slugfile = preg_replace( '/(^[_]|[_]$)/', "",  $pdf_slugfile );
        $pdf_slugfile = strtolower( $pdf_slugfile );

        $pdf_slugfile = $pdf_slugfile;

    	return $pdf_slugfile;
    }
    /**
     * @access public
     * transform_to_pdf()
     * Fonction qui génère un document PDF sur la base du bean métier courant et d'un template
     * 
     *  @param Bean    $bean            - Module en cours d'utilisation
     *  @param String  $template_id     - UID du template à exploiter
     *  @param Array   $datas           - Tableau de données à exploiter lors de la transformation (Data Provider) // Version 2.1
     *  @param String  $dest_filename   - Nom final du fichier de destination
     *  @return String $pdf_path        - Chemin absolu du pdf généré ou false en cas d'erreur
    */
    public static function transform_to_pdf($bean, $template_id, $datas, $dest_filename,$document_id = '')
    {
		global $sugar_config;

		$bean = BeanFactory::getBean( $bean->object_name, $bean->id );
		$task = 'pdf';
		$variableName = strtolower($bean->module_dir);


		$template = new AOS_PDF_Templates();
		$template->retrieve( $template_id );

		$object_arr = array();
		$object_arr[$bean->module_dir] = $bean->id;

		//backward compatibility
		$object_arr['Accounts'] = $bean->billing_account_id;
		$object_arr['Contacts'] = $bean->billing_contact_id;
		$object_arr['Users'] = $bean->assigned_user_id;
		$object_arr['Currencies'] = $bean->currency_id;

		$search = array('/<script[^>]*?>.*?<\/script>/si',      // Strip out javascript
		    '/<[\/\!]*?[^<>]*?>/si',        // Strip out HTML tags
		    '/([\r\n])[\s]+/',          // Strip out white space
		    '/&(quot|#34);/i',          // Replace HTML entities
		    '/&(amp|#38);/i',
		    '/&(lt|#60);/i',
		    '/&(gt|#62);/i',
		    '/&(nbsp|#160);/i',
		    '/&(iexcl|#161);/i',
		    '/<address[^>]*?>/si',
		    '/&(apos|#0*39);/',
		    '/&#(\d+);/'
		);

		$replace = array('',
		    '',
		    '\1',
		    '"',
		    '&',
		    '<',
		    '>',
		    ' ',
		    chr(161),
		    '<br>',
		    "'",
		    'chr(%1)'
		);

		$header = preg_replace($search, $replace, $template->pdfheader);
		$footer = preg_replace($search, $replace, $template->pdffooter);
		$text = preg_replace($search, $replace, $template->description);

		$text = str_replace("<p><pagebreak /></p>", "<pagebreak />", $text);
		$text = preg_replace_callback('/\{DATE\s+(.*?)\}/',
		    function ($matches) {
		        return date($matches[1]);
		    },
		    $text);

		// Quotes, Invoives and Products compatibility
		$text = str_replace("\$aos_quotes", "\$" . $variableName, $text);
		$text = str_replace("\$aos_invoices", "\$" . $variableName, $text);
		$text = str_replace("\$total_amt", "\$" . $variableName . "_total_amt", $text);
		$text = str_replace("\$discount_amount", "\$" . $variableName . "_discount_amount", $text);
		$text = str_replace("\$subtotal_amount", "\$" . $variableName . "_subtotal_amount", $text);
		$text = str_replace("\$tax_amount", "\$" . $variableName . "_tax_amount", $text);
		$text = str_replace("\$shipping_amount", "\$" . $variableName . "_shipping_amount", $text);
		$text = str_replace("\$total_amount", "\$" . $variableName . "_total_amount", $text);

		foreach ($datas as $key => $value) {
			$text = str_replace($key, $value, $text);
		}

		# Si le bean est de type OPS_dossier, OPS_personne_morale ou OPS_individu on passe d'abord par un traitement spécifique avant le traitement standard
		$converted = $text;
		if ( $bean->module_dir === 'OPS_dossier' || $bean->module_dir === 'OPS_personne_morale' || $bean->module_dir === 'OPS_individu') {
			$ReplaceVariable = new ReplaceVariable($bean);
			$converted = $ReplaceVariable->replace($converted,$document_id);
			$header = $ReplaceVariable->replace($header,$document_id);
			$footer = $ReplaceVariable->replace($footer,$document_id);
		} 

		$converted = templateParser::parse_template($converted, $object_arr);
		$header = templateParser::parse_template($header, $object_arr);
		$footer = templateParser::parse_template($footer, $object_arr);
		
		$printable = str_replace("\n", "<br />", $converted);
		$printable = str_replace("\r", "<br />", $printable);
		$printable = str_replace("&#13;", "<br />", $printable);

    	$_pdf = array();

	    try {
	        ini_set("pcre.backtrack_limit", "1000000");

	        $orientation = ($template->orientation == "Landscape") ? "L" : "";
	        $pdf = new mPDF([
	        	'mode' => 'en',
				'format' => $template->page_size,
	        	'orientation' => $orientation,
	        	'autoLangToFont' => true,
	        	'backupSubsFont' => 'DejaVuSansCondensed',
	        	'margin_header' => $template->margin_header,     
				'margin_footer' => $template->margin_footer,
				'margin_top' => $template->margin_top,     
				'margin_bottom' => $template->margin_bottom,
				'margin_left' => $template->margin_left,    	
				'margin_right' => $template->margin_right,    	
	        ]);
			
			$pdf->setAutoTopMargin = 'stretch';
			$pdf->setAutoBottomMargin = 'stretch';

	        $pdf->SetHTMLHeader($header);
	        $pdf->SetHTMLFooter($footer);
	        $pdf->WriteHTML($printable);


	        // On génère le PDF et on le sort sur le filesystem dans le dossier d'upload
            $fp = fopen($sugar_config['upload_dir'] . $dest_filename, 'wb');
            fclose($fp);
            $pdf->Output($sugar_config['upload_dir'] . $dest_filename, 'F');

            $_pdf['path'] = $sugar_config['upload_dir'] . $dest_filename;

	    } catch (mPDF_exception $e) {
	        $_pdf['error'] = $e;
	    }

    	return $_pdf;
    }
    /**
     * @access public
     * erase_pdf()
     * Fonction qui efface un fichier PDF généré.
     * 
     *  @param String<path>  $dest_filename   - Chemin absolu du pdf
     *  @return Bool        $erased    - confirme le bon effacement du fichier demandé
    */
    public static function erase_pdf($dest_filename){
		global $sugar_config;

    	// Par sécurité, le nom exact du fichier pdf...
		$erased        = false;

		if( is_file($dest_filename) ){
			@unlink( $dest_filename );
			$erased = !is_file($dest_filename);
		}

		return $erased;
    }
}