<?php

if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

require_once('include/Dashlets/DashletGeneric.php');
require_once('modules/Favorites/Favorites.php');

class MesFavorisTuilesMiniDashlet extends DashletGeneric
{
    public function __construct($id, $def = null)
    {
        global $app_list_strings;

        $this->seedBean = new Favorites();

        parent::__construct($id, $def);

        if (empty($def['title'])) {
            $this->title = translate('LBL_HOMEPAGE_TITLE', 'Favorites');
        }

        $this->myItemsOnly = true;
        $this->showMyItemsOnly = false;
        $this->displayTpl = 'custom/modules/Favorites/Dashlets/MesFavorisTuilesMiniDashlet/MesFavorisTuilesMiniDashlet.tpl';
    }

    public function process($lvsParams = array(), $id = null)
    {
        global $app_list_strings, $app_strings;


        parent::process($lvsParams, $id);

        foreach ($this->lvs->data['data'] as $row => $data) {
            $fav_name_explode = explode(' ', $data['NAME']); // On explose le name du favori qui contient le parent_type et le parent_id séparé par un espace

            $rel_bean = BeanFactory::getBean($fav_name_explode[0], $fav_name_explode[1]);
            $this->lvs->data['data'][$row]['NAME'] = $rel_bean->name;
            // Si on trouve le nom singulier du module, on le récupère, sinon, on récupère le nom au pluriel (standard)
            if ($app_list_strings['moduleListSingular'][$fav_name_explode[0]]) {
                $this->lvs->data['data'][$row]['PARENT_TYPE'] = $app_list_strings['moduleListSingular'][$fav_name_explode[0]];
            } else {
                $this->lvs->data['data'][$row]['PARENT_TYPE'] = $app_list_strings['moduleList'][$fav_name_explode[0]];
            }
            $this->lvs->data['data'][$row]['PARENT_FOR_LINK'] = $fav_name_explode[0];
            $this->lvs->data['data'][$row]['PARENT_ID'] = $fav_name_explode[1];
            $this->lvs->data['data'][$row]['ID'] = $fav_name_explode[1];
        }

        // On trie les favoris par ordre alphabétique du "parent_type"
        usort($this->lvs->data['data'], function ($a, $b) {
            $collator = collator_create('en');
            if ($a['ID'] === $b['ID']) {
                unset($a);
            } else {
                $arr = array($a['PARENT_TYPE'], $b['PARENT_TYPE']);
                collator_asort($collator, $arr, Collator::SORT_STRING);

                return array_pop($arr) == $a['PARENT_TYPE'];
            }
        });

        // On supprime les doublons (ANOMALIE SUITECRM)
        $this->lvs->data['data'] = $this->unique_array($this->lvs->data['data'], 'ID');

        $this->lvs->ss->assign('MoreInfo', $app_strings['LBL_ADDITIONAL_DETAILS']);
    }

    /**
     * Fonction permettant la suppression des doublons dans le tableau des favoris de l'utilisateur
     *
     * @param array $array_favoris
     * @param string $key
     * @return array
     */
    private function unique_array($array_favoris, $key)
    {
        $result = array();
        $i = 0;
        $key_array = array();

        foreach ($array_favoris as $val) {
            if (!in_array($val[$key], $key_array)) {
                $key_array[$i] = $val[$key];
                $result[$i] = $val;
            }
            $i++;
        }
        return $result;
    }
}
