<?php 

$job_strings[] = 'purge_bd_avec_delai';

/**
 * Fonction de purge des elements flaggé deleted en bdd
 * basé sur la tache planifié de suitecrm "pruneDatabase"
 */
function purge_bd_avec_delai()
{

    $GLOBALS['log']->fatal(print_r("## Lancement de la tache planifié de purge de BDD ##",true));
    $backupDir = sugar_cached('backups');
    $backupFile = 'backup-deleted-OpenCRM-' . date("Y-m-d_H-i-s") . '.php';

    /* Recuperation du delais de la purge */
    $configuratorObj = new Configurator();
    $configuratorObj->loadConfig();
    $delai = $configuratorObj->config['opensocle']['delai_purge_bdd'] ?? 30;

    $GLOBALS['log']->fatal(print_r("# Delai de suppression définitive : $delai jours",true));

    $db = DBManagerFactory::getInstance();
    $tables = $db->getTablesArray();
    $queryString = array();

    if (!empty($tables)) {
        foreach ($tables as $kTable => $table) {

            // find tables with deleted=1
            $columns = $db->get_columns($table);
            
            /* On va controler le delai avec la date modifié, donc si cette colonne n'existe pas on ne purge pas cette table */
            if(!array_key_exists("date_modified", $columns)){
                $GLOBALS['log']->fatal(print_r("# Table :  " . $table,true));
                $GLOBALS['log']->fatal(print_r("# La colonne 'date_modified' n'existe pas, cette table ne peut être purgée.",true));
                continue;
            }
            if (empty($columns['deleted'])) {
                continue;
            }

            /* Gestion des colonnes custom pour la creation du BACKUP, normalement on en a pas, mais on sait jamais */
            $custom_columns = array();
            if (array_search($table . '_cstm', $tables, true)) {
                $custom_columns = $db->get_columns($table . '_cstm');
                if (empty($custom_columns['id_c'])) {
                    $custom_columns = array();
                }
            }

            /*
                Recuperation des lignes à supprimer
                DATE_ADD(date_modified, INTERVAL X DAY) : (exemple) date modifié le 1er janvier + X jrs
                Si cette date est inferieur a la date du jour, c'est qu'on a depassé le delai 
            */
            $qDel = "SELECT * 
                     FROM $table 
                     WHERE deleted = 1 and  DATE_ADD(date_modified, INTERVAL " . $delai . " DAY) < CURDATE()";
            $rDel = $db->query($qDel);


            // make a backup INSERT query if we are deleting.
            while ($aDel = $db->fetchByAssoc($rDel, false)) {

                // build column names
                $queryString[] = $db->insertParams($table, $columns, $aDel, null, false);

                if (!empty($custom_columns) && !empty($aDel['id'])) {
                    $qDelCstm = 'SELECT * FROM ' . $table . '_cstm WHERE id_c = ' . $db->quoted($aDel['id']);
                    $rDelCstm = $db->query($qDelCstm);

                    // make a backup INSERT query if we are deleting.
                    while ($aDelCstm = $db->fetchByAssoc($rDelCstm)) {
                        $queryString[] = $db->insertParams($table, $custom_columns, $aDelCstm, null, false);
                    } // end aDel while()

                    $db->query('DELETE FROM ' . $table . '_cstm WHERE id_c = ' . $db->quoted($aDel['id']));
                }
            } // end aDel while()

            // now do the actual delete
            $db->query("DELETE FROM " . $table . " WHERE deleted = 1 and  DATE_ADD(date_modified, INTERVAL " . $delai . " DAY) < CURDATE()");

        } 
        if (!file_exists($backupDir) || !file_exists($backupDir . '/' . $backupFile)) {
            // create directory if not existent
            mkdir_recursive($backupDir, false);
        }

        // write cache file
        write_array_to_file('pruneDatabase', $queryString, $backupDir . '/' . $backupFile);

        $GLOBALS['log']->fatal(print_r("## Sauvegarde du backup : " . $backupDir . '/' . $backupFile,true));
        $GLOBALS['log']->fatal(print_r('## FIN DE LA TACHE PLANIFIEE DE PURGE DE BDD ##',true));
        return true;
    }

    $GLOBALS['log']->info('## FIN DE LA TACHE PLANIFIEE DE PURGE DE BDD ##');
    return false;
}