<?php
/**
 *  Mise par defaut du sous thème Lanteas à tous les utilisateurs
 */
$userBean = new User();
$activeUsers = $userBean::getActiveUsers();
/** @var User $user */
foreach ($activeUsers as $userId => $userName) {
    $user = new User();
    $user->retrieve($userId);
    $user->setPreference('user_theme', 'OEPLTheme');
    $user->setPreference('subtheme', 'Indigo');
    $user->savePreferencesToDB();
}

/*
 * Remise en place des fichiers du core SuiteCRM 
 */
$array_uninstall = array(
    "modules/Currencies/Currency.php",
    'modules/Studio/TabGroups/TabGroupHelper.php',
    'include/UploadFile.php',
    'include/generic/SugarWidgets/SugarWidgetFieldname.php',
    'include/ListView/ListViewDisplay.php',
    'include/MassUpdate.php',
    'include/MVC/View/SugarView.php',
    'include/Popups/Popup_picker.php',
    'include/Popups/PopupSmarty.php',
    'data/Relationships/M2MRelationship.php',
    'modules/DocumentRevisions/DocumentRevision.php',
    'modules/Studio/DropDowns/DropDownHelper.php',
    'modules/EmailTemplates/EmailTemplate.php',
    'modules/MergeRecords/Step3.php',
    'modules/Tasks/Save.php',
    'modules/Tasks/metadata/subpanels/ForActivities.php',
    'modules/Administration/upgrade_custom_relationships.php',
    'themes/OEPLTheme/css/Brown/style.css',
    'themes/OEPLTheme/css/Indigo/style.css',
    'themes/OEPLTheme/include/Dashlets/DashletHeader.tpl',
    'themes/OEPLTheme/include/MySugar/tpls/MySugar.tpl',
    'themes/OEPLTheme/include/MySugar/tpls/MySugar2.tpl',
    'themes/OEPLTheme/include/MySugar/tpls/addDashletsDialog.tpl',
    'themes/OEPLTheme/include/SubPanel/tpls/SubPanelTiles.tpl',
    'themes/OEPLTheme/tpls/_headerModuleList.tpl',
    'themes/OEPLTheme/themedef.php',
    'themes/OEPLTheme/include/EditView/actions_buttons.tpl',
    'themes/OEPLTheme/include/DetailView/actions_buttons.tpl',
    //Rapport
    "modules/AOW_WorkFlow/aow_utils.php",
    'modules/AOR_Reports/controller.php',
    'modules/AOR_Reports/AOR_Report.php',
    'modules/AOR_Reports/aor_utils.php',
    'modules/AOR_Conditions/AOR_Conditions.php',
    'modules/AOR_Fields/fieldLines.js',
    'include/TimeDate.php',
);
foreach ($array_uninstall as $file) {
    if (file_exists($file)) {
        rename($file,$file. "_origin" );
    }
} 

?>
