<?php
class Filtre_ExerciceViewUtils {

    private $smarty;
    private $template;
    private $type = "basique";


    public function __construct(){
        $this->smarty = new Sugar_Smarty();
        $this->template = "modules/OPS_dossier/tpls/gestion_dossier/generic/MenuDeroulantChoixMultipleCheckbox.tpl";
    }

    public function fetch(){
        $this->setData();
        return $this->smarty->fetch($this->template);
    }

    private function setData(){
        global $db;
        

        $query = "SELECT distinct id, name 
                    FROM ops_exercice 
                    where deleted = 0";
        $query = $db->query($query);
        

        $options = [];

        while($row = $db->fetchRow($query)){
            $options[$row['id']] = $row['name'];
        }
        $this->smarty->assign("OPTIONS", $options);

        $infosFiltre = OPS_dossier::getParamRequestToArray(("gestion_dossier"))['filtres_simples']['ops_exercice_id'] ?? array();
        $valeur = isset($infosFiltre['valeurs']) ? $infosFiltre['valeurs'] : "";

        $this->smarty->assign("NOM_LISTE", "Exercice");
        $this->smarty->assign("ICON", "fas fa-tag");
        $this->smarty->assign("NOM_CHAMP", "ops_exercice_id");
        $this->smarty->assign("VALEURS_SELECT", strval($valeur));
        $this->smarty->assign("NOM_TABLE", "ops_dossier");
        $this->smarty->assign("TYPE_CHAMPS", $this->type);
        $this->smarty->assign("OPTIONS", $options);

        
        
    }

    public function getOrdre(){
        return 2;
    }
}