<?php
class Indicateur_MtDemandeViewUtils {

    private $smarty;
    private $template;
    private $type = "relation";


    public function __construct(){
        $this->smarty = new Sugar_Smarty();
        $this->template = "modules/OPS_dossier/tpls/gestion_dossier/generic/TuileSimple.tpl";

    }

    public function fetch(){
        $this->recuperationDesDossiers();
        $this->setData();
        return $this->smarty->fetch($this->template);

    }

    private function setData(){
        global $db, $sugar_config;
        $montant = number_format(($_GET['totaux_montant']["montant_demande"] ?? 0), 2, $sugar_config['default_decimal_seperator'],$sugar_config['default_number_grouping_seperator'] );
        
        $this->smarty->assign("TITRE", "Mt demandé");
        $this->smarty->assign("VALEUR", $montant . " " .  $sugar_config['default_currency_symbol']);
        $this->smarty->assign("ICON", $this->getOrdre() % 2 == 0 ? "fa-solid fa-chart-area" : "fa-solid fa-chart-line");
        
    }


    /**
     * Cet indicateur est le premier des indicateurs a etre affiche
     * alors on fait la requete pour recuperer tous les montants
     * cela evite de faire une requete par tuile d'indicateur
     */
    private function recuperationDesDossiers(){
        global $db;
        
        $from = $_GET['from'];
        $where = $_GET['where'];
        if(empty($from)) return [];
        
        $query = "SELECT GROUP_CONCAT(ops_dossier.id SEPARATOR ',') as ids, SUM(ops_dossier.montant_demande) as montant_demande, SUM(ops_dossier.montant_propose) as montant_propose, SUM(ops_dossier.montant_vote) as montant_vote, SUM(ops_dossier.montant_total_engage) as montant_total_engage, SUM(ops_dossier.montant_total_mandate) as montant_total_mandate " . $from . $where ;
                
        $query = $db->query($query);
        $row = $db->fetchRow($query);

        // on met les IDS au cas ou un autre modules souhaite ajouter des indicateurs, on peut utiliser les ids pour faire des requetes..
        $row['ids'] = explode(",",$row['ids']);


        $_GET['totaux_montant'] = $row;
    }

    public function getOrdre(){
        return 1;
    }
}