<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class CreationDominiciliationBancaireAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Création d'une domiciliation bancaire "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'instruction';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Création d'une domiciliation bancaire "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Création d'une domiciliation bancaire";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Création d'une domiciliation bancaire "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Création de la domiciliation bancaire d'un demandeur ou d'un profil ou d'un bénéficiaire";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        global $app_list_strings;

        $tabReferentiel = get_bean_select_array(true, 'OPS_generateur_referentiel',"name", "",'name');
        $tabLiasion = [
            '' => '',
            'beneficiaire' => 'Bénéficiaire',
            'demandeur' => 'Demandeur',
            'profil' => 'Profil'
        ];

        $referentielListeTitulaire = get_select_options_with_id($tabReferentiel,$this->action->ext_valeur_1); 
        $referentielListeBic = get_select_options_with_id($tabReferentiel,$this->action->ext_valeur_2);
        $referentielListeIban = get_select_options_with_id($tabReferentiel,$this->action->ext_valeur_3);
        $referentielListeILiasion = get_select_options_with_id($tabLiasion,$this->action->ext_valeur_4);

        $data = [];

        $data['ext_valeur_1']['type']  = 'enum';
        $data['ext_valeur_1']['label'] = 'Nom du champ titulaire';
        $data['ext_valeur_1']['form']  = '<select name="ext_valeur_1" id="ext_valeur_1" style="width: 75%;">' . $referentielListeTitulaire . '</select>';

        $data['ext_valeur_2']['type']  = 'enum';
        $data['ext_valeur_2']['label'] = 'Nom du champ BIC';
        $data['ext_valeur_2']['form']  = '<select name="ext_valeur_2" id="ext_valeur_2" style="width: 75%;">' . $referentielListeBic . '</select>';

        $data['ext_valeur_3']['type']  = 'enum';
        $data['ext_valeur_3']['label'] = 'Nom du champ IBAN';
        $data['ext_valeur_3']['form']  = '<select name="ext_valeur_3" id="ext_valeur_3" style="width: 75%;">' . $referentielListeIban . '</select>';

        $data['ext_valeur_4']['type']  = 'enum';
        $data['ext_valeur_4']['label'] = 'Choix de la liaison';
        $data['ext_valeur_4']['form']  = '<select name="ext_valeur_4" id="ext_valeur_4" style="width: 75%;">' . $referentielListeILiasion . '</select>';


        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        global $app_list_strings, $beanFiles;
        require_once($beanFiles['User']);

        $data = [];
        $objReferentielTitulaire = (!empty($this->action->ext_valeur_1)) ? BeanFactory::getBean('OPS_generateur_referentiel', $this->action->ext_valeur_1) : null;
        $referentielTitulaireName = ($objReferentielTitulaire !== null && !empty($objReferentielTitulaire->name)) ? $objReferentielTitulaire->name : "";

        $objReferentielBic = (!empty($this->action->ext_valeur_2)) ? BeanFactory::getBean('OPS_generateur_referentiel', $this->action->ext_valeur_2) : null;
        $referentielBicName = ($objReferentielBic !== null && !empty($objReferentielBic->name)) ? $objReferentielBic->name : "";

        $objReferentielIban = (!empty($this->action->ext_valeur_3)) ? BeanFactory::getBean('OPS_generateur_referentiel', $this->action->ext_valeur_3) : null;
        $referentielIbanName = ($objReferentielIban !== null && !empty($objReferentielIban->name)) ? $objReferentielIban->name : "";

        $data['ext_valeur_1']['label'] = 'Nom du champ Titulaire';
        $data['ext_valeur_1']['type'] = 'enum';
        $data['ext_valeur_1']['valeur'] = "<p><span style='float:left;width:70%;' > ".$referentielTitulaireName." </span></p><br>";

        $data['ext_valeur_2']['label'] = 'Nom du champ BIC';
        $data['ext_valeur_2']['type'] = 'enum';
        $data['ext_valeur_2']['valeur'] = "<p><span style='float:left;width:70%;' > ".$referentielBicName." </span></p><br>";

        $data['ext_valeur_3']['label'] = 'Nom du champ IBAN';
        $data['ext_valeur_3']['type'] = 'enum';
        $data['ext_valeur_3']['valeur'] = "<p><span style='float:left;width:70%;' > ".$referentielIbanName." </span></p><br>";

        $data['ext_valeur_4']['label'] = 'Choix de la liaison';
        $data['ext_valeur_4']['type'] = 'enum';
        $data['ext_valeur_4']['valeur'] = "<p><span style='float:left;width:70%;' > ".$this->action->ext_valeur_4." </span></p><br>";

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        global $app_list_strings, $beanFiles;
        require_once($beanFiles['OPS_domiciliation']);

        if(!empty($this->dossier))
        {
            if(!empty($this->action->ext_valeur_1) && !empty($this->action->ext_valeur_2) && !empty($this->action->ext_valeur_3) && !empty($this->action->ext_valeur_4))
            {
                # récupération des noms des champs dans les param de l'action de statut 
                $obj_referentiel_titulaire =  BeanFactory::getBean('OPS_generateur_referentiel', $this->action->ext_valeur_1);
                $referentiel_titulaire_name = $obj_referentiel_titulaire->name;

                $obj_referentiel_bic =  BeanFactory::getBean('OPS_generateur_referentiel', $this->action->ext_valeur_2);
                $referentiel_bic_name = $obj_referentiel_bic->name;

                $obj_referentiel_iban =  BeanFactory::getBean('OPS_generateur_referentiel', $this->action->ext_valeur_3);
                $referentiel_iban_name = $obj_referentiel_iban->name;
                
                $referentiel_liaison_name = $this->action->ext_valeur_4;
                            
                #on récupère les valeurs des champs dans le dossier si ils existent sous format standard
                $standard_champ_titulaire = $this->dossier->$referentiel_titulaire_name;
                $standard_champ_bic       = $this->dossier->$referentiel_bic_name;
                $standard_champ_iban      = $this->dossier->$referentiel_iban_name;
                $standard_champ_liaison   = $referentiel_liaison_name;

                if( $standard_champ_liaison == "demandeur" ) 
                {        
                    $id_demandeur = $this->dossier->ops_individu_id;         
                    $ops_type_id = 'ops_individu_id';
                }elseif( $standard_champ_liaison == "beneficiaire" ) 
                {
                    $id_demandeur = $this->dossier->beneficiaire_id;
                    $ops_type_id = 'ops_individu_id';
                }elseif( $standard_champ_liaison == "profil" ) 
                {
                    $id_demandeur = $this->dossier->ops_personne_morale;
                    $ops_type_id = 'ops_personne_morale_id';                
                }
                
                #si les champs existent pas ou sont vide c'est qu'ils n'existent qui sont de type custom
                if(  empty($standard_champ_titulaire) && empty($standard_champ_bic) && empty($standard_champ_iban) ){
                    
                    #Récupération des champs custom
                    $custom_champ = json_decode( base64_decode( $this->dossier->fetched_row['champs_custom'] ) );

                    if( isset($custom_champ->$referentiel_titulaire_name) && !empty($custom_champ->$referentiel_titulaire_name ) && isset($custom_champ->$referentiel_bic_name) && !empty($custom_champ->$referentiel_bic_name) && isset($custom_champ->$referentiel_iban_name) && !empty($custom_champ->$referentiel_iban_name) ) {

                        $standard_champ_titulaire = mb_strtoupper($custom_champ->$referentiel_titulaire_name);
                        $standard_champ_bic       = $custom_champ->$referentiel_bic_name;
                        $standard_champ_iban      = $custom_champ->$referentiel_iban_name; 
                    
                    }                   
                }
                if( isset( $standard_champ_titulaire ) && !empty($standard_champ_titulaire) && isset( $standard_champ_bic ) && !empty($standard_champ_bic) && isset( $standard_champ_iban ) && !empty($standard_champ_iban) && isset( $standard_champ_liaison ) && !empty($standard_champ_liaison) && !empty($id_demandeur) )
                {
                    $domi_object = BeanFactory::getBean('OPS_domiciliation');
                    
                    $domi_result = $domi_object->get_list(
                                        $order_by = "",
                                        $where = "name = '" . $standard_champ_titulaire ."' AND iban = '" . $standard_champ_iban ."' AND bic = '" . $standard_champ_bic . "'",
                                        $row_offset = 0,
                                        $limit=-1,
                                        $max=-1,
                                        $show_deleted = 0);                  

                    #En fonction des params défini dans l'action de statut on récupère les données de l'individu ou perso morale 
                    if( $standard_champ_liaison == "demandeur" || $standard_champ_liaison == "beneficiaire" ) 
                    {
                        $indi_object = BeanFactory::getBean('OPS_individu', $id_demandeur);
                        $indi_object->load_relationship("ops_individu_ops_domiciliation");                                 
                    }elseif( $standard_champ_liaison == "profil" ) 
                    {
                        $indi_object = BeanFactory::getBean('OPS_personne_morale', $id_demandeur);
                        $indi_object->load_relationship("ops_personne_morale_ops_domiciliation");        
                    }

                    #pas de données existantes, on créé en DB 
                    if( $domi_result['row_count'] == 0 )
                    {
                        $this->insertDomiciliationData($indi_object, $standard_champ_titulaire, $standard_champ_bic, $standard_champ_iban, $standard_champ_liaison);
                    #Il existe une domiciliation identique en DB    
                    }elseif ( $domi_result['row_count'] == 1 ) 
                    {    
                    	$id_domiciliation = $domi_result['list'][0]->id;
                        $domi_object = BeanFactory::getBean('OPS_domiciliation', $id_domiciliation);
        
                        #demandeur a déjà un domi et il est identique
                        if ( $domi_object->$ops_type_id ==  $id_demandeur )
                        {
                        //aucun traitement, domi identique

                        #domi existe déjà mais pas sur le meme demandeur
                        }else
                        {
                            $this->insertDomiciliationData($indi_object, $standard_champ_titulaire, $standard_champ_bic, $standard_champ_iban, $standard_champ_liaison);
                        }
                        
                    #Il existe plusieurs domiciliation identique en DB    
                    }else
                    {
                        $domi_exist =  'non';
                        foreach ($domi_result['list'] as $key=>$value)
                        {
                            $id_domiciliation = $value->id;
                            $domi_object = BeanFactory::getBean('OPS_domiciliation', $id_domiciliation);

                            if ( $domi_object->$ops_type_id ==  $id_demandeur )
                            {
                                $domi_exist = 'oui';
                                break;
                            }
                        }

                        if(  $domi_exist == 'non' )
                        {                        
                            $this->insertDomiciliationData($indi_object, $standard_champ_titulaire, $standard_champ_bic, $standard_champ_iban, $standard_champ_liaison);                      
                        }
                        $GLOBALS['log']->fatal('domi_exist'. print_r($domi_exist, true));
                    }
                }else
                {
                     $GLOBALS['log']->fatal('Erreur sur Action statut domiciliation : champ titulaire + champ bic + champ iban sont vide ou id_demandeur vide' );
                } 
            }else
            {
                $GLOBALS['log']->fatal('un champ est vide dans le paramètrage de l\'action de statut');
            }
        }
    }


    public function insertDomiciliationData($object, $titulaire, $bic, $iban, $liaison){
        
        $domi_new_bean  = BeanFactory::newBean('OPS_domiciliation');
        $domi_new_bean->name = $titulaire;
        $domi_new_bean->bic = $bic;
        $domi_new_bean->iban = $iban;
        $domi_new_bean->save();

        if( $liaison == "demandeur" || $liaison == "beneficiaire" ) 
        {
            $object->ops_individu_ops_domiciliation->add($domi_new_bean);
        }elseif( $liaison == "profil" ) 
        {
            $object->ops_personne_morale_ops_domiciliation->add($domi_new_bean);
        }    
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne le nom du fichier javascript
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "";
    }


    
}
