$(document).ready(function () {
    on_objet_change();
});

var on_objet_change = function () {
    var valueObjet = document.getElementById('dashlet_objet').value;

    if (valueObjet) {
        $('#modele_dashlet').show();
        filtrer_modeles_dashlet(valueObjet);
    } else {
        $('#modele_dashlet').hide();
    }

    if (!valueObjet) {
        $('#filtres').hide();
    }
}

/**
 * Fonction permettant l'ajout, avant le champ "Description", des sélecteurs de colonnes à afficher et à masquer 
 */
var add_colonne_field = function (div_champ_name) {
    /* On ajoute avant le champ "Description" les sélecteurs de colonnes à afficher */
    var panel = document.getElementById('detailpanel_-1');
    var child = panel.querySelector('.tab-content');
    var clear_divs = child.querySelectorAll(".clear");
    var last_clear_div = clear_divs[clear_divs.length - 1];

    var display_tabs_dossier = document.getElementById(div_champ_name);

    last_clear_div.before(display_tabs_dossier);
}

/**
 * Fonction permettant de forcer la hauteur et largeur des champs des colonnes du dashlet (Colonnes affichées / Colonnes masquées)
 */
var modify_css_colonnes_select = function (hide_tabs_name, display_tabs_name) {
    $('#' + hide_tabs_name).attr('style', 'width: 250px !important;height: 200px !important');
    $('#' + display_tabs_name).attr('style', 'width: 250px !important;height: 200px !important');

    $('#display_tabs').addClass('display_tabs');
}

var checkbox_change_css = function (checkbox) {
    label = checkbox.parentNode;
    if (checkbox.checked) {
        label.style.backgroundColor = 'var(--main-bg-color)';
    } else {
        label.style.backgroundColor = '';
    }
}

var checkbox_verify_all_checked = function (checkbox) {
    var filtre_name = checkbox.dataset.nomFiltre;

    /*
     * On vérifie si toutes les cases du filtre sont cochées, si c'est le cas, on coche automatiquement "Tout sélectionner"
     * Sinon, on décoche automatiquement la case "Tout sélectionner"
     */
    if (checkbox.name) {
        var filtre_checkbox_list = document.querySelectorAll('#checkboxes_' + filtre_name + ' input[type=checkbox]');

        var all_checked = true;
        for (let i = 0; i < filtre_checkbox_list.length; i++) {
            if (filtre_checkbox_list[i].name) {
                if (!filtre_checkbox_list[i].checked) {
                    all_checked = false;
                }
            }
        };

        if (all_checked) {
            $('#' + filtre_name + '_tout_selectionner').prop("checked", true);
            document.getElementById(filtre_name + '_tout_selectionner').parentNode.style.backgroundColor = 'var(--main-bg-color)';
        } else {
            $('#' + filtre_name + '_tout_selectionner').prop("checked", false);
            document.getElementById(filtre_name + '_tout_selectionner').parentNode.style.backgroundColor = '';
        }
    }
}

var checkbox_select_all = function (checkbox) {
    label = checkbox.parentNode;
    div_checkboxes = label.parentNode;

    if (checkbox.checked) {
        label.style.backgroundColor = 'var(--main-bg-color)';
    } else {
        label.style.backgroundColor = '';
    }

    jQuery('#' + div_checkboxes.id + ' input[type=checkbox]').each(function () {
        if (checkbox.checked) {
            $('#' + this.id).prop("checked", true);
            checkbox_change_css(this)
        } else {
            $('#' + this.id).prop("checked", false);
            checkbox_change_css(this)
        }
    });
}

/*
 * Au moment du submit, on force la sélection des items dans "Colonnes affichées" pour assurer la sauvegarde
 * Solution générique : On vérifie l'element avec la classe "display_tabs" qui n'a pas d'attribut disabled
 */
var on_form_submit = function () {
    var list_select = document.getElementsByClassName('display_tabs');
    for (let i = 0; i < list_select.length; i++) {
        const select = list_select[i];

        if (!select.disabled) {
            var option;

            for (var j = 0; j < select.options.length; j++) {
                select.name = 'display_tabs[]';
                option = select.options[j];
                option.selected = true;
            }
        }
    }
}

/* 
 * Fonction permettant de filtrer dans le select des modèles de dashlets uniquement les modèles liés à l'objet sélectionné
 */
var filtrer_modeles_dashlet = function (objet) {
    var modele_select = document.getElementById('dashlet_modele');
    for (let i = 0; i < modele_select.options.length; i++) {
        const element = modele_select.options[i];
        if (element.value.includes(objet)) {
            element.style.display = '';
            // On met par défaut la valeur du modèle
            $('#dashlet_modele').prop("selectedIndex", i);
        } else {
            element.style.display = 'none';
        }
    }
}