<?php
if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

require_once('modules/OPS_dashlet/views/view.detail.php');

/** 
 * Classe appelée par le view.detail.php du module Dashlet permettant la récupération d'informations liés à l'objet "OPS_dossier"
 */
class OPS_justificatifDetail
{
    public $ss; // Variable du smarty actuel
    public $bean; // Variable du bean actuel

    public function __construct($objet)
    {
        $this->ss = $objet->ss;
        $this->bean = $objet->bean;
    }

    /**
     * Fonction d'assignation Smarty des variables contenant les valeurs des filtres du Dashlet
     *
     * @param array $filtres
     * @return void
     */
    public function assignValeursFiltres($filtres)
    {
        global $app_list_strings;

        $liste_types_justifs = array();
        $liste_statuts = array();
        $liste_depots = array();

        if ($filtres['ops_type_document_ops_justificatif_name']) {
            for ($i = 0; $i < count($filtres['ops_type_document_ops_justificatif_name']); $i++) { // Filtre sur la thématique
                if ($filtres['ops_type_document_ops_justificatif_name'][$i] != "") {
                    $bean_type_document = BeanFactory::getBean('OPS_type_document', $filtres['ops_type_document_ops_justificatif_name'][$i]);
                    $name_parent_type = $app_list_strings['ops_type_document_objet_list'][$bean_type_document->objet];
                    $liste_types_justifs[$name_parent_type][$i] = $bean_type_document->name;
                }
            }
        }
        $this->ss->assign('LISTE_TYPES_JUSTIFS_AFFICHEES', $liste_types_justifs);

        if ($filtres['statut']) {
            for ($i = 0; $i < count($filtres['statut']); $i++) { // Filtre sur la thématique
                if ($filtres['statut'][$i] != "") {
                    $key = $filtres['statut'][$i];
                    $liste_statuts[$i] = $app_list_strings['ops_statut_j_list'][$key];
                }
            }
        }
        $this->ss->assign('LISTE_STATUTS_AFFICHEES', $liste_statuts);

        if ($filtres['depot']) {
            for ($i = 0; $i < count($filtres['depot']); $i++) { // Filtre sur la thématique
                if ($filtres['depot'][$i] != "") {
                    $key = $filtres['depot'][$i];
                    $liste_depots[$i] = $app_list_strings['ops_depot_j_list'][$key];
                }
            }
        }
        $this->ss->assign('LISTE_DEPOTS_AFFICHEES', $liste_depots);
    }
}