<?php
if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

require_once('modules/OPS_dashlet/views/view.edit.php');

/**
 * Classe appelée par le view.edit.php du module Dashlet permettant la récupération d'informations liés à l'objet "Tasks"
 */
class TasksEdit
{
    public $ss; // Variable du smarty actuel
    public $bean; // Variable du bean actuel

    public function __construct($objet)
    {
        $this->ss = $objet->ss;
        $this->bean = $objet->bean;
    }

    /**
     * Fonction d'assignation Smarty des variables contenant les valeurs des filtres du Dashlet
     *
     * @param array $filtres
     * @return void
     */
    public function assignValeursFiltres($filtres = array())
    {
        global $app_list_strings;

        $liste_priorites = array();
        $liste_statuts = array();

        // Filtre sur les priorités de dossiers
        $liste_priorites = $app_list_strings['task_priority_dom'];
        asort($liste_priorites);
        $this->ss->assign('DASHLET_TACHE_FILTRES_PRIORITE', $liste_priorites);

        // Filtre sur les priorités de dossiers
        $liste_statuts = $app_list_strings['task_status_dom'];
        asort($liste_statuts);
        $this->ss->assign('DASHLET_TACHE_FILTRES_STATUT', $liste_statuts);

        $this->ss->assign('FILTRE_TACHE_PRIORITY', $filtres['priority']);
        $this->ss->assign('FILTRE_TACHE_STATUS', $filtres['status']);

        $this->ss->assign("DASHLET_CHAMPS_TACHES_LISTE", $app_list_strings['list_champs_taches']);
        $this->ss->assign("DASHLET_CHAMPS_TACHES_LISTE_DEFAUT", $app_list_strings['list_champs_taches_defaut']);
    }
}