<?php
use ODE\Helper\OdeArrayHelper;
use ODE\Model\DispositifModel;

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

class OPS_dispositifController extends SugarController
{

    public function action_getEtapesGuideInstruction(){
        global $current_user;

        $data_verified = OdeArrayHelper::isDataValid($_REQUEST, array("json" => true));
        $idDispositif = $data_verified['data']['json_array'][0];

        $resultats = DispositifModel::getEtapesGuideInstructionById($idDispositif);


        $tab_dispositif = $_SESSION['habilitation_dispositif'];
        $etapesDispositifAutorisation = $tab_dispositif[$idDispositif]["etapes"] ?? array();

        foreach($resultats as $row){
            if(!$current_user->isAdmin() && (!array_key_exists($row['id'], $etapesDispositifAutorisation) || $etapesDispositifAutorisation[$row['id']]['visualisation'] != 1)) continue;
            $options[$row['id']] = array(
                "name" => $row["name"],
                "instruction" => $row["instruction"],
                "nb" => $row["nb"]
            );
        }

        if(empty($etapesDispositifAutorisation) && !$current_user->isAdmin()) $options = [];
        $options = array('statut' => 'ok', 'data' => $options);


        if(empty($options['data'])) $options['statut'] = "err";

        ob_clean();
        echo json_encode($options);
        sugar_cleanup(true);

    }


}
