<?php


if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
require_once('include/MVC/View/SugarView.php');

include('modules/OPS_dossier/OPS_dossier_geo.php');


class ViewGeoloc extends SugarView
{
	
	public function __construct($bean = null,$view_object_map = array())
	{
		parent::__construct($bean, $view_object_map);
	}

	public function preDisplay()
	{
		if (!$this->bean->ACLAccess('edit')) {
			ACLController::displayNoAccess();
			sugar_die('Access Denied Generateur flux');
		}
	}

	/**
	 * @see SugarView::display()
	 */
	public function display()
	{

		global $beanList, $beanFiles, $app_list_strings, $mod_strings, $sugar_config, $current_user;

		global $beanList, $beanFiles, $app_list_strings, $mod_strings, $sugar_config, $current_user;
		
		// Vérification si 'l'utilisateur a accès a la liste de dossiers 
		$req_where = $_SESSION['ops_requete_dossier'];

		if ( !$current_user->isAdmin() && $req_where == false ) {

			SugarApplication::appendErrorMessage("Vous n'avez pas accès à cette zone, veuillez contacter votre administrateur");
			SugarApplication::redirect('index.php');

		}
		else{

			// Ok on Smartie's ;)
			
			$smarty = new Sugar_Smarty();
			$obj_dossier_geo = new OPS_dossier_geo(); // Implémentation permettant la génération de filtres dynamiques.


		  //  $GLOBALS['log']->fatal(" ViewGeoloc :: display");
			$current_template = "modules/OPS_dossier/tpls/geoloc.tpl";
			


			// Alimente le titre de la vue.
			$smarty->assign('titre', "Carte des dossiers");


			// On récupère l'ensemble des dossiers avec leur situation et géographie
			$geo_dossiers = json_encode($this->get_dossiers_geo());
			$smarty->assign('geo_dossiers',$geo_dossiers); // Peuple un garbage collecteur disponible en front via un textarea.
			// (Préservation des unicode et utf-8/16 ainsi que les caractères diacrityques)


			// On enrichie des paramètre de configuration utile au fonctionnement applicatif.
			$object_name = $geo_dossiers->object_name;
		//$GLOBALS['log']->fatal(" ViewGeoloc :: JSON Dossiers Geo Structure (Module Name): ".print_r( $object_name ,true));
			$smarty->assign('object_name',	   'OPS_dossier'); // From the current Module Name
			$smarty->assign('geo_initial_zoom',  '5');
			$smarty->assign('geo_min_zoom',	  '5');
			$smarty->assign('geo_max_zoom',	  '19');
			$smarty->assign('geo_initial_lng',   '45.30580259943578');
			$smarty->assign('geo_initial_lat',   '14.314627161286037');
			$smarty->assign('geo_maximum_points','5000');



			// Declare les filtres...
			// Exploite la classe « OPS_dossier_geo » via l'objet « obj_dossier_geo »
			$filters = array();
			$filters[] = $obj_dossier_geo->addGeoSelectFilter('Dispositif', 'dispositif', 'name', '_action_select_filter', 'class:"custom-css-class"' ,'master');
			$filters[] = $obj_dossier_geo->addGeoSelectFilter('Exercice', 'exercice', 'name', '_action_select_filter', 'class:"custom-css-class"' ,'');

			// Build Filters
			$smarty->assign('geo_dossiers_filters', implode( "\n" , $filters) );



			// Build Detail URL / When the user want to see GPS error in « Dossiers »
			$redirect_url = '/index.php?module=OPS_dossier&filter=nogps';
			$smarty->assign('geo_dossiers_url_nogps', $redirect_url );



			$smarty->display($current_template);			  
		}

	}



	public function get_dossiers_geo(){

		global $current_user;


		$obj_dossier	= new OPS_dossier_geo();
		$obj_dispositif = new OPS_dispositif();



		// Defines a default structure if null or if we try to get at the first time if no entry.
		$_default_structure = json_encode( array( 
			"json_structure" => '{"date":"'.date('Y-m-d').'T'.date('H:i:s').'.700Z","folders":[],"filters":[]}' 
		) );


		$ops_dossiers_geo = json_decode( $_default_structure );
		//$GLOBALS['log']->fatal(" ViewGeoloc :: JSON Dossiers Geo Structure (before/default): ".print_r( json_decode($ops_dossiers_geo->json_structure) ,true));



		// On récupre la liste des dossiers 
		$liste_dossier  = $obj_dossier->get_full_list_custom(  );
	//	$liste_dispo	= $obj_dispositif->get_full_list();



		// On associe une variable qui reflète la structure JSON <JSON Structure> au format Array.
		$json_structure = json_decode($ops_dossiers_geo->json_structure);

		

		//$GLOBALS['log']->fatal(" ViewGeoloc :: Habilitations Dispositifs (Collecteur Session): ".print_r( $_SESSION ,true));

		foreach ($liste_dossier as $key => $dossier) {

			/**
			 * Test de condition si ce dossier dispose de l'habilitation.
			 * Vérifie si in on trouve dans la liste des dispositifs id 
			 */


			/**
			 * On récupère des informations au sujet du dossier ou qui y sont associées, et
			 * qu'on va assembler dans une variable pour la pousser dans le collecteur <JSON Structure>.
			 */
			$base_dossier = array();


			/** * Informations concernant le dossier * */

			$dateFormat = $current_user->getPreference('datef') . " " . $current_user->getPreference('timef');
            $db_format = 'Y-m-d H:i:s';
			$date_entered   = DateTime::createFromFormat($db_format, $dossier->date_entered);

			$base_dossier['identity'] = array(
				'id'   => $dossier->id,
				'name' => htmlentities( $dossier->name , ENT_COMPAT),
				'num'  => $dossier->num_dossier,
				'date' => $date_entered->format($dateFormat)
			);



			/** * Informations concernant l'exercice * */

			// Récupere l'id de l'exercice asssocié au dossier 
			$id_exercice = $dossier->ops_exercice_id;

			// Récupere l'objet exercice 
			$obj_exercice = BeanFactory::getBean('OPS_exercice', $id_exercice);

			// Récupere le nom de l'exercice 
			$exercice_name = ( !empty($obj_exercice->name) ) ?  $obj_exercice->name : "Sans exercice";

			$base_dossier['exercice'] = array(
				'id'   => $id_exercice,
				'name' => $exercice_name
			);

			/** * Informations concernant le dispositif * */

			$liste_dispositifs = $dossier->get_linked_beans("ops_dispositif_ops_dossier","OPS_dispositif");
			$dispositif = ( is_array($liste_dispositifs) && count($liste_dispositifs) == 1 ) ? $liste_dispositifs[0] : false;
			$dispositif_id = ( $dispositif !== false ) ? $dispositif->id : false; 
			$dispositif_name = ( $dispositif !== false ) ? $dispositif->name : 'Sans dispositif';

			$base_dossier['dispositif'] = array(
				'id'   => $dispositif_id,
				'name' => $dispositif_name
			);


			/** * Informations concernant le demandeur * */
            // Un seul demandeur possible sinon rien !
            if(trim($dossier->type_tiers) == "Individu"){

                $demandeurs = $dossier->get_linked_beans("ops_individu_ops_dossier","OPS_individu");
                $name_demandeur = ( is_array($demandeurs) && count($demandeurs) == 1 ) ? $demandeurs[0]->name : false;  
            
            }elseif( trim($dossier->type_tiers) =="Personne Morale"){ // TO DO A REVOIR

                $demandeurs = $dossier->get_linked_beans("ops_personne_morale_ops_dossier","OPS_personne_morale");
                $name_demandeur = ( is_array($demandeurs) && count($demandeurs) == 1 ) ? $demandeurs[0]->name : false;  
            
            }else{
                $name_demandeur = "<div>Oups !</div>";
            }


            //$GLOBALS['log']->fatal(" ViewGeoloc :: JSON Dossiers Geo Structure (before/default): ".print_r( $name_demandeur ,true));

			$base_dossier['demandeur'] = array(
				'label'   => $name_demandeur
			);


			/** * Informations concernant le statut et le geo-positionnement du marqueur * */
			/**/

			// Récupère le code couleur relatif au statut
			$statut_id = $dossier->ops_statut_id;
			$obj_statut = BeanFactory::getBean('OPS_statut', $statut_id);

			$code_couleur = ( !empty($obj_statut->id) ) ? $obj_statut->code_couleur : 'rgb(150,165,180)';


			// Récupère les coordonnées GPS
			$longitude = ( empty($dossier->longitude) || $dossier->longitude == "0")? '0' : $dossier->longitude;
			$latitude  = ( empty($dossier->latitude)  || $dossier->latitude  == "0")? '0' : $dossier->latitude;

			$base_dossier['point'] = array(
				'longitude'	  => $longitude,
				'latitude'	   => $latitude,
				'marker_color'   => $code_couleur,
				'marker_icon'	=> 'default',
				'marker'		 => null
			);


			$statut_instruction = ( !empty($obj_statut->id) ) ? $obj_statut->name : 'Pas de statut !';


			// Récupère l'étape d'instruction relative à l'étape
			$etape_id = $dossier->ops_etape_id;
			$obj_etape = BeanFactory::getBean('OPS_etape', $etape_id);

			$etape_instruction = ( !empty($obj_etape->id) ) ? $obj_etape->name : 'Etape non définie !';

			$base_dossier['instruction'] = array(
				'statut'	   => $statut_instruction,
				'etape'		=> $etape_instruction
			);


			array_push($json_structure->folders, $base_dossier);
			
		}


	/**
	 * Fake sample |dossiers
	 * 
	 */  /** /
	$qt = 2000;
	for( $i = 0; $i < $qt; $i++){

		$base_dossier = $this->_get_fake_dossiers_geo();
		array_push($json_structure->folders, $base_dossier);

	}
	/**/

		
		$ops_dossiers_geo->json_structure = json_encode( $json_structure );
		//$GLOBALS['log']->fatal(" ViewGeoloc :: JSON Dossiers Geo : ".print_r( ( $ops_dossiers_geo ) ,true));
		




		return $json_structure;

	}



	public function _get_fake_dossiers_geo(){

		$base_dossier = array();

		$base_dossier['identity'] = array(
			'id'   => $this->get_random_anid(),
			'name' => '@ - '. strtoupper( $this->get_scrambled_word() )
		);

		$base_dossier['details'] = array(
			'ask'   => true
		);
		
		$exo = $this->get_random_year();
		$base_dossier['exercice'] = array(
			'id'   => $exo['id'],
			'name' => $exo['name'],
		);
		$base_dossier['dispositif'] = array(
			'id'   => $this->get_random_anid(),
			'name' => $this->get_scrambled_word()
		);
		$base_dossier['point'] = array(
			'longitude'	  => $this->get_random_longitude(),
			'latitude'	   => $this->get_random_latitude(),
			'marker_color'   => $this->get_random_rgb(),
			'marker_icon'	=> 'default',
			'marker'		 => null
		);

		$base_dossier['popup'] = 0;


		return $base_dossier;

	}


	public function get_random_anid()
	{
	   $chars = 'abcdef1234567890';
	   $anid  = str_shuffle( substr(str_shuffle($chars),0,8) ) .'-';
	   $anid .= str_shuffle( substr(str_shuffle($chars),0,4) ) .'-'; 
	   $anid .= str_shuffle( substr(str_shuffle($chars),0,4) ) .'-';
	   $anid .= str_shuffle( substr(str_shuffle($chars),0,4) ) .'-'; 
	   $anid .= str_shuffle( substr(str_shuffle($chars),0,12) );
	   //d0ed4800-1dbd-f37c-9270-5edfa98bde42
	   return $anid;
	}

	public function get_random_year()
	{
	   $ids   = ['413029ea-475f-4b1e-fa28-0167c43d9a8f','c6791e84-f536-4cd7-bc94-6a21359fc704','91b5f7c6-da30-b4af-36ec-b4fde951360c'];
	   $names = ['2017','2018','2019'];
	   return array(
		'id'   => $ids[ mt_rand( 0, sizeof($names)-1 ) ],
		'name' => $names[ mt_rand( 0, sizeof($names)-1 ) ]
	   );
	}

	public function get_random_longitude()
	{
	   $c = mt_rand( 0, 359 ) .'.'. mt_rand( 0, 9 ). mt_rand( 0, 9 ). mt_rand( 0, 9 ). mt_rand( 0, 9 ). mt_rand( 0, 9 ). mt_rand( 0, 9 ). mt_rand( 0, 9 ). mt_rand( 0, 9 );
	   return $c;
	}

	public function get_random_latitude()
	{
	   $c = mt_rand( -89, 89 ) .'.'. mt_rand( 0, 9 ). mt_rand( 0, 9 ). mt_rand( 0, 9 ). mt_rand( 0, 9 ). mt_rand( 0, 9 ). mt_rand( 0, 9 ). mt_rand( 0, 9 ). mt_rand( 0, 9 );
	   return $c;
	}

	public function get_random_rgb()
	{
	   return 'rgb('. mt_rand( 0, 255 ) .','. mt_rand( 0, 255 ) .','. mt_rand( 0, 255 ) .')';
	}

	public function get_scrambled_word() {

		$words = "Situation Sujet Demarche Conforme Alarme Insectes Brebies Vignoble Irrigation Forets";
		$w = explode(' ', $words);
		shuffle($w);
		$qt = mt_rand( 3, mt_rand( 3, sizeof($w) ) );

		return ucfirst( strtolower( implode( ' ', array_slice($w, 0, $qt) ) ) );

	}

}

?>   
