<?php

 if(!defined('sugarEntry') || !sugarEntry) die ('Not a valid Entry Point');

 require_once('data/SugarBean.php');

class hook_etape extends SugarBean
{

	function display_etape (&$bean , $event, $arguments)
	{
		$bean->instruction = html_entity_decode($bean->instruction);
	}

	/**
	 * Lors de la suppression de l'étape, nous récupérons tout les dossiers lié à celle-ci pour leur attribué leur ancienne étape.
     * 
	 * @param {object} bean      - Étape qui va être supprimée.
	 * @param {string} event     - Événement du logic hook.
	 * @param {array}  arguments - Données en plus sur la suppression.
	 */
	function replace_etape (&$bean , $event, $arguments)
	{
		if($event != 'before_delete') {
          return;
        }

        $obj_dossier = BeanFactory::newBean('OPS_dossier');

        // Appel de la méthode get_full_list() pour récupérer la liste complète des dossiers lié à l'étape supprimé
        $liste_dossier = $obj_dossier->get_full_list(
            'num_dossier',
            'ops_dossier.ops_etape_id = "' . $bean->id . '"',
            false,
            0
        );
        
        // Pour chaque dossier, on change son étape et son statut
        foreach($liste_dossier as $dossier)
        {
            $liste_historique = $dossier->get_linked_beans(
                'ops_historisation_ops_dossier', 
                'OPS_historisation', 
                '', 
                0, 
                -1, 
                0, 
                "flag_retour = '1'"
            );

            // On cherche dans l'historique d'instruction le dernier statut qui n'est pas lié à l'étape supprimé pour le réapliquer
            foreach ($liste_historique as $obj_historique) 
            {
                if(!empty($obj_historique->ops_etape_id))
                {
                    $etape = BeanFactory::getBean('OPS_etape', $obj_historique->ops_etape_id);

                    if($obj_historique->ops_etape_id == $bean->id || empty($etape->id)) 
                    {
                        continue;
                    }

                    if(!empty($obj_historique->ops_statut_id))
                    {
                        $dossier->updateStatut( 
                            $obj_historique->ops_statut_id,
                            null,
                            true,
                            ''
                        );

                        break;
                    }
                }
            }
        }

        # On supprime aussi les habilitations étapes lié à cette étape

        // Appel de la méthode get_full_list() pour récupérer la liste complète des dossiers lié à l'étape supprimé
        $liste_habilitation = $bean->get_linked_beans(
            'ops_habilitation_etape_ops_etape', 
            'OPS_habilitation_etape', 
        );

        foreach($liste_habilitation as $habilitation)
        {
            $habilitation->mark_deleted($habilitation->id);
            $habilitation->save();
        }
	}
}

?>