<?php

use ODE\Helper\OdeArrayHelper;

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

require_once 'include/MassUpdate.php';

class OPS_fluxController extends SugarController
{

    /**
     * @access public
     * @name action_initChoixFlux()
     * Fonction pour initialiser le formulaire pour lancer un flux en action par lot
     * 
     *  @param array						    $_REQUEST : les données transférées en Ajax
     *  @return json				            $data : Json avec un statut ( ok/err ) + les données d'initialisation' ou le libellé de l'erreur
     */
    public function action_initChoixFlux()
    {

        $resultat = array('erreur' => "");
        $dossiers_selected_ids = array();
        $dossiers_selected_nums = array();

        $data_verified =  $this->getDossiers($_REQUEST);

        if ($data_verified['statut'] == 'ok') {

            $dossiers_ids = $data_verified['data'];
            foreach ($dossiers_ids as $dossier_id) {
                $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
                if (!empty($obj_dossier->id)) {
                    $dossiers_selected_ids[] = $obj_dossier->id;
                    $dossiers_selected_nums[] = $obj_dossier->num_dossier;
                }
            }

            if (is_array($dossiers_selected_ids) && count($dossiers_selected_ids) > 0) {
                sort($dossiers_selected_nums);
                $resultat['dossiers_selected'] = array(
                    'nb' => count($dossiers_selected_ids),
                    'ids' => implode("|", $dossiers_selected_ids),
                    'nums' => implode(", ", $dossiers_selected_nums)
                );
            }

            $obj_flux = new OPS_flux;
            $liste_flux = $obj_flux->get_full_list("name ASC");
            foreach ($liste_flux as $flux) {
                $is_lot = ($flux->action_lot == 'groupe' && $flux->methode == 'post') ? "oui" : "non";
                $resultat['flux'][$flux->id] = array('name' => $flux->name, 'description' => str_replace("&#039;", "'", $flux->description), 'is_lot' => $is_lot);
            }
        } else {
            $resultat['erreur'] = $data_verified['data'];
        }

        $data = (empty($resultat['erreur'])) ? array('statut' => 'ok', 'data' => $resultat) : array('statut' => 'err', 'data' => $resultat);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * @name action_initChoixUnitaire()
     * Fonction pour initialiser le formulaire pour lancer un flux en action unitaire
     * 
     *  @param array						    $_REQUEST : les données transférées en Ajax
     *  @return json				            $data : Json avec un statut ( ok/err ) + les données d'initialisation' ou le libellé de l'erreur
     */
    public function action_initChoixUnitaire()
    {

        $resultat = array('erreur' => "");

        $dossier = base64_decode($_REQUEST['json']);
        $dossier = json_decode($dossier);

        if (!empty($dossier->dossier_id)) {

            $dossier_id = $dossier->dossier_id;
            $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
            if (!empty($obj_dossier->id)) {
                $resultat['dossier_id'] = $obj_dossier->id;
                $resultat['dossier_num'] = $obj_dossier->num_dossier;
            } else {
                $resultat['erreur'] = "Dossier id = " . $obj_dossier->id . " est introuvable ";
            }

            $obj_flux = new OPS_flux;
            $liste_flux = $obj_flux->get_full_list("name ASC");
            foreach ($liste_flux as $flux) {
                $is_lot = ($flux->action_lot == 'groupe' && $flux->methode == 'post') ? "oui" : "non";
                $resultat['flux'][$flux->id] = array('name' => $flux->name, 'description' => str_replace("&#039;", "'", $flux->description), 'is_lot' => $is_lot);
            }
        } else {
            $resultat['erreur'] = "L'id du dossier n'a pas pu etre récupérer";
        }

        $data = (empty($resultat['erreur'])) ? array('statut' => 'ok', 'data' => $resultat) : array('statut' => 'err', 'data' => $resultat);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * @name getDossiers()
     * Fonction pour retourne les ids des dossiers séléctionnés 
     * 
     *  @param array						    $_REQUEST : les données transférées en Ajax
     *  @return array				            $data : array avec un statut ( ok/err ) + les données ou le libellé de l'erreur
     */
    private function getDossiers($request)
    {

        global $db;
        $libelle_erreur = '';
        $dossiers = [];

        do {

            $data_verified = OdeArrayHelper::isDataValid($request, ["json" => true]);
            if ($data_verified['statut'] === "err") {
                $libelle_erreur = 'Aucun dossier n\'a été récupéré';
                break;
            }

            $data = $data_verified["data"]["json_array"];

            if (!empty($data['dossiers']) && is_array($data['dossiers']) && count($data['dossiers']) > 0) {
                $dossiers = $data['dossiers'];
                break;
            }
            if (!empty($data['filtres'])) {
                $json = htmlentities(json_encode($data['filtres']), ENT_QUOTES, 'UTF-8');
                // Ce traitement est utilisé dans le cas ou l'utilisateur sélectionne l'intégralité des dossiers + filtres
                $mass = new MassUpdate();
                $mass->generateSearchWhere('OPS_dossier', $json);
                $where_clause = $mass->where_clauses;
                $obj_dossier = new OPS_dossier();
                $query = $obj_dossier->create_export_query("", $where_clause);
                $queryExplode = explode('FROM',$query);
                $queryExplode[0] = 'SELECT ops_dossier.id';
                $query = implode(' FROM', $queryExplode);
                $query = OPS_dossier::cleanQueryActionLot($query,array('ops_sous_territoire','ops_dossier','ops_elu'));
                $result = $db->query($query);
                while ($dossier = $db->fetchByAssoc($result)) {
                    $dossiers[] = $dossier['id'];
                }
            }

            // Je ne vérifie pas si $request['selectAll'] est non vide, empty($request['selectAll']) retourne true quand $request['selectAll']=0
            if (!is_array($dossiers) || count($dossiers) === 0) {
                $libelle_erreur = 'Aucun dossier n\'a été récupéré';
                break;
            }
        } while (0);

        // Si on a aucune erreur le statut est à 'ok' et on retourne les données formatées sinon le statut passe à 'err' et on retourne le libelle de l'erreur 
        $data = (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => $dossiers) : array('statut' => 'err', 'data' => $libelle_erreur);

        return $data;
    }

    /**
     * @access public
     * @name action_lancerFluxByDossier()
     * Fonction pour déclencher un flux par dossier
     * 
     *  @param array						    $_REQUEST : les données transférées en Ajax
     *  @return json				            $resultat_flux : Json avec un statut ( ok/err ) + le résultat du déclenchement du flux ou le libellé de l'erreur
     */
    public function action_lancerFluxByDossier()
    {

        $resultat_flux = array('statut' => 'err', 'data' => array());
        $champs = array("json" => true);

        $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, $champs);
        if ($data_verified['statut'] == 'ok') {

            $data_decode = base64_decode($data_verified['data']['json_array']);
            $donnees = json_decode($data_decode);
            $resultat_flux['data']['dossier_num'] = $this->getDossierNum($donnees->dossier_id);
            $resultat_flux['data']['dossier_name'] = $this->getDossierName($donnees->dossier_id);
            $resultat_flux['data']['dossier_id'] = $donnees->dossier_id;

            // On récupere le flux concerné et on utilise la fonction getDonneesFlux de OPS_flux pour récuperer les données à envoyer
            $obj_flux = BeanFactory::getBean('OPS_flux', $donnees->flux_id);
            $donnees_flux = $this->getDonneesFlux($obj_flux, $donnees->dossier_id);

            if (!empty($donnees_flux['statut']) && $donnees_flux['statut'] === "ok") {

                // On vérifie si le flux doit etre envoyer en [{JSON}] ou {JSON}
                $donnees_flux['data'] = ($obj_flux->action_lot == 'groupe' && $obj_flux->methode == 'post') ? "[" . $donnees_flux['data'] . "]" : $donnees_flux['data'];

                // On déclenche le flux et on retourne le résultat
                $retour_declencher_flux = $obj_flux->declencher_flux($donnees_flux['data']);
                $resultat_flux['data']['data_retour'] = $retour_declencher_flux['data'];
                $resultat_flux['statut'] = $retour_declencher_flux['statut'];
            } else {
                $resultat_flux['data'] = $donnees_flux['data'];
            }
        } else {
            $resultat_flux['data'] = $data_verified['data'];
        }

        ob_clean();
        echo json_encode($resultat_flux);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * @name action_lancerFluxDossiers()
     * Fonction pour déclencher un flux en lot 
     * 
     *  @param array						    $_REQUEST : les données transférées en Ajax
     *  @return json				            $resultat_flux : Json avec un statut ( ok/err ) + le résultat du déclenchement du flux ou le libellé de l'erreur
     */
    public function action_lancerFluxDossiers()
    {


        $resultat_flux = array('statut' => 'err', 'data' => array());
        $champs = array("json" => true);

        $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, $champs);
        if ($data_verified['statut'] == 'ok') {

            $donnees = $data_verified['data']['json_array'];

            // On récupere le flux et on explode le string ids
            $obj_flux = BeanFactory::getBean('OPS_flux', $donnees['flux_id']);
            $ids = explode("|", $donnees['dossiers_ids']);

            if (is_array($ids) && count($ids) > 0) {
                $trame_groupe = "[";
                $resultat_flux['data']['dossiers'] = "";
                foreach ($ids as $key => $dossier_id) {
                    $donnees_dossier = $this->getDonneesFlux($obj_flux, $dossier_id);
                    if (!empty($donnees_dossier['statut']) && $donnees_dossier['statut'] === "ok") {
                        $trame_groupe .= ($key !== 0) ? "," . $donnees_dossier['data'] : $donnees_dossier['data'];
                        $resultat_flux['data']['dossiers'] .= ($key !== 0) ? ", " . $this->getDossierNum($dossier_id) : $this->getDossierNum($dossier_id);
                    }
                }
                $trame_groupe .= "]";

                // On déclenche le flux et on retourne le résultat
                $retour_declencher_flux = $obj_flux->declencher_flux($trame_groupe);

		$resultat_flux['data']['data_retour'] = $retour_declencher_flux['data'];
                $resultat_flux['statut'] = $retour_declencher_flux['statut'];
            } else {
                $resultat_flux['data'] = 'Aucun dossier séléctionné';
            }
        } else {
            $resultat_flux['data'] = $data_verified['data'];
        }
            $GLOBALS['log']->fatal("action_lancerFluxDossiers resultat_flux: ".print_r($resultat_flux,true ) );

        ob_clean();
        echo json_encode($resultat_flux);
        sugar_cleanup(true);
    }

    /**
     * @access private
     * @name getDossierNum()
     * Fonction qui retourne le numéro du dossier
     * 
     *  @param string						    $dossier_id : L'id du dossier
     *  @return string				            $dossier_num : Le numéro du dossier
     */
    private function getDossierNum($dossier_id)
    {

        $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
        return (!empty($obj_dossier->id)) ? $obj_dossier->num_dossier : "";
    }

    /**
     * @access private
     * @name getDossierName()
     * Fonction qui retourne le libellé du dossier
     * 
     *  @param string						    $dossier_id : L'id du dossier
     *  @return string				            $dossier_name : Le libellé du dossier
     */
    private function getDossierName($dossier_id)
    {

        $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
        return (!empty($obj_dossier->id)) ? $obj_dossier->name : "";
    }

    /**
     * @access private
     * getDonneesFlux()
     * Fonction qui retourne les données du Json à envoyer, les variables ont été remplacés par leurs valeurs
     * Vérifie en amont que le flux et le dossier ont bien été récupérés
     */
    private function getDonneesFlux($flux, $dossier_id)
    {

        $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
        return (!empty($flux->id) && !empty($obj_dossier->id)) ?  $flux->get_donnees_bean($obj_dossier) : false;
    }
}
