console.clear();

/* ******************************************************* *****************************
 * Blister Javascript ToolSet, Extending JS Objects       |           Javascript helpers
 * @author Tocra! Web-Medias
 */

    /** Transcode properly Base64 to|from UTF-8 **/
    String.prototype.utf8_to_b64=function(){return $.base64.encode(unescape(encodeURIComponent(this)))};
    String.prototype.b64_to_utf8=function(){return decodeURIComponent(escape($.base64.decode(this)))};

    /** Returns a properly escaped Unicode16 string from a base64 decoded to use with INPUT Element setteable . **/
    String.prototype.eub64_to_val = function() {return unescape(atob(btoa(this)))};

    /** Returns a string slug format. IE10fail **/
    String.prototype.slugify = function() { var _string = this; _string = _string.toUpperCase().normalize('NFD').replace(/[\u0300-\u036f]/g, "").trim().replace( /['_.]|(\s)/g, "-" ).replace( /[^a-zA-Z0-9-]/g, "-" ).replace( /([-]+)/g, "-" ).replace( /(^[-]|[-]$)/g, "" ).toLowerCase(); return _string; };

    /** Allows to generate an identifier alpha-numeric based with a given length. $.fn.getUniqueId(12) **/
    $.fn.extend({getUniqueId:function(n){charSet="abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",charSetSize=charSet.length,charCount=n;for(var t="",a=1;a<=charCount;a++){var e=Math.floor(Math.random()*charSetSize);t+=charSet[e]} return t}});





// Application User Interface
if( typeof(AppUI) == 'undefined' ){ var AppUI = { loaded:false }; }




/* ******************************************************* *****************************
 * Declarative part : AppUI methods...
 *
 */

    AppUI.autoExpand = function (textarea) {
        // Reset field height
        $(textarea).css( {'height':0} );
        // Get the computed styles for the element
        var computed = window.getComputedStyle( $(textarea).get(0) );
        $(textarea).css( {'height':'inherit !important' , 'min-height':'unset !important'} );
        // Calculate the height
        var height = parseInt(computed.getPropertyValue('border-top-width'), 10)
                     + $(textarea).get(0).scrollHeight
                     + parseInt(computed.getPropertyValue('border-bottom-width'), 10)
        $(textarea).css( {'height':height+'px' , 'min-height': parseInt(computed.getPropertyValue('min-height'), 10)+'px'} );
    };



    AppUI.prepareJSONArea = function () {

        if( $('textarea#text_area_json').length > 0 ){
            console.log(" ⮱ Préparation de la grappe JSON et de son collecteur");
            
            $textarea_json = $('textarea#text_area_json');

            // Valeur renvoyée par le php : "" ou " " ou null ou '' => value du text area = [] , On delete si c'est le cas et on fixe aà vide.
            var regex = / /gi;
            if( "[]" == $textarea_json.val().replace(regex,'') ){
                $textarea_json.val("");
            }

            void AppUI.jsonBeautifier( $textarea_json );
            void AppUI.autoExpand( $textarea_json );

            $textarea_json.off().on("change input cut paste blur", function(e){ 
                void AppUI.jsonBeautifier( $(this) );
                void AppUI.autoExpand( $(this) );
            });

        }else{
            console.log(" ⮱ Le collecteur de grappe JSON est manquant !");
        }

    };


    AppUI.jsonBeautifier = function (ta_recipient) {
        
        $ta_recipient = $(ta_recipient);
        json_str_value = $ta_recipient.val();
        
        if( is_json(json_str_value) ){
            cacher_erreur();
            let JSON_Feed_Tree = jQuery.parseJSON( json_str_value || JSON.stringify( {} ) );
            let json_beautyful_str = JSON.stringify(JSON_Feed_Tree, null, '\t'); // Stringifyer indent mode.
            $ta_recipient.val( json_beautyful_str );
            
        }else{
            afficher_erreur("Le texte inséré ne correspond pas à la structure d'un JSON ");
        }

    };


    AppUI.populateFiltersSelectors = function () {
        
        if( $('textarea[role="json-data-flux"]').length > 0 ){
        
            console.log(" ⮱ Nettoyage de la grappe JSON");
            // On nettoie et on s'assurede disposer d'une grappe JSON valide, on la rend jolie par la même occasion en cas de debugage visuel.
            void AppUI.jsonBeautifier( $('textarea[role="json-data-flux"]') );

        }else{
            console.log(" ⮱ Les données de peuplement des sélecteurs de filtres n'ont pas pu être récoltées !");
        }



        // Peuplement des selecteurs de filtres et synchronisation
        let JSON_Flux_multi_data = jQuery.parseJSON( $('textarea[role="json-data-flux"]').text() || JSON.stringify( {} ) );

        //  On récupére le noeuds maîtres...
        // Vérification des conteneurs pour le peuplement !
        if( $('select#filter_selector_modules[role="data-filter"]').length == 1 && $('select#filter_selector_fields[role="data-filter"]').length == 1 ){

            console.log(" ⮱ Peuplement des sélecteurs de filtres");
            $.each( JSON_Flux_multi_data , function(node_key, node_value){

                $_option_module = $('<option>').val(node_key).text(node_key);
                $('select#filter_selector_modules[role="data-filter"]').append( $_option_module );

                var custom_modules = ['Profil', 'Demandeur', 'Beneficiaire'];
                if(custom_modules.includes(node_key))
                {
                    var selectOptions = '';
                    
                    $.each( node_value , function(field_key, field_group) {
                        $_optgroup_field = $('<optgroup>').attr('label', field_group.libelle).attr('rel', node_key );
                        $.each( field_group.champs , function(field_key, field){
                            $_option_field = $('<option>').val('$' + node_key.toLowerCase() + '_' + field.name).text(field.libelle).attr('rel', node_key );
                            $( $_optgroup_field ).append( $_option_field );
                        });
                        $('select#filter_selector_fields[role="data-filter"]').append( $_optgroup_field );
                    });
                }
                else
                {
                    //  On peuple l'ensemble de tous les sous éléments, en créant un relation intrinsèque avec un noeud maitre (rel).
                    $.each( node_value , function(field_key, field_label){
                        $_option_field = $('<option>').val(field_key).text(field_label).attr('rel', node_key );
                        $('select#filter_selector_fields[role="data-filter"]').append( $_option_field );
                    } );
                }


            } );


            //  On synchronise les comportement entre les selecteurs de filtres
            console.log(" ⮱ Synchronisation entre les sélecteurs de filtres");
            $('select#filter_selector_modules[role="data-filter"]').off().on( 'change focus click' , function(e){
                selected_node_key = $(this).val();
                $('select#filter_selector_fields[role="data-filter"]').val('');

                $('select#filter_selector_fields[role="data-filter"] optgroup[rel]').hide(); // On cache dynamiquement l'ensemble de tous les « fields »
                $('select#filter_selector_fields[role="data-filter"] option[rel]').hide(); // On cache dynamiquement l'ensemble de tous les « fields »
                $('select#filter_selector_fields[role="data-filter"] optgroup[rel="'+selected_node_key+'"]').show(); // On affiche dynamiquement seulement ceux en relation avec leur noeud maître.
                $('select#filter_selector_fields[role="data-filter"] option[rel="'+selected_node_key+'"]').show(); // On affiche dynamiquement seulement ceux en relation avec leur noeud maître.

            } ).trigger( "click" );

            
        }else{
            console.log(" ⮱ Les sélecteurs de filtres semblent indisponibles, le peupleument à échoué !");
        }


    };



    AppUI.bindParamInsertion = function () {
        
        //
        if( $('input#btn_selector').length == 1 ){
            console.log(" ⮱ Activation du bouton d'insertion de variable");


            $('input#btn_selector').off().on( 'click', function(e){

                value_inserer = $('select#filter_selector_fields[role="data-filter"]').val();
                value_inserer = ( typeof value_inserer == 'undefined' || value_inserer == null || value_inserer == '' )? '' :  value_inserer;
                if( value_inserer == '' ){ return }

                $textarea_json = $('textarea#text_area_json');

                if( $textarea_json.length == 1 ){
                    // document.selection pour détecter IE le else if pour le reste 
                    if (document.selection) {
                        $textarea_json.focus();
                        sel = document.selection.createRange();
                        sel.text = value_inserer; 
                    }
                    else if ( $textarea_json.get(0).selectionStart || $textarea_json.get(0).selectionStart == '0') {
                        var startPos = $textarea_json.get(0).selectionStart;
                        var endPos = $textarea_json.get(0).selectionEnd;
                        $textarea_json.get(0).value = $textarea_json.get(0).value.substring(0, startPos)
                            + value_inserer
                            + $textarea_json.get(0).value.substring(endPos, $textarea_json.get(0).value.length);
                    } else {
                        $textarea_json.get(0).value += value_inserer;
                    }
                }else{
                    console.log(" ⮱ Impossible d'inssérer la variable « "+ value_inserer +" » !");
                }

            } );


        }else{
            console.log(" ⮱ Impossible de rendre le bouton d'insertion actif !");
        }

    
    };




jQuery(document).ready(function($){
    console.log('Hello from jQuery!');


    console.group( "%cInitialisation du générateur d'éléments de flux...", 'color:#e29014;;font-weight:bold;font-style: italic;' );

    // Behaviour for changes on textarea. JSON tree Cleanup.
    void AppUI.prepareJSONArea();
   
    // On traite le grappe JSON importée correspondant aux données des relations OPS|AOS vs structures[params]...
    void AppUI.populateFiltersSelectors();
    void AppUI.bindParamInsertion();


    console.groupEnd();

    AppUI.loaded = true;
    console.log("Okay");
});


          



function is_json(item) {
    item = typeof item !== "string"
        ? JSON.stringify(item)
        : item;

    try {
        item = JSON.parse(item);
    } catch (e) {
        return false;
    }

    if (typeof item === "object" && item !== null) {
        return true;
    }

    return false;
}



function generer_flux() {

    try{

        let JSON_OPS_flux = jQuery.parseJSON( $('textarea#text_area_json').val() || JSON.stringify( {} ) );
        console.log( JSON_OPS_flux );

        if( is_json(JSON_OPS_flux) ){

            cacher_erreur();

            var linearized_json = String( JSON.stringify( JSON_OPS_flux ) ).utf8_to_b64();
            console.log( linearized_json );
            send_ajax_request( linearized_json );
        }

    }
    catch(JSONSyntaxExexption){

        let JSON_TypeError = JSONSyntaxExexption instanceof TypeError;
        console.log( JSON_TypeError, JSONSyntaxExexption );
        
        afficher_erreur("Le texte inséré ne correspond pas à la structure d'un JSON ");

    }


}

function afficher_erreur(message){

    var div_erreur = document.getElementById('div_erreur');
    var div_erreur_text = document.getElementById('div_erreur_text');
    var img_erreur = document.getElementById('img_erreur');

    if(div_erreur){
        if(div_erreur_text.style.display == 'none'){
            div_erreur_text.innerHTML = '';
            div_erreur_text.appendChild(document.createTextNode(message));
            img_erreur.style.display = "inline-block";
            div_erreur_text.style.display = "inline-block";
        }else{
            div_erreur_text.innerHTML = '';
            div_erreur_text.appendChild(document.createTextNode(message));
        }
    }
}

function cacher_erreur(){
    
    var div_erreur      = document.getElementById('div_erreur');
    var div_erreur_text = document.getElementById('div_erreur_text');
    var img_erreur      = document.getElementById('img_erreur');

    div_erreur_text.innerHTML = '';
    img_erreur.style.display = "none";
    div_erreur_text.style.display = "none";

}

function send_ajax_request( linearized_json ) {

    // Verify unicity and integrity before sending stream.
    let JSON_OPS_flux = jQuery.parseJSON( String( linearized_json ).b64_to_utf8() );

    if( is_json(JSON_OPS_flux) ){

        var _url = '/index.php?entryPoint=generateur_ajax';

        var _url_window = new URL(window.location.href);
        var _flux_id = _url_window.searchParams.get("id_flux");

        afficher_loading();

        // Send the data using post
        var posting = $.post( _url, { //"flux_id="+flux_id+"&stream=" + linearized_json;
            flux_id: _flux_id,
            stream: linearized_json
        } )
        .done(function( data ) {
            cacher_loading();
            console.log( data );
            traitement_retour_request(data);

        })
        .fail(function( x ) {
            cacher_loading();

            console.log( x );
        });
        
    }else{
        
        alert( "JSON_OPS_flux Error" );

    }

    // 'Content-Type', 'application/x-www-form-urlencoded'
 
}


function cacher_loading() {

    $('#div_loading').hide();

}

function afficher_loading() {

    $('#div_btn_generer_flux').hide();

    $('#div_loading').show();

}

function traitement_retour_request(reponse) {

    console.log(" traitement_retour_request");
    var retour_traitement = JSON.parse(reponse);
    console.dir(retour_traitement);

    if(retour_traitement['statut'] == "ok"){

        $('#div_success').show();

        console.log(" reloading...");
        window.setTimeout( function(){
            if( confirm("Recharger la page ?") ){
                window.location.reload( true );
            }else{
                void null;
            }

        }, 3000);

    }else{
        // On affiche l'erreur 
        $('#div_btn_generer_flux').show();
        afficher_erreur("Erreur retour ajax ");
    }
      
}

