<?php

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

use ODE\Generateur\Factory\OdeFieldFactory;
use ODE\Model\GenerateurReferentielModel;
use ODE\Model\GenerateurFormulaireModel;
use ODE\Model\GenerateurVueModel;
use ODE\Fonctions\OdeFonctions;

class ViewGenerer extends SugarView
{

    public function __construct($bean = null, $view_object_map = array())
    {
        parent::__construct($bean, $view_object_map);
    }

    public function preDisplay()
    {
        if (!$this->bean->ACLAccess('edit')) {
            ACLController::displayNoAccess();
            sugar_die('Access Denied Generateur vue');
        }
    }

    /**
     * @see SugarView::display()
     */
    public function display()
    {

        global $app_list_strings;
        $smarty = new Sugar_Smarty();

        if (!empty($_REQUEST['generateur_formulaire_id'])) {

            do {

                // On récupere les champs du référentiel
                $champs_referentiel = GenerateurReferentielModel::getListeGenerateur();
                $smarty->assign('champs', $champs_referentiel);

                // On récupére les données du formulaire
                $obj_formulaire = BeanFactory::getBean('OPS_generateur_formulaire', $_REQUEST['generateur_formulaire_id']);
                if (empty($obj_formulaire->id)) {
                    // Formulaire introuvable
                    break;
                }
                $smarty->assign('formulaire_name', $obj_formulaire->name);

                // On récupere la vue agent 
                $obj_vue_agent = BeanFactory::getBean('OPS_generateur_vue', $obj_formulaire->agent_vue_id);

                // Si le formulaire ne dispose pas d'une vue agent => on l'initialise
                if (empty($obj_vue_agent->id)) {
                    $agent_vue_id = OPS_generateur_vue::getDefault("crm", $obj_formulaire->name);
                    $obj_formulaire->agent_vue_id = $agent_vue_id;
                    $obj_formulaire->save();
                    $obj_vue_agent = BeanFactory::getBean('OPS_generateur_vue', $agent_vue_id);
                }

                // On récupere la vue usager 
                $obj_vue_usager = BeanFactory::getBean('OPS_generateur_vue', $obj_formulaire->usager_vue_id);

                // Si le formulaire ne dispose pas d'une vue usager => on l'initialise
                if (empty($obj_vue_usager->id)) {
                    $usager_vue_id = OPS_generateur_vue::getDefault("internet", $obj_formulaire->name);
                    $obj_formulaire->usager_vue_id = $usager_vue_id;
                    $obj_formulaire->save();

                    $obj_vue_usager = BeanFactory::getBean('OPS_generateur_vue', $usager_vue_id);
                }

                if (empty($obj_vue_agent->id) || empty($obj_vue_usager->id)) {
                    // Erreur initilisation des vues
                    break;
                }

                $smarty->assign('agent_vue_id', $obj_vue_agent->id);
                $smarty->assign('usager_vue_id', $obj_vue_usager->id);

                $smarty->assign('id', $_REQUEST['generateur_formulaire_id']);

                // On récupere les onglets de la vue Agent
                $agent_onglets = $obj_vue_agent->getOnglets();
                $smarty->assign('agent_onglets', $agent_onglets);

                // On récupere les onglets de la vue Usager
                $usager_onglets = $obj_vue_usager->getOnglets();
                $smarty->assign('usager_onglets', $usager_onglets);

                $suitecrm_listes = $app_list_strings;
                // Cette liste pose probleme au niveau du decode_json. 
                $suitecrm_listes['import_enclosure_options'] = array();
                $smarty->assign('suitecrm_listes', base64_encode(json_encode($suitecrm_listes)));

                $obj_type_document = BeanFactory::getBean('OPS_type_document');
                $documents = $obj_type_document->get_full_list();
                $typeDocument = array();
                foreach ($documents as $document) {
                    $typeDocument[$document->id] = $document->name; 
                }
                natcasesort($typeDocument);
                $smarty->assign('type_document', base64_encode(json_encode($typeDocument)));
                $this->displayTMCE();

                $typeProfilList = get_bean_select_array(true, 'OPS_type_personne', "name", '', "name");

                $moduleListeDefaut = array();
                $individuObj = BeanFactory::getBean('OPS_individu');
                $profilObj = BeanFactory::getBean('OPS_personne_morale');

                //Liste déroulante pour la selection du champ défaut
                $moduleListeDefaut['individu'] = $individuObj;
                $moduleListeDefaut['profil'] = $profilObj;

                $selectListeDefautModule = '';
                foreach ($moduleListeDefaut as $module) {
                    $selectListeDefautModule .= '<select id="select_defaut_'.$module->module_dir.'" class="form-control g-form-input" style="margin-top:5px;display:none;"><option value=""></option>';

                    $field_list = $module->module_dir::get_field_list(true);

                    foreach($field_list as $onglet_key => $onglet)
                    {
                        $selectListeDefautModule .= '<optgroup label="' . $onglet['libelle'] . '">';

                        foreach ($onglet['champs'] as $key => $champ) 
                        {
                            $selectListeDefautModule .= '<option value="' . $champ['name'] . '">' . $champ['libelle'] . '</option>';
                        }

                        $selectListeDefautModule .= '</optgroup>';
                    }

                    $selectListeDefautModule .= '</select>';
                }

                $smarty->assign('select_liste_defaut_module', $selectListeDefautModule);

                $listeReferentielTab = get_bean_select_array(false, 'OPS_liste_referentiel', "name");
                $listeReferentielList = get_select_options_with_id($listeReferentielTab,'');

                $smarty->assign('select_liste_referentiel', $listeReferentielList);

                $listeValeurReferentiel = [];
                
                foreach ($listeReferentielTab as $key => $value) {
                    $listeValeurs = [];
                    $objListeReferentiel = BeanFactory::getBean('OPS_liste_referentiel',$key);
                    $listeValeur = $objListeReferentiel->get_linked_beans('ops_liste_valeur_ops_liste_referentiel', 'OPS_liste_valeur', 'ordre');
                    foreach ($listeValeur as $valeur) {
                        $listeValeurs[$valeur->name] = $valeur->libelle;
                    }
                    $listeValeurReferentiel[$key] = $listeValeurs;
                }

                $listeValeurReferentiel = base64_encode(json_encode($listeValeurReferentiel));
                $smarty->assign('liste_valeur_referentiel', $listeValeurReferentiel);

                if(isset($app_list_strings['moduleList']['OPS_grille_tarifaire'])) {
                    $grilleTab = get_bean_select_array(false, 'OPS_grille_tarifaire', "name");
                    $grilleList = get_select_options_with_id($grilleTab,'');

                    $smarty->assign('select_liste_grille_tarifaire', $grilleList);
                }

                //Liste des fonctions pour le champ fonction
                $fonction = new OdeFonctions();
                $listeFonctions = $fonction->getFonctions();

                foreach ($listeFonctions as $fonction) {
                    $app_list_strings['ops_champ_fonction_list'][$fonction['fonction_id']] = $fonction['fonction_name'];
                }
                ksort($app_list_strings['ops_champ_fonction_list']);

                $selectListeFonction = '';

                foreach($app_list_strings['ops_champ_fonction_list'] as $key => $uneFonction){
                    $selectListeFonction .= '<option value="' . $key . '">' . $uneFonction . '</option>';
                }
                $smarty->assign('select_liste_fonction', $selectListeFonction);

            } while (0);

            $generateur_version = new OPS_generateur_version();
            $version_options = $generateur_version->getVersionOptions($_REQUEST['generateur_formulaire_id']);
            $version_message = $generateur_version->getVersionMessage($_REQUEST['generateur_formulaire_id']);
            $smarty->assign( "version_options", base64_encode(json_encode($version_options)) );
            $smarty->assign( "version_message", $version_message );
        }

        # On ajoute une constante JS pour la récupération dynamique des libelés des champs 
        # Je n'ai pas réussi à récupérer les valeurs depuis $mod_strings et hors de question d'utiliser $app_strings ( Non spécifique au module )
        echo '<script> const OdeFieldLanguage = '. json_encode(OdeFieldFactory::getFieldLanguage()).'</script>' ;

        # On ajoute la liste des boutons de création de nouveaux champs : Ode\Generateur\App\tpls\menu\add-champ-page.tpl
        $smarty->assign( "liste_creation_boutons", OdeFieldFactory::getFieldCreateButton() );

        $current_template = "custom/include/Ode/Generateur/App/tpls/app.tpl";
        $smarty->display($current_template);
    }

    function displayTMCE()
    {
        require_once("include/SugarTinyMCE.php");
        global $locale;

        $tiny = new SugarTinyMCE();
        $tinyMCE = $tiny->getConfig();

        $js = '<script src="include/javascript/tiny_mce/tiny_mce.js"></script>';
        $js .= <<<JS
        <script language="javascript" type="text/javascript">
        function wysiwyg(id_textarea){

        $tinyMCE
        var df = '{$locale->getPrecedentPreference('default_date_format')}';

        tinyMCE.init({
            theme : "advanced",
            theme_advanced_toolbar_align : "left",
            mode: "exact",
            elements : id_textarea,
            theme_advanced_toolbar_location : "top",
            theme_advanced_buttons1: "code,help,separator,bold,italic,underline,strikethrough,separator,justifyleft,justifycenter,justifyright,justifyfull,separator,forecolor,backcolor,separator,styleprops,styleselect,formatselect,fontselect,fontsizeselect",
            theme_advanced_buttons2: "cut,copy,paste,pastetext,pasteword,selectall,separator,search,replace,separator,bullist,numlist,separator,outdent,indent,separator,ltr,rtl,separator,undo,redo,separator, link,unlink,anchor,separator,sub,sup,separator,charmap,visualaid",
            theme_advanced_buttons3: "tablecontrols,separator,advhr,hr,removeformat,separator,insertdate,pagebreak",
            theme_advanced_fonts:"Andale Mono=andale mono,times;Arial=arial,helvetica,sans-serif;Arial Black=arial black,avant garde;Book Antiqua=book antiqua,palatino;Comic Sans MS=comic sans ms,sans-serif;Courier New=courier new,courier;Georgia=georgia,palatino;Helvetica=helvetica;Helvetica Neu=helveticaneue,sans-serif;Impact=impact,chicago;Symbol=symbol;Tahoma=tahoma,arial,helvetica,sans-serif;Terminal=terminal,monaco;Times New Roman=times new roman,times;Trebuchet MS=trebuchet ms,geneva;Verdana=verdana,geneva;Webdings=webdings;Wingdings=wingdings,zapf dingbats",
            plugins : "advhr,insertdatetime,table,paste,searchreplace,directionality,style,pagebreak",
            height:"500",
            width: "100%",
            inline_styles : true,
            directionality : "ltr",
            remove_redundant_brs : true,
            entity_encoding: 'raw',
            cleanup_on_startup : true,
            strict_loading_mode : false,
            convert_urls : false,
            plugin_insertdate_dateFormat : '{DATE '+df+'}',
            pagebreak_separator : "<pagebreak />",
            extended_valid_elements : "textblock",
            custom_elements: "textblock",
        });
    }
        </script>

JS;
        echo $js;
    }
}
