
console.log(" ------ Hello importer.js ------ ")

const default_file_name =  "Aucun fichier séléctionné";

String.prototype.utf8_to_b64=function(){return $.base64.encode(unescape(encodeURIComponent(this)))};
String.prototype.b64_to_utf8=function(){return decodeURIComponent(escape($.base64.decode(this)))};

$(document).ready(function(){

    $("#import_file").change(function(e){

        var statut = false;
        var file = e.target.files[0];
        if( typeof file.name === "string" && file.name !== "" ){
            $("#import_file_name").text( file.name )

            if( file.type === "application/json" ){
                var selected_file = document.getElementById('import_file').files[0];
                var content_file = document.getElementById('import_file_content');
                const reader = new FileReader();
                reader.onload = function(event) { content_file.value = utf8_to_b64(reader.result); };
                reader.readAsText(selected_file);
                statut = true;
            }else{
                console.log(" Ce n'est pas un Json ")
            }

        }else{
            $("#import_file_name").text( default_file_name )
        }
        
        $("#import_file_buttons :input").each(function() {
            ( statut === false ) ? $(this).attr( "disabled", "disabled" ) : $(this).removeAttr( "disabled" ) ;
        });

    });

});

function visualiserJson(){

    var visualisation_html = "<div>";
    var json = JSON.parse( b64_to_utf8( $("#import_file_content").val() ) );

    if( Object.size( json ) > 0 ){

        var count_guides = 1;
        visualisation_html += '<h2 style="margin-left:5px;">' + Object.size( json ) + ' guides d\'instructions à importer.</h2>';

        Object.keys(json).forEach( function(guide_id) {

            const guide = json[guide_id];
            visualisation_html += '<div style="margin-left: 2%; color: #003a6c; font-weight: bold; font-size: 16px; margin-bottom: 5px;"> ';
            visualisation_html += getRomainNumber( count_guides ) + ') ' + guide.name; 
            visualisation_html += '</div>';
            
            if( Object.size( guide.etapes ) > 0 ){

                var count_etapes = 1;
                Object.keys( guide.etapes ).forEach( function( etape_id ) {

                    const etape = guide.etapes[etape_id];
                    visualisation_html += '<div style="margin-left: 4%;margin-bottom: 5px;font-weight: bold;font-size: 14px;">';
                    visualisation_html += count_etapes + ') ' + etape.name;
                    if( Object.size( etape.statuts ) > 0 ){

                        var count_statuts = 1;
                        Object.keys( etape.statuts ).forEach( function( statut_id ) {    
                            
                            const statut = etape.statuts[statut_id];

                            visualisation_html += '<div style="margin-left: 4%; margin-bottom: 5px; font-size: 13px; font-weight: normal;">';
                            visualisation_html += getAlphabeticNumber( count_statuts ) +') ' + statut.name ;
                            visualisation_html += '</div>';

                            count_statuts++;
                        });
                    }    
                    visualisation_html += '</div>';

                    count_etapes++;
                });
            }
            count_guides++;
        });

    }else{

        visualisation_html += " Aucun guide d'instruction ";

    }

    visualisation_html += '</div>';

    $("#visualisation_result").empty();
    $("#visualisation_result").append( visualisation_html );

}

function getRomainNumber( nombre ){
    var chiffre_romain = { 1: "I", 2: "Ⅱ", 3: "Ⅲ", 4: "Ⅳ", 5: "V", 6: "Ⅵ", 7: "Ⅶ", 8: "Ⅷ", 9: "Ⅸ", 10: "X", 11: "Ⅺ", 12: "Ⅻ" }
    return ( chiffre_romain.hasOwnProperty(nombre) ) ? chiffre_romain[nombre] : nombre;
}

function getAlphabeticNumber( nombre ){
    var chiffre_alphabetic = { 1:"a", 2:"b", 3:"c", 4:"d", 5:"e", 6:"f", 7:"g", 8:"h", 9:"i", 10:"j", 11:"k", 12:"l", 13:"m", 14:"n", 15:"o", 16:"p", 17:"q",18:"r" }
    return ( chiffre_alphabetic.hasOwnProperty(nombre) ) ? chiffre_alphabetic[nombre] : nombre;
}

var Loading = {

    initOverlay: function(){
        var div= document.createElement("div");
        div.id = "overlay_body";
        div.className = "overlay-body";
        document.body.appendChild(div);
    },

    hideOverlay: function(){ 
        $("#overlay_body").hide();
    },

    showOverlay: function(){ 
        $("#overlay_body").show("fade", { direction: "right", align: "center" }, 200 );
    },

    addSpinner: function (el, static_pos){
        if( document.getElementById("overlay_body") === null ) this.initOverlay();
        this.showOverlay();
        var spinner = el.children('.spinner');
        if (spinner.length && !spinner.hasClass('spinner-remove')) return null;
        !spinner.length && (spinner = $('<div class="spinner' + (static_pos ? '' : ' spinner-absolute') + '"/>').appendTo(el));
        this.animateSpinner(spinner, 'add');
    },

    removeSpinner: function (el, complete){
        this.hideOverlay();
        var spinner = el.children('.spinner');
        spinner.length && this.animateSpinner(spinner, 'remove', complete);
    },

    animateSpinner: function (el, animation, complete){
        if (el.data('animating')) {
            el.removeClass(el.data('animating')).data('animating', null);
            el.data('animationTimeout') && clearTimeout(el.data('animationTimeout'));
        }
        el.addClass('spinner-' + animation).data('animating', 'spinner-' + animation);
        el.data('animationTimeout', setTimeout(function() { animation == 'remove' && el.remove(); complete && complete(); }, parseFloat(el.css('animation-duration')) * 1000));
    }

};

/**------------------------------------------------------------------------- Fonctions Ajax ------------------------------------------------------------------- */

// Cette variable regroupe les differentes fonctions des actions à mener apres la réponse de l'Ajax
var retourFunctionImporter = {

    importerJson: function(data) {

        $("#overlay_body").remove();
        Loading.removeSpinner($(document.body));

        $("#import_file").val("");
        $("#import_file_content").val("");
        $("#import_file_name").text( default_file_name );
        $("#import_file_buttons :input").each(function() {
            $(this).attr( "disabled", "disabled" ) ;
        });

        var visualisation_html = '<div>';

        visualisation_html += '<h2 style="margin-left:5px;text-align: center;font-size: 25px;">';
        visualisation_html += 'Résultat </h2>';
        
        if (data) {
            if ( data['statut'] == "ok" ) {
            
                if ( Object.size( data['data'].guides ) > 0 ){

                    Object.keys( data['data'].guides ).forEach( function( guide_id ) { 

                        const guide = data['data'].guides[guide_id];

                        if( guide.statut === "ok" ){

                            visualisation_html += '<h3 style=" font-size: 15px; margin-left: 20px;">';
                            visualisation_html += '<span style="margin-right: 7px; color: green;" class="glyphicon glyphicon-ok"></span>';
                            visualisation_html += 'Le guide d\'instruction ';
                            visualisation_html += '<a target="_blank" href="index.php?module=OPS_guide_instruction&return_module=OPS_guide_instruction&action=DetailView&record=' + guide_id +'">' + guide.name.replace(/&#039;/g, "'") + ' </a>';
                            visualisation_html += 'a bien été créé ';
                            visualisation_html += '</h3>';

                        } else {

                            visualisation_html += '<h3 style=" font-size: 15px; margin-left: 20px;">';
                            visualisation_html += '<span style="margin-right: 7px; color: red;" class="glyphicon glyphicon-remove"></span>';
                            visualisation_html += 'Le guide d\'instruction ';
                            visualisation_html += '<a target="_blank" href="index.php?module=OPS_guide_instruction&return_module=OPS_guide_instruction&action=DetailView&record=' + guide_id +'">' + guide.name.replace(/&#039;/g, "'") + ' </a>';
                            visualisation_html += 'n\'a pas pu être créé';

                            visualisation_html += '</h3>';
                            visualisation_html += '<p style="font-size: 12px; margin-left: 60px; margin-top: -10px;">';
                            visualisation_html += '<strong style="margin-right: 5px; color: red;"> Libellé de l\'erreur:</strong>';
                            visualisation_html += guide.erreur;
                            visualisation_html += '</p>';

                        }

                    });

                }else{

                    visualisation_html += '<h3 style=" font-size: 15px; margin-left: 20px;">';
                    visualisation_html += '<span style="margin-right: 7px; color: red;" class="glyphicon glyphicon-remove"></span>';
                    visualisation_html += 'Aucun guide d\'instruction n\'a été crée ';
                    visualisation_html += '</h3>';
                    
                }
                
            } else {

                visualisation_html += '<h3 style=" font-size: 15px; margin-left: 20px;">';
                visualisation_html += '<span style="margin-right: 7px; color: red;" class="glyphicon glyphicon-remove"></span>';
                visualisation_html += ' Aucun guide d\'instruction n\'a été crée ';
                visualisation_html += '</h3>';

            }

        } else {

            visualisation_html += '<h3 style=" font-size: 15px; margin-left: 20px;">';
            visualisation_html += '<span style="margin-right: 7px; color: red;" class="glyphicon glyphicon-remove"></span>';
            visualisation_html += ' Erreur Ajax, veuillez contacter votre administrateur.';
            visualisation_html += '</h3>';
        }
    
        visualisation_html += '</div>';

        $("#visualisation_result").empty();
        $("#visualisation_result").append( visualisation_html );

    }

};
var retourFunction = (typeof retourFunction === 'undefined') ? retourFunctionImporter : Object.assign(retourFunction, retourFunctionImporter);

// Cette variable regroupe les differentes fonctions des actions en attendant de recevoir le retour de la requete à envoyer au PHP
var loadingFunctionImporter = {
    importerJson: function() {
        Loading.addSpinner($(document.body));
        console.log("importerJson loadingFunction =")
    }
};
var loadingFunction = (typeof loadingFunction === 'undefined') ? loadingFunctionImporter : Object.assign(loadingFunction, loadingFunctionImporter);

// Cette variable regroupe les differentes fonctions de récupération des données à envoyer au PHP
var getDataFunctionImporter = {
    importerJson: function() {
        var data = false;
        var file_content =  $("#import_file_content").val();
        if( typeof file_content === "string" && file_content !== "" ){
            data = "json=" + file_content;
        } 
        return data; 
    }
};
var getDataFunction = (typeof getDataFunction === 'undefined') ? getDataFunctionImporter : Object.assign(getDataFunction, getDataFunctionImporter);
/**-------------------------------------------------------------------------------------------------------------------------------------------------------------- */

// ODE_LOADING.removeSpinner($(document.body));
// Loading.addSpinner($('#modal_liquidation_unitaire_loading'));
// <div role="form" id="modal_liquidation_unitaire_loading" class="modal-liquidation" data-selected="false" data-name="loading_liquidation"></div>

