$(document).ready(function(){

    let etat = keyObligatoire();
    if(!etat) return;

    eventListenerSurLeBoutonSave();
});

/**
 * Mise en obligatoire de la clé
 */
function keyObligatoire(){
    var view = '';

    var form = "";

    // récupération du formulaire en fonction de si on est dans l'edit view ou dans le sous panel
    $('form').each(function(){
        if(this.id == 'EditView' || this.id == 'form_SubpanelQuickCreate_OPS_liste_valeur'){
            view = this.id;
            form = $(this);
        }
    });

    // verification si il est deja en obligatoire
    // le js est chargé deux fois quand on passe via le sous pannel (??)
    if(form.find('#name').parent().parent().children('div').first().find("span.required").length != 0) return false;

    // mise en obligatoire de la clé
    form.find('#name').parent().parent().children('div').first().append('<span class="required">*</span>');
    addToValidate(view,'name','varchar',true,"Clé");
    return true;


}

/**
 * Affichage de l'erreur après validation du format de la clé
 * @param {*} champ (id du champs)
 * @param {*} msg  (msg d'erreur)
 * @param {*} form (form subpannel ou edit)
 */
function tagEchec(champ, msg, form) {
    $(form).find('#'+champ).attr('style', '!important;border-color:red !important');
    $("#msg_erreur_"+champ).remove();
    $(form).find("#"+champ).after('<div id="msg_erreur_'+champ+'" >'+msg+'</div>');
 
    setTimeout( function() { $("#msg_erreur_"+champ).remove();}, 3000);
}

/**
 * Regex pour valider si la clé n'a pas d'accent ni d'espace
 * @param {*} cle 
 * @returns 
 */
function validationCle(cle) {
    return /^[a-zA-Z0-9_-]*$/.test(cle);
}

function eventListenerSurLeBoutonSave(){
    var editView = true;
    let element = $("#SAVE");

    // ici on est dans le sous pannel
    if(element.length == 0) {
        element = $("#OPS_liste_valeur_subpanel_save_button");
        editView = false;
    }
    
    // on va "redéfinir" le submit pour y ajouter notre condition de validation
    // donc suppression de l'event on click
    element.removeAttr("onclick");

    let current_form = element[0].form;

    current_form.addEventListener('submit', event => {
        let cleValide = validationCle($(current_form).find("#name").val());

        if (cleValide) {
            if(editView) saveEditView();
            else saveSousPannel();

            event.preventDefault();
            return false;

        } else {
            tagEchec("name", 'La clé ne doit pas contenir d\'espaces, ni d\'accents', current_form);
            event.preventDefault();
        }

    });
}

/**
 * sauvegarde la valeur dans le cas du sous pannel
 * @returns 
 */
function saveSousPannel(){
    var _form = document.getElementById('form_SubpanelQuickCreate_OPS_liste_valeur');
    disableOnUnloadEditView(); 
    _form.action.value='Save';
    if(check_form('form_SubpanelQuickCreate_OPS_liste_valeur')) return SUGAR.subpanelUtils.inlineSave(_form.id, 'OPS_liste_valeur_subpanel_save_button');
}

/**
 * sauvegarde la valeur dans le cas de l'edit view
 */
function saveEditView(){
    var _form = document.getElementById('EditView'); 
    _form.action.value='Save'; if(check_form('EditView'))SUGAR.ajaxUI.submitForm(_form);
}