<?php

if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

$module_name = 'OPS_personne_morale';
$searchFields[$module_name] = array(
    'name' => array('query_type' => 'default'),
    'account_type' => array(
        'query_type' => 'default',
        'options' => 'account_type_dom',
        'template_var' => 'ACCOUNT_TYPE_OPTIONS'
    ),
    'industry' => array('query_type' => 'default', 'options' => 'industry_dom', 'template_var' => 'INDUSTRY_OPTIONS'),
    'annual_revenue' => array('query_type' => 'default'),
    'address_street' => array(
        'query_type' => 'default',
        'db_field' => array('billing_address_street', 'shipping_address_street')
    ),
    'address_city' => array(
        'query_type' => 'default',
        'db_field' => array('billing_address_city', 'shipping_address_city')
    ),
    'address_state' => array(
        'query_type' => 'default',
        'db_field' => array('billing_address_state', 'shipping_address_state')
    ),
    'address_postalcode' => array(
        'query_type' => 'default',
        'db_field' => array('billing_address_postalcode', 'shipping_address_postalcode')
    ),
    'address_country' => array(
        'query_type' => 'default',
        'db_field' => array('billing_address_country', 'shipping_address_country')
    ),
    'rating' => array('query_type' => 'default'),
    'phone' => array('query_type' => 'default', 'db_field' => array('phone_office')),
    'email' => array(
        'query_type' => 'default',
        'operator' => 'subquery',
        'subquery' => 'SELECT eabr.bean_id FROM email_addr_bean_rel eabr JOIN email_addresses ea ON (ea.id = eabr.email_address_id) WHERE eabr.deleted=0 AND ea.email_address LIKE',
        'db_field' => array(
            'id',
        ),
        'vname' => 'LBL_ANY_EMAIL',
    ),
    'website' => array('query_type' => 'default'),
    'ownership' => array('query_type' => 'default'),
    'employees' => array('query_type' => 'default'),
    'ticker_symbol' => array('query_type' => 'default'),
    'current_user_only' => array(
        'query_type' => 'default',
        'db_field' => array('assigned_user_id'),
        'my_items' => true,
        'vname' => 'LBL_CURRENT_USER_FILTER',
        'type' => 'bool'
    ),
    'assigned_user_id' => array('query_type' => 'default'),

    //Range Search Support
    'range_date_entered' => array('query_type' => 'default', 'enable_range_search' => true, 'is_date_field' => true),
    'start_range_date_entered' => array(
        'query_type' => 'default',
        'enable_range_search' => true,
        'is_date_field' => true
    ),
    'end_range_date_entered' => array(
        'query_type' => 'default',
        'enable_range_search' => true,
        'is_date_field' => true
    ),
    'range_date_modified' => array('query_type' => 'default', 'enable_range_search' => true, 'is_date_field' => true),
    'start_range_date_modified' => array(
        'query_type' => 'default',
        'enable_range_search' => true,
        'is_date_field' => true
    ),
    'end_range_date_modified' => array(
        'query_type' => 'default',
        'enable_range_search' => true,
        'is_date_field' => true
    ),
    'range_qf_caf_actuel' => array(
        'query_type' => 'default',
        'enable_range_search' => true,
    ),
    'start_range_qf_caf_actuel' => array(
        'query_type' => 'default',
        'enable_range_search' => true,
    ),
    'end_range_qf_caf_actuel' => array(
        'query_type' => 'default',
        'enable_range_search' => true,
    ),
    'range_qf_ville_actuel' => array(
        'query_type' => 'default',
        'enable_range_search' => true,
    ),
    'start_range_qf_ville_actuel' => array (
      'query_type' => 'default',
      'enable_range_search' => true,
    ),
    'end_range_qf_ville_actuel' => array (
        'query_type' => 'default',
        'enable_range_search' => true,
    ),
    //Range Search Support
);
