<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

require_once('include/MVC/View/views/view.detail.php');
require_once('modules/ACLActions/ACLAction.php');
require_once("modules/SecurityGroups/SecurityGroup.php");
use ODE\Modal\OdeModal;

class OPS_personne_moraleViewDetail extends ViewDetail {


    public function __construct(){
        parent::__construct();
    }

    function display(){

        global $app_strings, $app_list_strings, $mod_strings, $current_user;

        echo '<link href="custom/include/libs/fontawesome/css/all.min.css" rel="stylesheet">';
        echo '<link href="custom/include/css/spinner.css" rel="stylesheet">';

        if(empty($this->bean->id)){
            sugar_die($app_strings['ERROR_NO_RECORD']);
        }

        $this->dv->process();

        $configuratorObj = new Configurator();

        $bouton_calendar = '';
        if($current_user->isAdmin() || (isset($_SESSION['habilitation_individu']['profil_calendrier']) && $_SESSION['habilitation_individu']['profil_calendrier'] == 1) )
        {
            $bouton_calendar = '<input title="Calendrier" accesskey="i" class="button primary" onclick="var _form = document.getElementById(\'formDetailView\'); _form.return_module.value=\'' . $this->bean->module_name .'\'; _form.return_action.value=\'DetailView\'; _form.return_id.value=\'' . $this->bean->id .'\'; _form.action.value=\'CalendarView\';SUGAR.ajaxUI.submitForm(_form);" type="button" name="Calendar" id="calendar_button" value="Calendrier">';
        }

        $this->ss->assign("bouton_calendar", $bouton_calendar);

        // On récupere l'appairage si il existe et on vérifie son statut
        $obj_appairage = new OPS_appairage();
        $listAppairage = $obj_appairage->get_full_list(
                                'name',
                                "ops_appairage.parent_type = 'OPS_personne_morale' AND ops_appairage.parent_id ='". $this->bean->id . "'"
                                );
        
        $appairageExist = false;   
        foreach ($listAppairage as $appairage) {
            if("ok" == $appairage->statut){
                $appairageExist = true;
                break;
            }else{
                $appairageExist = false;
            }
        }

        $ojbPersonneMorale = BeanFactory::getBean('OPS_personne_morale',$this->bean->id);

        $ojbPersonneMorale->name = mb_convert_case( ucwords( html_entity_decode(strtolower($ojbPersonneMorale->name) ) , "-, \t\r\n\f\v'" ) , MB_CASE_UPPER, "UTF-8");

        if(true == $appairageExist){
            $this->bean->tiers_appaire = "O";
            $ojbPersonneMorale->tiers_appaire = "O";
            $ojbPersonneMorale->save();
        }else{
            $this->bean->tiers_appaire = "N";
            $ojbPersonneMorale->tiers_appaire = "N";
            $ojbPersonneMorale->save();
        }

        // On récupere l'id du type_personne initial
        $type_personne_initial_id = ( !empty($this->bean->ops_type_personne_id) ) ? $this->bean->ops_type_personne_id : "";

        // On récupere le nom du type_personne initial
        $type_personne_initial_bean = ( !empty($type_personne_initial_id) ) ? BeanFactory::getBean('OPS_type_personne', $type_personne_initial_id) : false;
        $type_personne_initial_name = ( $type_personne_initial_bean !== false && !empty($type_personne_initial_bean->id) ) ? $type_personne_initial_bean->name : "";
        $type_personne_libelle_nom = ( $type_personne_initial_bean !== false && !empty($type_personne_initial_bean->id) ) ? $type_personne_initial_bean->libelle_nom : "";

        if ( !empty($type_personne_initial_id) && !empty($type_personne_initial_name) ) {
            $type_personne_initial =$type_personne_initial_name ;
        } else {
            $type_personne_initial = '';
        }

        $libelle_nom_liste = $app_list_strings['ops_tp_libelle_nom_list'];
        if ( !empty($type_personne_initial_id) && !empty($type_personne_libelle_nom) && array_key_exists($type_personne_libelle_nom, $libelle_nom_liste) ) 
        {
            $type_personne_initial_libelle_nom = $libelle_nom_liste[$type_personne_libelle_nom];
        } 
        else 
        {
            $type_personne_initial_libelle_nom = $mod_strings['LBL_NAME'];
        }
        
        $this->ss->assign("type_personne_initial", $type_personne_initial);

        $obligatoire = array (
            'label'                 => $type_personne_initial_bean->name,
            'numero_rna'            => $type_personne_initial_bean->numero_rna,
            'siret'                 => $type_personne_initial_bean->siret,
            'numero_rne'            => $type_personne_initial_bean->numero_rne,
            'num_tahiti'            => $type_personne_initial_bean->num_tahiti,
            'code_ape'              => $type_personne_initial_bean->code_ape,
            'objet_social'          => $type_personne_initial_bean->objet_social,
            'sigle'                 => $type_personne_initial_bean->sigle,
            'website'               => $type_personne_initial_bean->website,
            'forme_juridique'       => $type_personne_initial_bean->forme_juridique,
            'nature'                => $type_personne_initial_bean->nature,
            'effectif'              => $type_personne_initial_bean->effectif,
            'secteur_activite'      => $type_personne_initial_bean->secteur_activite,
            'date_declaration'      => $type_personne_initial_bean->date_declaration,
            'situation_handicap'    => $type_personne_initial_bean->situation_handicap,
            'display_relation'      => $type_personne_initial_bean->display_relation,
            'display_formule'       => $type_personne_initial_bean->display_formule,
            'display_info_fiscales' => $type_personne_initial_bean->display_info_fiscales,
        );

        $input_code_ape =  $this->bean->code_ape;
        $input_code_ape .= '<input type="hidden" id="personne_morale_obligatoire" value="' . base64_encode ( json_encode( $obligatoire ) ). '">';
        $input_code_ape .= '<input type="hidden" id="personne_morale_libelle_nom" value="' . base64_encode ( json_encode( $type_personne_initial_libelle_nom ) ). '">';
        $this->ss->assign("input_code_ape", $input_code_ape);

        $bouton_delete = $this->get_bouton_delete();
        $this->ss->assign("bouton_delete", $bouton_delete);

        parent::display();
    }

    function get_bouton_delete(){
        global $current_user;
        $owner = $this->bean->assigned_user_id == $current_user->id;
        $hasAccess = ACLAction::userHasAccess($current_user->id, $this->module, "delete", "module", $owner);

        if(!$hasAccess) return "";
        
        $dossierObj = BeanFactory::getBean('OPS_dossier');
        $dossier = $dossierObj->get_full_list(
                    'name',
                    'ops_dossier.deleted = 0 AND ops_dossier.ops_personne_morale="'.$this->bean->id.'"',
                );
        $bouton = '';
        if(empty($dossier)){
            $bouton .= '<input title="Supprimer" accesskey="d" class="button" onclick="var _form = document.getElementById(\'formDetailView\'); _form.return_module.value=\'OPS_personne_morale\'; _form.return_action.value=\'ListView\'; _form.action.value=\'Delete\'; if(confirm(\'Voulez-vous vraiment supprimer cet enregistrement ?\')) SUGAR.ajaxUI.submitForm(_form); return false;" type="submit" name="Delete" value="Supprimer" id="delete_button">';
        }else{
            $modal = new OdeModal('ode_modal_delete');
            $modal->setTitle("SUPPRESSION D'UN PROFIL");
            $modal->setCss(['modules/OPS_personne_morale/css/delete.css']);
            $modal->setJS(['modules/OPS_personne_morale/javascript/delete.js']);
            $modal->setPages(['modules/OPS_personne_morale/tpl/delete.tpl']);
            $bouton = $modal->getHtml();
            $bouton .= '<input title="Supprimer" accesskey="d" class="button" type="button" name="Delete" value="Supprimer" id="delete_button" role="ode-modal-delete-btn">';
        }
        return $bouton;
    }
}
