<?php

class hook_personne_morale_individu {

    //
    // Fonction d'initialisation de l'individu pour la RGPD
    //
    function init_individu(&$bean, $event, $arguments = null) 
    {        

        if($event != 'before_save'){
          return;
        }
        
        if ( ( !empty($bean->ops_individu_ops_personne_morale_individu_name) || !empty($bean->ops_individu_id) ) && empty( $bean->individu_rattache )   ) {

            if( isset($bean->ops_individu_id) && !empty( $bean->ops_individu_id ) && !is_array($bean->ops_individu_id) && !is_object($bean->ops_individu_id) ){
                $obj_individu = BeanFactory::getBean('OPS_individu', $bean->ops_individu_id );
                $name = $obj_individu->full_name;
            }
            else{
                $name = $bean->ops_individu_ops_personne_morale_individu_name; 
            }
            
            $bean->individu_rattache = $name; 

        }
    }

    function delete_relation_calendrier_garde(&$bean, $event, $arguments = null) 
    {        
        if($event != 'before_delete')
        {
          return;
        }
        
        $bean->load_relationship('ops_personne_morale_individu_ops_calendrier_garde');
        $bean->load_relationship('ops_personne_morale_individu_2_ops_calendrier_garde');

        $calendarList = $bean->ops_personne_morale_individu_ops_calendrier_garde->get();
        foreach ($calendarList as $calendarId) 
        {
            $calendarBean = BeanFactory::getBean('OPS_calendrier_garde', $calendarId);
            if(!empty($calendarBean->id))
            {
                $bean->ops_personne_morale_individu_ops_calendrier_garde->deleted($bean->id, $calendarBean);
            }
        }

        $calendarList = $bean->ops_personne_morale_individu_2_ops_calendrier_garde->get();
        foreach ($calendarList as $calendarId) 
        {
            $calendarBean = BeanFactory::getBean('OPS_calendrier_garde', $calendarId);
            if(!empty($calendarBean->id))
            {
                $bean->ops_personne_morale_individu_2_ops_calendrier_garde->delete($bean->id, $calendarBean);
            }
        }
    }

    function change_relation_calendrier_garde(&$bean, $event, $arguments = null) 
    {        
        if($event != 'before_save')
        {
          return;
        }

        if( !in_array($bean->mode_garde, ['alternee', 'partagee']) )
        {
            $bean->load_relationship('ops_personne_morale_individu_ops_calendrier_garde');
            $bean->load_relationship('ops_personne_morale_individu_2_ops_calendrier_garde');

            $calendarList = $bean->ops_personne_morale_individu_ops_calendrier_garde->get();
            foreach ($calendarList as $calendarId) 
            {
                $calendarBean = BeanFactory::getBean('OPS_calendrier_garde', $calendarId);
                if(!empty($calendarBean->id))
                {
                    $bean->ops_personne_morale_individu_ops_calendrier_garde->delete($bean->id, $calendarBean);
                }
            }

            $calendarList = $bean->ops_personne_morale_individu_2_ops_calendrier_garde->get();
            foreach ($calendarList as $calendarId) 
            {
                $calendarBean = BeanFactory::getBean('OPS_calendrier_garde', $calendarId);
                if(!empty($calendarBean->id))
                {
                    $bean->ops_personne_morale_individu_2_ops_calendrier_garde->delete($bean->id, $calendarBean);
                }
            }
        }
    }
}

?>