$(document).ready(function() {

        // Affiche les titres
        $('[role=section_title]').each(function() {
                $(this).closest('.edit-view-row-item').find('> .label').hide();
                $(this).text( $(this).closest('.edit-view-row-item').find('> .label').text().replaceAll(':', '') );
                $(this).show();
        });

        
        // Partie Statut de complétude

        // Input hidden -> val == base64(json) Contient la liste des étapes et des statuts
        var statut_completude_liste = $('#statut_completude_liste');

        // Génère les deux select (Etapes & Statuts)
        let select_etape = $('<select>').attr('name', 'statut_completude_etape').append($('<option>').val(''));
        $('div[field="statut_completude"]').append(select_etape);

        let select_statut = $('<select>').attr('name', 'statut_completude_statut').append($('<option>').val(''));
        $('div[field="statut_completude"]').append(select_statut);


        if(statut_completude_liste.length > 0)
        {
                try 
                {
                        // Décode le base64 & récupère la liste
                        statut_completude_liste = JSON.parse(atob(statut_completude_liste.val()));

                        if(Object.keys(statut_completude_liste).length > 0)
                        {
                                for(etape_id in statut_completude_liste)
                                {
                                        if(Object.keys(statut_completude_liste[etape_id]['statuts']).length > 0)
                                        {
                                                // Ajoute une étape dans le select
                                                option_etape = $('<option>').val(etape_id).text(statut_completude_liste[etape_id]['name']);
                                                $(select_etape).append(option_etape);

                                                // Ajoute les statuts dans le select
                                                for(statut_id in statut_completude_liste[etape_id]['statuts'])
                                                {
                                                        option_statut = $('<option>').val(statut_id).text(statut_completude_liste[etape_id]['statuts'][statut_id]).attr('rel', etape_id );
                                                        $(select_statut).append(option_statut);
                                                }
                                        }
                                }
                        }
                } 
                catch (err) 
                {
                        console.error("Erreur lors de la tentative de parsing JSON :", err);
                }
        }

        let statut_completude = $('#ops_statut_completude_id');
        if(statut_completude.length > 0)
        {
                statut_completude = statut_completude.val();

                let option_statut = $('select[name="statut_completude_statut"] option[value="' + statut_completude + '"');
                if(option_statut.length > 0)
                {
                        option_statut.attr('selected', true);
                        $('select[name="statut_completude_etape"] option[value="' + option_statut.attr('rel') + '"').attr('selected', true);
                        //$('select[name="statut_completude_statut"] option:not([rel="' + option_statut.attr('rel') + '")').hide();

                        $('select[name="statut_completude_statut"] option').filter(function() {
                                return $(this).attr('rel') !== option_statut.attr('rel');
                            }).each(function() {
                                // Faire quelque chose avec ces options, par exemple les cacher
                                $(this).hide();
                            });
                }
        }

        // OnChange -> Select des étapes : Affiche les statuts liés à l'étape
        $('select[name="statut_completude_etape"]').on('change', function() {

                // Cache la liste des statuts
                $('select[name="statut_completude_statut"] option').hide();
                
                // Affiche les statuts en fonction de l'ID étape
                $('select[name="statut_completude_statut"] option[value=""]').show();
                $('select[name="statut_completude_statut"] option[rel="' + $(this).val() + '"]').show();
                
                // Réinitialise la valeur sélectionnée
                $('input[name="ops_statut_completude_id"]').val('');
                $('select[name="statut_completude_statut"] option:selected').removeAttr('selected');
        });

        // OnChange -> Select des statuts : Change la valeur de l'input hidden
        $('select[name="statut_completude_statut"]').on('change', function() {
                $('input[name="ops_statut_completude_id"]').val($('select[name="statut_completude_statut"]').val());
        });
});