
$(document).ready(function() {

    // We initialize the modal
    ModalStatut.initialisation( Statut.modal_id );

    if ( ModalStatut.loaded ) {

        // We initialize the onclick function [ Action par lot ]
        Statut.setClickActionLotBtn();
    }

    $('#form_statut_btn_terminer').click(function(){
        if ( $("#dossiers_updated").val() === "oui" ){
            $("#dossiers_updated").val("non");
            window.location = '//'+window.location.host+'/index.php?module='+$('#MassUpdate input[name=module]').val();
        } else {
            $.f_modal.close();
        }
    });

    $('#form_statut_btn_modifier_statut').click(function(){

        $('.erreur_msg_modif_statut').remove();
        
        var erreur_val_vide = false;
        $('.selectStatut').each(function(){ 
            if ($(this).val() == '') 
            {
                erreur_val_vide = true;
                var erreur_msg_statut = '<p class="erreur_msg_modif_statut" style="color : red;margin-right: 20px;">Veuillez sélectionner un statut !</p>';
                $( erreur_msg_statut ).insertAfter( this );
            }
        });

        if(erreur_val_vide)
        {   
            var erreur_msg_statut = '<p class="erreur_msg_modif_statut" style="color : red;display: inline;margin-right: 20px;">Un statut n\'a pas été sélectionner !</p>';
            $( erreur_msg_statut ).insertBefore( $( "#form_statut_btn_modifier_statut" ) );
        }
        else
        {
            Statut.modifierStatut();
        }
    });

});

// We create an instance of the OdeModal object
const ModalStatut = Object.create(OdeModal);

if( typeof(Statut) == 'undefined' ){ var Statut = { modal_id: 'ode_modal_statut', loaded: false }; }

// We initialize the onclick function [ Action par lot ]
Statut.setClickActionLotBtn = function(){
    $('[role="ode-modal-statut-btn"]').off().on('click', function () {
        $('#form_statut_btn_terminer').text('Annuler');
        $('#form_statut_btn_modifier_statut').hide();
        ModalStatut.initialisation( Statut.modal_id );
        ModalStatut.open();
        Statut.initialisation();
    });
}

// The initialization function is the first function triggered when the modal is opened.
Statut.initialisation = function(){ 

    ModalStatut.route('statut');
    LoadingModifierStatut.addSpinner($('#modal_modifier_statut_loading'));

    var loading = function(){
        //ModalStatut.loading.setMessage('Récupération des dossiers séléctionnés');
    };

    var callBack = function(){

        if ( typeof this.result.html_message === "string"){
            ModalStatut.route('erreur',this.result.html_message);
            return; 
        }

        if(typeof this.result.erreur === "string"){
            ModalStatut.route('erreur',this.result.erreur);
            return; 
        }

        var message = ( this.result.resultat.length === 1 ) 
                    ? `Récupération du statut du dossier séléctionné`
                    : `Récupération des statuts des ${this.result.resultat.length} dossiers séléctionnés`;

        LoadingModifierStatut.removeSpinner($('#modal_modifier_statut_loading'));
        ModalStatut.route('statut');
        retourFunctionModificationStatut.initFormulaireModifierStatut(this);

    };

    var dossiers = Statut.getSelectedDossiers();
    var query = OdeQueries.getAjaxActionQuery();
    query.setModule('OPS_statut');
    query.setAction("initFormulaireModifierStatut");
    query.setPostData( dossiers );
    OdeAjax.getByAction( query, loading, callBack );
}

Statut.modifierStatut = function(){ 

    ModalStatut.route('statut');
    LoadingModifierStatut.addSpinner($('#modal_modifier_statut_loading'));

    var loading = function(){
        //ModalStatut.loading.setMessage('Modification des statuts');
    };

    var callBack = function(){

        if ( typeof this.result.html_message === "string" ){
            ModalStatut.route('erreur',this.result.html_message);
            return; 
        }

        if(typeof this.result.erreur === "string"){
            ModalStatut.route('erreur',this.result.erreur);
            return; 
        }

        var message = ( this.result.resultat.length === 1 ) 
                    ? `Modification du statut du dossier séléctionné`
                    : `Modification des statuts des ${this.result.resultat.length} dossiers séléctionnés`;

        LoadingModifierStatut.removeSpinner($('#modal_modifier_statut_loading'));
        ModalStatut.route('statut');
        ModalStatut.loading.reset();
        retourFunctionModificationStatut.modifierStatut(this);

    };

    var dossiers = getDataFunctionModificationStatut.modifierStatut();
    var query = OdeQueries.getAjaxActionQuery();
    query.setModule('OPS_statut');
    query.setAction("modifierStatut");
    query.setPostData( dossiers );
    OdeAjax.getByAction( query, loading, callBack );

}

Statut.getSelectedDossiers = function(){
    var tabId = new Array();
    for (var wp = 0; wp < document.MassUpdate.elements.length; wp++) {
        if (document.MassUpdate.elements[wp].name == 'current_query_by_page') {
            json = document.MassUpdate.elements[wp].value;
            json = $.parseJSON( json );
        }
        var reg_for_existing_uid = new RegExp('^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$|^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$');
        if (typeof document.MassUpdate.elements[wp].name != 'undefined' &&
            document.MassUpdate.elements[wp].name == 'mass[]' &&
            document.MassUpdate.elements[wp].checked &&
            !reg_for_existing_uid.test(document.MassUpdate.uid.value)) {
            tabId.push(document.MassUpdate.elements[wp].value);
        }
    }
    if (document.MassUpdate.uid.value != ''){
        var massUpdate = document.MassUpdate.uid.value;
        massUpdate += ',';
        massUpdate += tabId.join(',');
        tabId = massUpdate.split(',');
        if(tabId[tabId.length - 1] == ''){
            tabId.pop();
        }
    }
    return ( document.MassUpdate.select_entire_list.value == 1 ) ? { dossiers: false, filtres: json } : { dossiers: tabId, filtres: false };
} 

var RoutingModifierStatut = {

    route: function (form_name, data) {

        this.forms = this.forms || $('[role="form"]');
        if( this.forms.length === 0 ){ return false; }

        this.initFormulaire(form_name, data);
        this.displayFormulaire();

        return true;
    },

    initFormulaire: function (form_name, data) { 

        switch (form_name) {
            case "resultat_modifier_statut":
                ModifierStatut.initResultat(data);
                break;
            case "message_modifier_statut":
                ModifierStatut.initMessage(data);
                break;
            case "loading_modifier_statut":
                ModifierStatut.initLoading();
                break;
            case "formulaire_modifier_statut":
                ModifierStatut.initFormulaire( data );
                break;
            default:
                console.log("Formulaire "+form_name+" Non définie dans le Routing.")
                break;
        }

        this.forms.each( function() {  
            ( $(this).attr("data-name") === form_name ) ? $(this).attr("data-selected" , "true") : $(this).attr("data-selected" , "false");
        });  

    },

    displayFormulaire: function () { 
        this.forms.each( function() {
            ( $(this).attr("data-selected") === "true" ) ? $(this).show("fade", { direction: "right", align: "center" }, 500 ) : $(this).hide();
        });
    },
    
};

var ModifierStatut = {

    initResultat: function ( data ) {

        var resultat_html = '';
        if ( data.statut ){
            var dossiers = data.result.resultat.dossiers;
            if ( Object.keys(dossiers).length > 0 ){
                $("#dossiers_updated").val("oui");
                Object.keys(dossiers).forEach(function(groupe_id) {
                    const groupe = dossiers[groupe_id];
                    resultat_html += '<div style="margin: 0px 30px 0px 30px;">';
                    resultat_html +=    '<div style="display: block; padding-bottom: 20px;">';
                    resultat_html +=        '<h3 style="font-size: 15px;">';
                    resultat_html +=          '<div class="row col-md-12" style="height: 90px;overflow-x: hidden;padding: 5px;overflow-wrap: break-word;">';
                    resultat_html +=              '<div class="col-md-12" style="margin-left: 10px;">';
                    resultat_html +=                  '<div style="font-weight: bold;" title="'+ groupe.dossier_num +'">N° dossier(s):</div>';
                    resultat_html +=              '</div>'   ;    
                    resultat_html +=              '<div class="col-md-12" style="padding: 14px;">' + groupe.dossier_num + '</div>';        
                    resultat_html +=          '</div>';
                    resultat_html +=        '</h3>';
                    resultat_html +=    '</div>';

                    resultat_html +=    '<div style="display: block; font-size: 15px; margin: 15px 0px 15px 10px;">'
                    resultat_html +=        '<span style="color: #35b3c5;">' + groupe.ancienne_etape_name + ' : </span>'
                    resultat_html +=        '<span>' + groupe.ancien_statut_name + '</span>'
                    resultat_html +=        '<span class="glyphicon glyphicon-arrow-right" style="margin-left: 10px; margin-right: 10px;"></span>'
                    resultat_html +=        '<span style="color: #35b3c5;">' + groupe.nouvelle_etape_name + ' : </span>'
                    resultat_html +=        '<span>' + groupe.nouveau_statut_name + '</span>'
                    resultat_html +=    '</div>'
                    resultat_html += '</div>';
                    resultat_html += '<div style="display: block; border-bottom: 1px solid #eee; margin-top: 20px;"></div>';
                });
                resultat_html += '<h3 style="font-size: 17px;color:green;float: right;margin-right: 2%;">  Les dossiers ont bien été mise à jour</h3>';
            }
        } else {
            console.log(" Erreur modification statut ! ")
        }

        $("#resultat_modifier_statut").empty();
        $("#resultat_modifier_statut").append(resultat_html);
        
    },
    
    initLoading: function () {
        LoadingModifierStatut.addSpinner($('#modal_modifier_statut_loading'));
        $("#form_statut_btn_modifier_statut").hide();
    },

    initFormulaire: function ( data ) {

        $('.erreur_msg_modif_statut').remove();
        $('#form_statut_btn_modifier_statut').show();

        var formulaire_html = '';
        if ( Object.keys(data.dossiers).length > 0 ){
            Object.keys(data.dossiers).forEach(function(groupe_id) {
                const groupe = data.dossiers[groupe_id]; 
                var select_id = Math.floor(new Date().valueOf() * Math.random())
                formulaire_html += '<div style="margin: 0px 30px 0px 30px;">';
                formulaire_html +=  '<div style="display: block; padding-bottom: 20px;">';
                formulaire_html +=      '<h3 style="font-size: 15px;">';
                formulaire_html +=          '<div class="row col-md-7" style="height: 90px;overflow-x: hidden;padding: 5px;overflow-wrap: break-word;">';
                formulaire_html +=              '<div class="col-md-12" style="margin-left: 10px;">';
                formulaire_html +=                  '<div style="font-weight: bold;" title="'+ groupe.dossier_num +'">N° dossier(s):</div>';
                formulaire_html +=              '</div>'   ;    
                formulaire_html +=              '<div class="col-md-12" style="padding: 14px;">' + groupe.dossier_num + '</div>';        
                formulaire_html +=          '</div>';
                formulaire_html +=          '<span style="float: right;">Statut actuel: ' + groupe.statut_name + '</span>';
                formulaire_html +=      '</h3>';
                formulaire_html +=  '</div>';
                formulaire_html +=  '<div style="display: block;">';
                formulaire_html +=      '<span style="float: right;color: #35b3c5;margin-top: -14px !important;padding: 15px 0;font-size: 15px;">Étape actuelle : ' + groupe.etape_name + ' </span>';
                formulaire_html +=  '</div>';
                formulaire_html +=  '<div style="display: inline-block;width: 100%;text-align: right;font-size: 15px;">';
                formulaire_html +=      'Selectionner votre statut :';
                formulaire_html +=      '<select id="' + select_id + '" onfocus="hideVerificationStatut(' + select_id + ')" class="selectStatut" role="select_statut" data-dossiers="' + groupe.dossier_id + '" style="width: 22%;margin-left: 10px;">';
                formulaire_html +=          '<option></option>';
                if (  Object.keys(groupe.statut_suivant).length > 0 ){
                    Object.keys(groupe.statut_suivant).forEach(function(statut_id) {
                        formulaire_html +=  '<option value="' + statut_id + '">' + groupe.statut_suivant[statut_id] + '</option>';
                    });
                }
                formulaire_html +=      '</select>';
                formulaire_html +=  '</div>';
                formulaire_html +=  '<small id="small_' + select_id + '" style="color:red;width: 22%;float: right;display:none;">Veuillez selectionner un statut</small>';
                formulaire_html += '</div>';
                formulaire_html += '<div style="display: block; border-bottom: 1px solid #eee; margin-top: 20px;"></div>';
            });
        }
        
        $("#formulaire_modifier_statut").empty();
        $("#formulaire_modifier_statut").append(formulaire_html);

    },

    initMessage: function ( data ) {
        $('#message_modifier_statut_titre').empty();
        $('#message_modifier_statut_message').empty();
        $('#message_modifier_statut_html_message').empty();
        if( typeof data.titre === "string" ) $("#message_modifier_statut_titre").text( data.titre );
        if( typeof data.message === "string" ) $("#message_modifier_statut_message").text( data.message );
        if( typeof data.html_message === "string" ) $("#message_modifier_statut_html_message").append(data.html_message);
    },

}

var LoadingModifierStatut = {

    addSpinner: function (el, static_pos){
        var spinner = el.children('.spinner');
        $(el).show();
        $('#btn_modifier_statut').hide();
        $("#formulaire_modifier_statut").hide();
        $("#resultat_modifier_statut").hide();
        if (spinner.length && !spinner.hasClass('spinner-remove')) return null;
        !spinner.length && (spinner = $('<div class="spinner' + (static_pos ? '' : ' spinner-absolute') + '"/>').appendTo(el));
        this.animateSpinner(spinner, 'add');
    },

    removeSpinner: function (el, complete){
        var spinner = el.children('.spinner');
        spinner.length && this.animateSpinner(spinner, 'remove', complete);
        $('#btn_modifier_statut').show();
    },

    animateSpinner: function (el, animation, complete){
        if (el.data('animating')) {
            el.removeClass(el.data('animating')).data('animating', null);
            el.data('animationTimeout') && clearTimeout(el.data('animationTimeout'));
        }
        el.addClass('spinner-' + animation).data('animating', 'spinner-' + animation);
        el.data('animationTimeout', setTimeout(function() { animation == 'remove' && el.remove(); complete && complete(); }, parseFloat(el.css('animation-duration')) * 1000));
    }

};

// Fonction qui retourne la liste des dossiers 
function getDossiers(){

    var dossiers = false;
    var tabId = new Array();
    for (var wp = 0; wp < document.MassUpdate.elements.length; wp++) {
        if (document.MassUpdate.elements[wp].name == 'current_query_by_page') {
            json = document.MassUpdate.elements[wp].value;
        }
        var reg_for_existing_uid = new RegExp('^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$|^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$');
        if (typeof document.MassUpdate.elements[wp].name != 'undefined' &&
            document.MassUpdate.elements[wp].name == 'mass[]' &&
            document.MassUpdate.elements[wp].checked &&
            !reg_for_existing_uid.test(document.MassUpdate.uid.value)) {
            tabId.push(document.MassUpdate.elements[wp].value);
        }
    }
    dossiers = tabId + '&selectAll=0';
    if (document.MassUpdate.select_entire_list.value == 1) {
        dossiers = json + '&selectAll=1';
    }
    return dossiers;

}

// Fonction pour réinitialiser le select apres vérification
function hideVerificationStatut ( select_id ){
    $("#"+ select_id).css("border-color","#a5e8d6");
    $("#small_"+ select_id).hide();
}

// Fonction pour un afficher un border vert sur une séléction valide
function showSuccessStatut ( select_id ){
    $("#"+ select_id).css("border-color","green");
    $("#small_"+ select_id).hide();
}

// Fonction pour afficher l'erreur de séléction d'un statut
function showErreurStatut ( select_id ){
    $("#"+ select_id).css("border-color","red");
    $("#small_"+ select_id).show();
}

// Cette variable regroupe les differentes fonctions des get données pour l'envoie Ajax
var getDataFunctionModificationStatut = {

    initFormulaireModifierStatut: function() {
        var dossiers = getDossiers();
        return ( typeof dossiers === "string" && Object.keys(dossiers).length > 0 ) ? "dossiers=" + dossiers : false;
    },
    modifierStatut: function() {

        var json = { data: [] };
        var erreur_selection = false;
        if ( $('[role="select_statut"]').length > 0 ) {
            $('[role="select_statut"]').each( function( index, select ) {
                if ( $(select).val() !== "" ){
                    json.data.push( { statut_id: $(select).val(), dossiers: $(select).attr("data-dossiers") } );
                    showSuccessStatut( $(select).attr("id") );
                } else {
                    erreur_selection = true;
                    showErreurStatut( $(select).attr("id") );
                }
            });
        }
        return ( erreur_selection === false && json.data.length > 0 ) ? utf8_to_b64( JSON.stringify( json ) ) : false;
    }

};
var getDataFunction = (typeof getDataFunction === 'undefined') ? getDataFunctionModificationStatut : Object.assign(getDataFunction, getDataFunctionModificationStatut);

// Cette variable regroupe les differentes fonctions des actions à mener apres la réponse de l'Ajax
var retourFunctionModificationStatut = {

    initFormulaireModifierStatut: function(data) {
        var titre = "Erreur d'initilisation du formulaire de modification des statuts";
        if(data){
            if ( data.statut ) {
                RoutingModifierStatut.route( "formulaire_modifier_statut", data.result.resultat );
            } else {
                var message = data.result.resultat.erreur;
                var html_message = ( typeof data.result.html_message === "string" ) ? data.result.html_message : null;
                RoutingModifierStatut.route( "message_modifier_statut", { titre: titre, message: message, html_message: html_message } ); 
            } 
        }else{
            RoutingModifierStatut.route( "message_modifier_statut", { titre: titre, message: " Erreur de communication avec le serveur, veuillez contacter votre administrateur.",html_message: null } ); 
        }
    },
    modifierStatut: function(data) {
        if(data){
            RoutingModifierStatut.route( "resultat_modifier_statut", data );
            $('#form_statut_btn_terminer').text('Fermer');
            $('#form_statut_btn_modifier_statut').hide();
        }else{
            RoutingModifierStatut.route( "message_modifier_statut", { titre: "Initialisation 3", message: " [Fatal] format de retour différent de JSON" } ); 
        }
    }

};
var retourFunction = (typeof retourFunction === 'undefined') ? retourFunctionModificationStatut : Object.assign(retourFunction, retourFunctionModificationStatut);
