<?php

use ODE\Helper\OdeArrayHelper;

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

require_once 'include/MassUpdate.php';

class OPS_type_traitementController extends SugarController
{



    
    /**
     * @access public
     * @name action_initChoixUnitaire()
     * Fonction pour initialiser le formulaire pour lancer un traitement en action unitaire
     * 
     *  @param array                            $_REQUEST : les données transférées en Ajax
     *  @return json                            $data : Json avec un statut ( ok/err ) + les données d'initialisation' ou le libellé de l'erreur
     */
    public function action_initChoixUnitaire()
    {
        $GLOBALS['log']->fatal('action_initChoixUnitaire');
        $resultat = array('erreur' => "");

        $dossier = base64_decode($_REQUEST['json']);
        $dossier = json_decode($dossier);

        if (!empty($dossier->dossier_id)) {

            $dossier_id = $dossier->dossier_id;
            $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
            if (!empty($obj_dossier->id)) {
                $resultat['dossier_id'] = $obj_dossier->id;
                $resultat['dossier_num'] = $obj_dossier->num_dossier;
            } else {
                $resultat['erreur'] = "Dossier id = " . $obj_dossier->id . " est introuvable ";
            }

            //récupération des traitements
            $obj_traitement = new OPS_type_traitement;
            $liste_traitement = $obj_traitement->get_full_list("name ASC");
            foreach ($liste_traitement as $traitement) {
                $is_lot = ($traitement->action_lot == 'groupe' && $traitement->methode == 'post') ? "oui" : "non";
                $resultat['traitement'][$traitement->id] = array('name' => $traitement->name, 'description' => str_replace("&#039;", "'", $traitement->description), 'is_lot' => $is_lot);
            }
             $GLOBALS['log']->fatal('action_initChoixUnitaire2');
            //récupération des flux
            $obj_flux = new OPS_flux;
            $liste_flux = $obj_flux->get_full_list("name ASC");
   
            foreach ($liste_flux as $flux) {
                $resultat['flux'][$flux->id] = array('name' => $flux->name, 'description' => str_replace("&#039;", "'", $flux->description));
            }

             $GLOBALS['log']->fatal('action_initChoixUnitaire3');
        } else {
            $resultat['erreur'] = "L'id du dossier n'a pas pu etre récupérer";
        }


         $GLOBALS['log']->fatal('action_initChoixUnitaire4');

        $data = (empty($resultat['erreur'])) ? array('statut' => 'ok', 'data' => $resultat) : array('statut' => 'err', 'data' => $resultat);
        $GLOBALS['log']->fatal('data'. print_r($data, true));
        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }


    /**
     * @access public
     * @name action_lancerTraitementByDossier()
     * Fonction pour déclencher un traitement par dossier
     * 
     *  @param array						    $_REQUEST : les données transférées en Ajax
     *  @return json				            $resultat_traitement : Json avec un statut ( ok/err ) + le résultat du déclenchement du traitement ou le libellé de l'erreur
     */
    public function action_lancerTraitementByDossier()
    {

        $resultat_traitement = array('statut' => 'err', 'data' => array());
        $champs = array("json" => true);
        $GLOBALS['log']->fatal('champs');
        $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, $champs);
        if ($data_verified['statut'] == 'ok') {

             $data_decode = base64_decode($data_verified['data']['json_array']);
            $donnees = json_decode($data_decode);

            $dossier_id = $donnees->dossier_id;
            $flux_id = $donnees->flux_traitement_id;
            $traitement_id = $donnees->traitement_id;
            $objDossier = BeanFactory::getBean('OPS_dossier',$dossier_id);

            $objFlux = BeanFactory::getBean('OPS_flux',$flux_id);
            $json = $objFlux->get_json_flux_elements($objDossier);

            $objTypeTraitement = BeanFactory::getBean('OPS_type_traitement',$traitement_id);
            $etape = $objTypeTraitement->get_linked_beans('ops_type_traitement_ops_type_traitement_etapes','OPS_type_traitement_etapes', '', 0, -1, 0, 'etape="1"');
            $GLOBALS['log']->fatal('etape');
            if(!empty($json)){
                $objTraitement = BeanFactory::newBean('OPS_traitement');
                $objTraitement->name = $objTraitement->getNumTraitement();
                $objTraitement->num_dossier = $objDossier->num_dossier;
                $objTraitement->statut = 'recu';
                $objTraitement->requete = $json;
                $objTraitement->ops_type_traitement_id = $traitement_id;
                $objTraitement->ops_type_traitement_etapes_id = $etape[0]->id;
                $objTraitement->save();
            }

            if(!empty($objTraitement->id)){
                $resultat_traitement['data']['data_retour'] =  "création terminée";
                $resultat_traitement['data']['dossier_id'] =  $objTraitement->id;                                        
                $resultat_traitement['data']['dossier_name'] =  $objTraitement->name;                                        
                $resultat_traitement['statut'] = "ok";
            }else{
                $resultat_traitement['data']['data_retour'] =  "création echouée";                                  
                $resultat_traitement['statut'] = "err";
            }    
        } else {
            $resultat_traitement['data'] = $data_verified['data'];
        }
                $GLOBALS['log']->fatal('resultat_traitement'. print_r($resultat_traitement, true));

        ob_clean();
        echo json_encode($resultat_traitement);
        sugar_cleanup(true);
    }



    /**
     * @access private
     * @name getDossierNum()
     * Fonction qui retourne le numéro du dossier
     * 
     *  @param string						    $dossier_id : L'id du dossier
     *  @return string				            $dossier_num : Le numéro du dossier
     */
    private function getDossierNum($dossier_id)
    {

        $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
        return (!empty($obj_dossier->id)) ? $obj_dossier->num_dossier : "";
    }

    /**
     * @access private
     * @name getDossierName()
     * Fonction qui retourne le libellé du dossier
     * 
     *  @param string						    $dossier_id : L'id du dossier
     *  @return string				            $dossier_name : Le libellé du dossier
     */
    private function getDossierName($dossier_id)
    {

        $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
        return (!empty($obj_dossier->id)) ? $obj_dossier->name : "";
    }

    /**
     * @access private
     * getDonneesTraitement()
     * Fonction qui retourne les données du Json à envoyer, les variables ont été remplacés par leurs valeurs
     * Vérifie en amont que le traitement et le dossier ont bien été récupérés
     */
    private function getDonneesTraitement($traitement, $dossier_id)
    {

        $obj_dossier = BeanFactory::getBean('OPS_dossier', $dossier_id);
        return (!empty($traitement->id) && !empty($obj_dossier->id)) ?  $traitement->get_donnees_bean($obj_dossier) : false;
    }
}
