<?php

if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

if ((!isset($_REQUEST['isProfile']) && empty($_REQUEST['id'])) || empty($_REQUEST['type']) || !isset($_SESSION['authenticated_user_id'])) {
    die("Not a Valid Entry Point");
}

if ($_REQUEST['type'] !== "OPS_justificatif") {
    die("Le document n'est pas un justificatif");
}

if (!is_string($_REQUEST['id']) || (preg_match('/^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/', $_REQUEST['id'] ) !== 1)) {
    die("Erreur au téléchargement");
}

// preparation d'un flag pour voir si on recupere une des versions historisés du doc
$recuperationHistorique = false;
if(isset($_REQUEST['id_historique']) && (preg_match('/^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/', $_REQUEST['id_historique'] ) === 1)) {
    $recuperationHistorique = true;
}


global $sugar_config;

$sugar_config['ops_justificatif']['chemin'];

$justificatif = BeanFactory::getBean('OPS_justificatif', $_REQUEST['id']);

if($justificatif->ops_personne_morale_id) {
    $chemin = $sugar_config['ops_justificatif']['chemin'].'/'.$justificatif->ops_personne_morale_id.'/';
}
else {
    $chemin = $sugar_config['ops_justificatif']['chemin'].'/'.$justificatif->ops_dossier_id.'/';
}

// adaptation de la fin du chemin
// cas version historisés : historique/{id_justificatif}_{$id_historisation}
$chemin .= $recuperationHistorique ? "historique/" . $_REQUEST['id'] . "_" . $_REQUEST['id_historique']  : $_REQUEST['id'];

// on a plus besoin du justificatif si on est sur le telechargement d'une version historise
// donc on le remplace dans le cas du telechargement de la version historisé
$justificatif = $recuperationHistorique ? BeanFactory::getBean('OPS_justificatif_historisation', $_REQUEST['id_historique']) : $justificatif;

header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Cache-Control: post-check=0, pre-check=0', false);
header('Pragma: no-cache');

header('Content-type: ' . $justificatif->file_mime_type);

if (isset($_REQUEST['preview']) && $_REQUEST['preview'] === 'yes' && $mime_type !== 'text/html') {
    header('Content-Disposition: inline; filename="' . $justificatif->filename . '";');
} else {
    header('Content-Disposition: attachment; filename="' . $justificatif->filename . '";');
}

header("X-Content-Type-Options: nosniff");
header("Content-Length: " . filesize($chemin));
header('Expires: ' . gmdate('D, d M Y H:i:s \G\M\T', time() + 2592000));
set_time_limit(0);

while (ob_get_level() && @ob_end_clean()) {
    ;
}

ob_start();
echo clean_file_output(file_get_contents($chemin), $justificatif->file_mime_type);

$output = ob_get_contents();
ob_end_clean();

echo $output;