<?php


/**
 * Classe GeoMarker - .
 * @uses module/OPS_dossier/OPS_dossier.php
 *
 * Il ajoute une surcharge concernant la gestion des filtres dynamiques et leurs données cartographioques.
 *
**/
class GeoMarker
{
	
	/**
	 * Holds the class object.
	 * @since 1.0.0
	 * @var object
	 */
	public static $instance;


	/**
	 * Returns the singleton instance of the class.
	 *
	 * @since 1.0.0
	 * @return object The GeoMarker object.
	 */
	public static function get_instance() {

		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof GeoMarker ) ) {
			self::$instance = new GeoMarker();
		}

		return self::$instance;

	}


	/**
	 * Returns the singleton instance of the class.
	 *
	 * @since 1.0.0
	 * @return object The GeoMarker object.
	 */
	public function get_marker()
	{
		header('Content-type: image/svg+xml');

		$_args = array(
			'fill'  => $_GET['fill'],
            'inner' => $_GET['inner'],
            'mode'  => $_GET['mode'],
		);

		echo $this->_get_svg_icon( $_args );

	}


	/**
	 * Returns the singleton instance of the class.
	 *
	 * @since 1.0.0
	 * @return object The GeoMarker object.
	 */
	private function _get_svg_icon($args)
	{

		$defaults = array(
			'fill'  => 'rgb(53, 179, 197)',
			'inner' => 'rgb(230, 230, 230)',
			'mode'  => 'single'
		);

		$parsed_args = array_merge( $defaults, $args );

		if( $parsed_args['mode'] == 'multi' ){

            return '<svg xmlns="http://www.w3.org/2000/svg" xmlns:svg="http://www.w3.org/2000/svg" width="105" height="125" id="svgcontent" overflow="visible" x="879.5" y="329" viewBox="0 0 105 125"><g class="layer" style="pointer-events:all"><path id="svg_4" fill="'.$parsed_args['fill'].'" fill-opacity="90" d="M89.45348334210502,15.400683576811076 C68.98994845049958,-5.133558612119433 35.81120741265403,-5.133558612119433 15.347672521048594,15.400683576811076 C-5.115862370556783,35.9349257657416 -5.115862370556783,69.22830873225999 15.347672521048594,89.76255092119052 L48.82442620294677,123.3549762496836 C50.811177163296804,125.34859199618171 54.08931624787431,125.34859199618171 56.076067208224345,123.3549762496836 L89.55282089012252,89.76255092119052 C110.01635578172778,69.32798951958492 110.01635578172778,35.9349257657416 89.45348334210502,15.400683576811076 z" class="st9" stroke="none" stroke-opacity="1"></path><path xmlns="http://www.w3.org/2000/svg" id="svg_5" fill="'.$parsed_args['inner'].'" d="M80.31442892449479,80.39255691264941 C64.91710898178201,95.84307894800972 39.983384429389105,95.84307894800972 24.58606448667632,80.39255691264941 C9.188744543963537,64.94203487728907 9.188744543963537,39.92215725873782 24.58606448667632,24.47163522337747 C39.983384429389105,9.021113188017125 64.91710898178201,9.021113188017125 80.31442892449479,24.47163522337747 C95.61241131919013,39.92215725873782 95.61241131919013,64.94203487728907 80.31442892449479,80.39255691264941 z" class="st2" fill-opacity="1" stroke="none" stroke-opacity="1"></path><path xmlns="http://www.w3.org/2000/svg" id="svg_3" fill="'.$parsed_args['fill'].'" fill-opacity="1" d="M42.61739334946242,29.81676585197711 C46.20884380303585,33.945790031431194 47.64118628481498,36.195279002524096 51.09279264993074,36.195279002524096 L78.6378403764528,36.195279002524096 L78.6378403764528,72.34018685562364 L27.785444573642735,72.34018685562364 L27.785444573642735,29.81676585197711 L42.61739334946242,29.81676585197711 zM55.330492300164906,53.2046474039827 L55.330492300164906,46.82613425343572 L51.09279264993074,46.82613425343572 L51.09279264993074,53.2046474039827 L44.73624317457944,53.2046474039827 L44.73624317457944,57.456989504347355 L51.09279264993074,57.456989504347355 L51.09279264993074,63.83550265489435 L55.330492300164906,63.83550265489435 L55.330492300164906,57.456989504347355 L61.68704177551609,57.456989504347355 L61.68704177551609,53.2046474039827 L55.330492300164906,53.2046474039827 z" stroke-opacity="1" stroke="none"></path></g></svg>';

		}else{

			return '<svg width="105" height="125" xmlns="http://www.w3.org/2000/svg" xmlns:svg="http://www.w3.org/2000/svg"><g class="layer"><g id="svg_1" transform="matrix(0.9933754801750183,0,0,0.996807873249054,-381.64140782655613,-33.112171755226335) "><g id="svg_2" transform="matrix(1,0,0,1,-22.907109866968057,-7.31077957153321) "><g id="svg_3"><g id="pointer_2_"><path id="svg_4" fill="'.$parsed_args['fill'].'" fill-opacity="90%" d="m497.14359,55.97899c-20.6,-20.6 -54,-20.6 -74.6,0c-20.6,20.6 -20.6,54 0,74.6l33.7,33.7c2,2 5.3,2 7.3,0l33.7,-33.7c20.6,-20.5 20.6,-54 -0.1,-74.6z" class="st9"/><path id="svg_5" fill="'.$parsed_args['inner'].'" d="m487.94359,121.17899c-15.5,15.5 -40.6,15.5 -56.1,0c-15.5,-15.5 -15.5,-40.6 0,-56.1c15.5,-15.5 40.6,-15.5 56.1,0c15.4,15.5 15.4,40.6 0,56.1z" class="st2"/></g></g></g></g></g></svg>';
            
		}

	}
}

	$GeoMarker = new GeoMarker();
	$GeoMarker->get_marker();

