<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class AjouterProfilAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Ajouter un profil "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'profil';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Ajouter un profil "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Ajouter un profil";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Ajouter un profil "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Ajouter un profil";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        global $app_list_strings;

        $data = [];

        $objReferentiel = BeanFactory::newbean('OPS_generateur_referentiel');
        $listReferentiel = $objReferentiel->get_full_list('libelle');

        $tabReferentiel = array( '' =>  '- aucun -') ;

        foreach ($listReferentiel as $id => $ref) 
        {
            if(!empty($ref->name))
            {
                $tabReferentiel[$ref->id] = $ref->libelle . " (". $ref->name . ")" ;
            }
        }

        $liste_referentiel = get_select_options_with_id($tabReferentiel, $this->action->ext_valeur_3);

        $liste_champ  = $this->getChamps();

        $data['hidden'] = " <input type='hidden'  id='ext_valeur_5' name='ext_valeur_5' value=".base64_encode(json_encode($liste_referentiel)).">
                            <input type='hidden'  id='ext_valeur_3' name='ext_valeur_3' value=".base64_encode(json_encode($liste_champ)).">
                            <input type='hidden'  id='ext_valeur_text' name='ext_valeur_text' value=".$this->action->ext_valeur_text.">";
   
        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        global $app_list_strings, $beanFiles;
        require_once($beanFiles['User']);

        $data = [];

        $data['ext_valeur_1']['label'] = 'Nom des champs';
        $data['ext_valeur_1']['type'] = 'enum';

        $liste_champ = $this->getChamps();

        $tabReferentielChamps = explode("|", $this->action->ext_valeur_text);

        $choix = 'false';
        foreach($tabReferentielChamps as $ReferentielChamp){
            if("" != str_replace(" ","",$ReferentielChamp)){

                $tabReferentielChamp = explode(";",$ReferentielChamp);
                $nomChamp = $tabReferentielChamp[0];
                $champRefetentiel = $tabReferentielChamp[1];

                if("" != str_replace(" ","", $nomChamp)){
                    $choix='true';
                    $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel',$champRefetentiel);
                    $data['ext_valeur_1']['valeur'] .= "<p><span style='float:left;width:50%;' >" . $liste_champ[$nomChamp] . " : </span> <span style ='float:right;'>" . $objReferentiel->libelle . "</span></p><br>";
                }
            }
        }
        if($choix == 'false'){
            $data['ext_valeur_1']['valeur'] = "<p><span style='float:left;width:70%;' > Aucune assignation n'a été faite </span></p><br>";
        }

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        if(!empty($this->dossier) && !empty($this->action->ext_valeur_text))
        {
            $objPersonneMorale = BeanFactory::newBean('OPS_personne_morale');
            $objPersonneMoraleIndividu = BeanFactory::newBean('OPS_personne_morale_individu');

            $listeChamps = explode('|',$this->action->ext_valeur_text);
            $customChamp = json_decode( base64_decode( $this->dossier->champs_custom) );

            $personne_morale_individu_field = [
                'role',
                'autorite_parentale',
                'mode_garde',
                'referent_tarifaire',
                'presence',
                'payeur',
                'assurance_compagnie',
                'assurance_numero',
                'date_debut_validite',
                'date_fin_validite',
                'acces_usager',
                'responsable',
                'representant_legal',
            ];

            foreach ($listeChamps as $champs) 
            {
                $champ = explode(';', $champs);
                $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel', $champ[1]);

                // Récupération de la valeur sur un champ basic
                if (!empty($this->dossier->{$objReferentiel->name}))
                {
                    $value = $this->dossier->{$objReferentiel->name};
                }
                
                // Récupération de la valeur sur un champ custom
                if( !empty( $customChamp->{$objReferentiel->name} )){
                    $value = $customChamp->{$objReferentiel->name};
                }

                if($objReferentiel->type == 'liste' && !empty($value))
                {
                    $value = str_replace('^', '', $value);
                }
                
                if($objReferentiel->type == 'wysiwyg' && !empty($value) )
                {
                    $value = base64_decode($value);
                }

                if($objReferentiel->type == 'file' && is_array( (array) $customChamp->{$objReferentiel->name}->content  ) ) // TODO
                {
                    
                    // On redimensionne l'image 
                    $chemin = $customChamp->{$objReferentiel->name}->content;
                    $image = imagecreatefromstring(file_get_contents($chemin));

                    $maxSize = 600;
                    $originalWidth = imagesx($image);
                    $originalHeight = imagesy($image);

                    $resizeWidth = ($originalWidth > $originalHeight) ? $maxSize : null;

                    list($newWidth, $newHeight) = $this->scaleDimensions($originalWidth, $originalHeight, $resizeWidth, null);
                    $resizedImage = imagescale($image, $newWidth, $newHeight);

                    ob_start();

                    imagejpeg($resizedImage, null, 100);

                    $base64Image = base64_encode(ob_get_clean());
                    $decodedFile = base64_decode($base64Image);

                    // On sauvegarde l'image
                    file_put_contents($sugar_config['upload_dir'].$objPersonneMorale->id.'_image', $decodedFile);


                    // On stocke le nom de l'image 
                    $value = $customChamp->{$objReferentiel->name}->name;
                }

                // Adresse domiciliation
                if($champ[0] == 'adresse')
                {
                    $value = html_entity_decode($value, ENT_NOQUOTES);

                    // Vérifie si la valeur est encodé en base 64
                    if (base64_encode(base64_decode($value, true)) === $value)
                    {
                        $value = json_decode(base64_decode($value));
                        
                        $objPersonneMorale->billing_address_number          = $value->numero;
                        $objPersonneMorale->billing_address_street          = $value->rue;
                        $objPersonneMorale->billing_address_complement      = $value->complement_batiment;
                        $objPersonneMorale->billing_address_complement_lieu = $value->complement_lieu;
                        $objPersonneMorale->billing_address_postalcode      = $value->postcode;
                        $objPersonneMorale->billing_address_city            = $value->city;
                        $objPersonneMorale->billing_coordonnees_x           = $value->coordonnees_x;
                        $objPersonneMorale->billing_coordonnees_y           = $value->coordonnees_y;
                    }
                }
                // Adresse facturation
                else if($champ[0] == 'adresse_facturation')
                {
                    $value = html_entity_decode($value, ENT_NOQUOTES);

                    // Vérifie si la valeur est encodé en base 64
                    if (base64_encode(base64_decode($value, true)) === $value)
                    {
                        $value = json_decode(base64_decode($value));
                        
                        $objPersonneMorale->shipping_address_number          = $value->numero;
                        $objPersonneMorale->shipping_address_street          = $value->rue;
                        $objPersonneMorale->shipping_address_complement      = $value->complement_batiment;
                        $objPersonneMorale->shipping_address_complement_lieu = $value->complement_lieu;
                        $objPersonneMorale->shipping_address_postalcode      = $value->postcode;
                        $objPersonneMorale->shipping_address_city            = $value->city;
                        $objPersonneMorale->shipping_address_coordonnees_x   = $value->coordonnees_x;
                        $objPersonneMorale->shipping_address_coordonnees_y   = $value->coordonnees_y;
                    }
                }
                // Pour alimenter la relation de l'individu avec le nouveau profil
                else if (in_array($champ[0], $personne_morale_individu_field))
                {
                    $objPersonneMoraleIndividu->{$champ[0]} = $value; 
                }
                else if ($champ[0] == 'profil_name')
                {
                    $objPersonneMorale->name = strtoupper($value);
                }
                else
                {
                    $objPersonneMorale->{$champ[0]} = $value;
                }
            }

            // Vérification de l'unicité d'une personne morale
            $verif_unicite = $objPersonneMorale->verif_unicite();

            if( empty($verif_unicite) )
            {
                $objPersonneMorale->save();

                $objPersonneMoraleIndividu->save();

                $objPersonneMoraleIndividu->load_relationship('ops_personne_morale_ops_personne_morale_individu');
                $objPersonneMoraleIndividu->ops_personne_morale_ops_personne_morale_individu->add($objPersonneMorale);
                
                $objIndividu = BeanFactory::getBean('OPS_individu', $this->dossier->ops_individu_id);
                if(isset($objIndividu) && !empty($objIndividu->id))
                {
                    $objPersonneMoraleIndividu->load_relationship('ops_individu_ops_personne_morale_individu');
                    $objPersonneMoraleIndividu->ops_individu_ops_personne_morale_individu->add($objIndividu);
                }
            }
            else
            {
                $GLOBALS['log']->fatal('AjouterProfilAction::execute() => Le profil existe déjà');
            }

        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne le nom du fichier javascript
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "AjouterProfilAction";
    }

    private function getChamps()
    {
        return array(
            'ops_type_personne_id' => 'Type',
            'nature' => 'Nature',
            'profil_name' => 'Nom',
            'siret' => 'SIRET',
            'numero_rna' => 'Numéro RNA',
            'numero_rne' => 'Numéro UAI',
            'num_tahiti' => 'Numéro TAHITI',
            'code_ape' => 'Code APE',
            'forme_juridique' => 'Forme juridique',
            'date_declaration' => 'Date déclaration',
            'sigle' => 'Sigle',
            'effectif' => 'Effectif',
            'website' => 'Site Web',
            'flag_partenaire' => 'Partenaire',
            'objet_social' => 'Objet social',
            'situation_handicap' => 'Présence d\'enfant(s) en situation de handicap',
            'description' => 'Description',
            'agrement_administratif' => 'Agréments administratifs',
            'utilite_publique' => 'Détail des agréments',
            'affiliee_reseau' => 'Reconnue d\'utilité publique',
            'detail_agrement' => 'Date utilité publique',
            'date_utilite_publique' => 'Affiliée à un réseau, union, fédération',
            'detail_affiliation' => 'Détail de l\'affiliation',
            'numero_fiscale' => 'NIF',
            'regime_allocataire' => 'Régime allocataire',
            'numero_allocataire' => 'Numéro d\'allocataire',
            'qf_caf_actuel' => 'Quotient familial allocataire',
            'qf_ville_actuel' => 'Quotient familial ville',
            'date_application' => 'Date d\'application',
            'email1' => 'Adresse(s) E-mail',
            'phone_office' => 'Téléphone',
            'adresse' => 'Adresse de domiciliation',
            'adresse_date_validite' => 'Adresse valide à partir de',
            'adresse_hors_commune' => 'Hors commune',
            'adresse_facturation' => 'Adresse de facturation',
            'role' => 'Rôle',
            'autorite_parentale' => 'Autorité parentale',
            'mode_garde' => 'Mode de garde',
            'referent_tarifaire' => 'Référent tarifaire',
            'presence' => 'Présence',
            'payeur' => 'Payeur',
            'assurance_compagnie' => 'Compagnie d\'assurance',
            'assurance_numero' => 'N° assurance',
            'date_debut_validite' => 'Date début de validité',
            'date_fin_validite' => 'Date fin de validité',
            'acces_usager' => 'Accès internet',
            'responsable' => 'Gestionnaire',
            'representant_legal' => 'Représentant légal',
            'publie' => 'Publié',
            'thematique' => 'Thématique',
            'accroche' => 'Accroche',
            'description_annuaire' => 'Description',
            'activites' => 'Activités',
            'tarifs' => 'Tarifs',
            'public_beneficiaire' => 'Public bénéficiaire',
            'image' => 'Image',
        );
    }
}