<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;
use ODE\Model\DispositifModel;

if (!defined('sugarEntry')) define('sugarEntry', true);

class AlimenterChampParUnAutreAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Alimenter un champ par un autre "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'dossier';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Alimenter un champ par un autre "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Alimenter un champ par un autre";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Alimenter un champ par un autre "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Alimenter un champ par un autre";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        global $app_list_strings;

        $data = [];
        $objReferentiel = BeanFactory::newbean('OPS_generateur_referentiel');
        $listReferentiel = $objReferentiel->get_full_list(
                                'libelle'
                                );

        $tabReferentiel = array( '' =>  '- aucun -') ;

        foreach ($listReferentiel as $id => $ref) {

            if( !empty($ref->name) ){
                $tabReferentiel[$ref->id] = $ref->libelle . " (". $ref->name . ")" ;
            }


        }

        $referentielListe = get_select_options_with_id($tabReferentiel,$this->action->ext_valeur_3);

        $champsPersonnalises = get_select_options_with_id($tabReferentiel,$this->action->ext_valeur_4);
        
        $champRadio = '';
        foreach( $app_list_strings['ops_type_destination_radio'] as $key => $value ){
            if($key == $this->action->ext_valeur_1 || ( empty($this->action->ext_valeur_1) && $key == 'champs_standards' ) ){
                $champRadio .=  '<input type="radio" id="'.$key.'" name="ext_valeur_1" value="'.$key.'" checked style="margin-left: 6px;">
                                <label for="'.$key.'">'.$value.'</label>';
            }else{
                $champRadio .=  '<input type="radio" id="'.$key.'" name="ext_valeur_1" value="'.$key.'" style="margin-left: 6px;">
                                <label for="'.$key.'">'.$value.'</label>';
            }
        }

        $champsDossier = array();
        $selected = (empty($this->action->ext_valeur_4))?'selected="selected"':'';
        $optionsDossier = '<option value="" '.$selected.'>-aucun-</option>';
        $objDossier = BeanFactory::newbean('OPS_dossier');

        foreach ($objDossier->field_defs as $name => $arr) {
            if (!((isset($arr['dbType']) && strtolower($arr['dbType']) == 'id') || (isset($arr['type']) && $arr['type'] == 'id') || (isset($arr['type']) && $arr['type'] == 'link'))) {
                if (!isset($arr['reportable']) || $arr['reportable']) {
                    if(substr(translate($arr['vname'], $objDossier->module_dir), 0, 4) !== "LBL_") $champsDossier[$name] = translate($arr['vname'], $objDossier->module_dir);
                    if(!empty($this->action->ext_valeur_4) && $this->action->ext_valeur_4 == $name){
                        $optionsDossier .= '<option value="'.$name.'" selected="selected">'.translate($arr['vname'], $objDossier->module_dir).'</option>';
                    }else{
                        $optionsDossier .= '<option value="'.$name.'">'.translate($arr['vname'], $objDossier->module_dir).'</option>';
                    }
                }
            }
        }

        $champAlimenter = array(
            'champs_standards' => $champsDossier,
            'champs_personnalises' => $tabReferentiel
        );

        $optionsExt = ($this->action->ext_valeur_1 == 'champs_standards' || empty($this->action->ext_valeur_1) )?$optionsDossier:$champsPersonnalises;

        $data['ext_valeur_1']['type']  = 'radio';
        $data['ext_valeur_1']['label'] = 'Type de destination';
        $data['ext_valeur_1']['form']  = $champRadio;

        $data['ext_valeur_3']['type']  = 'enum';
        $data['ext_valeur_3']['label'] = 'Champ source';
        $data['ext_valeur_3']['form']  = '<select name="ext_valeur_3" id="ext_valeur_3" style="width: 75%;">' . $referentielListe . '</select>';

        $data['ext_valeur_4']['type']  = 'enum';
        $data['ext_valeur_4']['label'] = 'Champ destination';
        $data['ext_valeur_4']['form']  = '<select name="ext_valeur_4" id="ext_valeur_4" style="width: 75%;">' . $optionsExt . '</select>';

        $data['hidden'] = "<input type='hidden'  id='ext_valeur_text' name='ext_valeur_text' value=".base64_encode(json_encode($champAlimenter)).">";

        return $data;
        //base64_encode(json_encode($modeleDossier))
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        global $app_list_strings;

        $data = [];

        $objReferentiel = (!empty($this->action->ext_valeur_3)) ? BeanFactory::getBean('OPS_generateur_referentiel', $this->action->ext_valeur_3) : null;
        $referentielName = ($objReferentiel !== null && !empty($objReferentiel->libelle)) ? $objReferentiel->libelle : "";

        if($this->action->ext_valeur_1 == 'champs_standards'){
            $objDossier = BeanFactory::newbean('OPS_dossier');
            $champAlimenter = translate($objDossier->field_defs[$this->action->ext_valeur_4]['vname'], $objDossier->module_dir);
        }else{
            $objReferentiel2 = (!empty($this->action->ext_valeur_4)) ? BeanFactory::getBean('OPS_generateur_referentiel', $this->action->ext_valeur_4) : null;
            $champAlimenter = ($objReferentiel2 !== null && !empty($objReferentiel2->libelle)) ? $objReferentiel2->libelle : "";
        }


        $data['ext_valeur_1']['type']  = 'text';
        $data['ext_valeur_1']['label'] = 'Type de destination';
        $data['ext_valeur_1']['valeur']  = $app_list_strings['ops_type_destination_radio'][$this->action->ext_valeur_1];

        $data['ext_valeur_3']['type']  = 'text';
        $data['ext_valeur_3']['label'] = 'Champ source';
        $data['ext_valeur_3']['valeur']  = $referentielName;

        $data['ext_valeur_4']['type']  = 'text';
        $data['ext_valeur_4']['label'] = 'Champ destination';
        $data['ext_valeur_4']['valeur']  = $champAlimenter;

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
     public function execute()
    {
        if(!empty($this->dossier)){
            if(!empty($this->action->ext_valeur_3) && !empty($this->action->ext_valeur_4)){

                $champ_destination = $this->action->ext_valeur_4;
                $champ_source = $this->action->ext_valeur_3;

                $objReferentiel =  BeanFactory::getBean('OPS_generateur_referentiel', $champ_source );

                $referentielName = $objReferentiel->name;
                $customChamp = json_decode( base64_decode( $this->dossier->champs_custom) );

                if($this->action->ext_valeur_1 == 'champs_standards'){
                    if($objReferentiel->description == 'custom'){
                        $testListe = ($objReferentiel2->type != 'liste')?$this->getSelectValue($objReferentiel->description,$referentielName,$customChamp):$customChamp->{$referentielName};
                        $this->dossier->{$champ_destination} = ($objReferentiel->type == 'liste')?$testListe:$customChamp->{$referentielName};
                    }else{
                        $testListe = ($objReferentiel2->type != 'liste')?$this->getSelectValue($objReferentiel->description,$referentielName,$customChamp):$this->dossier->{$referentielName};
                        $this->dossier->{$champ_destination} = ($objReferentiel->type == 'liste')?$testListe:$this->dossier->{$referentielName};

                    }
                    // Flag du name du dossier avec le libelle 
                    if( $champ_destination == "libelle_dossier" ){
                        $this->dossier->name = (!empty($this->dossier->{$champ_destination})) ? $this->dossier->num_dossier . " - " . $this->dossier->{$champ_destination} : (string) $this->dossier->num_dossier ;
                    } 
                    $this->dossier->save();
                }else{
                    $objReferentiel2 =  BeanFactory::getBean('OPS_generateur_referentiel', $champ_destination);
                    $champAlimenter = $objReferentiel2->name;
                    if($objReferentiel->description == 'basic' && $objReferentiel2->description == 'basic'){
                        $testListe = ($objReferentiel2->type != 'liste')?$this->getSelectValue($objReferentiel->description,$referentielName,$customChamp):$this->dossier->{$referentielName};
                        $this->dossier->{$champAlimenter} = ($objReferentiel->type == 'liste')?$testListe:$this->dossier->{$referentielName};
                        if( $champAlimenter == "libelle_dossier" ){
                            $this->dossier->name = (!empty($this->dossier->{$champAlimenter})) ? $this->dossier->num_dossier . " - " . $this->dossier->{$champAlimenter} : (string) $this->dossier->num_dossier ;
                        }   
                        $this->dossier->save();
                    }else if($objReferentiel->description == 'basic' && $objReferentiel2->description == 'custom'){
                        $testListe = ($objReferentiel2->type != 'liste')?$this->getSelectValue($objReferentiel->description,$referentielName,$customChamp):$this->dossier->{$referentielName};
                        $customChamp->{$champAlimenter} = ($objReferentiel->type == 'liste')?$testListe:$this->dossier->{$referentielName};
                        $this->dossier->champs_custom = base64_encode( json_encode( $customChamp ) );
                        $this->dossier->save();
                    }
                    else if($objReferentiel->description == 'custom' && $objReferentiel2->description == 'basic'){
                        $testListe = ($objReferentiel2->type != 'liste')?$this->getSelectValue($objReferentiel->description,$referentielName,$customChamp):$customChamp->{$referentielName};
                        $this->dossier->{$champAlimenter} = ($objReferentiel->type == 'liste')?$testListe:$customChamp->{$referentielName};
                        if( $champAlimenter == "libelle_dossier" ){
                            $this->dossier->name = (!empty($this->dossier->{$champAlimenter})) ? $this->dossier->num_dossier . " - " .$this->dossier->{$champAlimenter} : (string) $this->dossier->num_dossier ;
                        }

                        $this->dossier->save();
                    }
                    else if($objReferentiel->description == 'custom' && $objReferentiel2->description == 'custom'){
                        $testListe = ($objReferentiel2->type != 'liste')?$this->getSelectValue($objReferentiel->description,$referentielName,$customChamp):$customChamp->{$referentielName};
                        $customChamp->{$champAlimenter} = ($objReferentiel->type == 'liste')?$testListe:$customChamp->{$referentielName};
                        $this->dossier->champs_custom = base64_encode( json_encode( $customChamp ) );
                        $this->dossier->save();
                    }
                    else{
                        $GLOBALS['log']->fatal('ModifierChampDossierAction => le champ '.$champAlimenter.' n\'existe pas') ;
                    }
                }
            }else{
                $GLOBALS['log']->fatal('ModifierChampDossierAction => Un champ est vide') ;
            }
        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne l'aide de l'action " Déclencher un Flux "
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "AlimenterChampParUnAutreAction";
    }

    public function getSelectValue($type,$champName,$customChamp){
        $dispositifModel = new DispositifModel($this->dossier->ops_dispositif_id);
        $champsVueAgent = $dispositifModel->getChampsVueAgent();
        $params = json_decode(base64_decode($champsVueAgent[$champName]['params']),true);
        if($type == 'custom'){
            if($params['multiple'] == 0){
                $champs = str_replace('^', '', $customChamp->{$champName});
                return $params['liste'][$champs];
            }else{
                $champs = str_replace('^', '', $customChamp->{$champName});
                $champs = explode(',', $champs);
                $dernier = end(array_keys($champs));
                $text = '';
                foreach ($champs as $key => $value) {
                    if($key == $dernier){
                        $text .= $params['liste'][$value];
                    }else{
                        $text .= $params['liste'][$value].', ';
                    }
                }
                return $text;
            }            
        }else{
            global $app_list_strings;
            if($params['multiple'] == 0){
                return $app_list_strings[$params['liste_name']][$this->dossier->{$champName}];
            }else{
                $champs = str_replace('^', '', $this->dossier->{$champName});
                $champs = explode(',', $champs);
                $dernier = end(array_keys($champs));
                $text = '';
                foreach ($champs as $key => $value) {
                    if($key == $dernier){
                        $text .= $app_list_strings[$params['liste_name']][$value];
                    }else{
                        $text .= $app_list_strings[$params['liste_name']][$value].', ';
                    }
                }
                return $text;
            }
        }
    }
}