<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class AnnulerSuiviDossierAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Supprimer une ligne "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'suivi';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Supprimer une ligne "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Supprimer une ligne";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Supprimer une ligne "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Suppression d'une ligne de suivi";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        $data = [];

        $data['ext_valeur_1']['type']  = 'text';
        $data['ext_valeur_1']['label'] = 'Nom';
        $data['ext_valeur_1']['form']  = '<input style="margin-right: 10px; width: 70%;" type="text" name="ext_valeur_1" id="ext_valeur_1" value="'.$this->action->ext_valeur_1.'">';

        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        $data = [];

        $data['ext_valeur_1']['label'] = 'Nom';
        $data['ext_valeur_1']['type'] = 'text';
        $data['ext_valeur_1']['valeur'] = $this->action->ext_valeur_1;

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        if(!empty($this->dossier)){

            $nom = $this->action->ext_valeur_1;

            $this->dossier->load_relationship('ops_dossier_ops_suivi_dossier');
            $listeSuivi = $this->dossier->ops_dossier_ops_suivi_dossier->getBeans();

            foreach($listeSuivi as $key =>$objSuivi){
                if($objSuivi->name === trim($nom)){
                    $suivi = BeanFactory::getBean('OPS_suivi_dossier', $objSuivi->id);
                    $this->dossier->ops_dossier_ops_suivi_dossier->delete($this->dossier->id,$suivi);
                }
            }
        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne l'aide de l'action " Déclencher un Flux "
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "";
    }
}
