<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class DeclencherTraitementAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Déclencher un traitement "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'instruction';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Déclencher un traitement "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Déclencher un traitement";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Déclencher un traitement "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Déclencher un traitement";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        $data = [];

        $fluxTab = get_bean_select_array(true, 'OPS_flux', "name", 'methode="traitement"', "name");

        $fluxList = get_select_options_with_id($fluxTab,$this->action->ext_valeur_1);

        $typeTraitementTab = get_bean_select_array(true, 'OPS_type_traitement', "name", 'pause=0', "name");

        $typeTraitementList = get_select_options_with_id($typeTraitementTab,$this->action->ext_valeur_2);

        $data['ext_valeur_1']['type']  = 'enum';
        $data['ext_valeur_1']['label'] = 'Mapping de flux';
        $data['ext_valeur_1']['form']  = '<select name="ext_valeur_1" id="ext_valeur_1" style="width: 75%;">'.$fluxList.'</select>';

        $data['ext_valeur_2']['type']  = 'enum';
        $data['ext_valeur_2']['label'] = 'Type de traitements';
        $data['ext_valeur_2']['form']  = '<select name="ext_valeur_2" id="ext_valeur_2" style="width: 75%;">'.$typeTraitementList.'</select>';

        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        $data = [];

        $valeur = '';

        if(!empty($this->action->ext_valeur_1)){
            $objFlux = BeanFactory::getBean('OPS_flux',$this->action->ext_valeur_1);
            if(!empty($objFlux->name)){
                $valeurFlux = $objFlux->name;
            }
        }

        if(!empty($this->action->ext_valeur_2)){
            $objTypeTraitement = BeanFactory::getBean('OPS_type_traitement',$this->action->ext_valeur_2);
            if(!empty($objTypeTraitement->name)){
                $valeurTypeTraitement = $objTypeTraitement->name;
            }
        }

        $data['ext_valeur_1']['type']  = 'text';
        $data['ext_valeur_1']['label'] = 'Mapping de flux';
        $data['ext_valeur_1']['valeur']  = $valeurFlux;

        $data['ext_valeur_2']['type']  = 'text';
        $data['ext_valeur_2']['label'] = 'Type de traitements';
        $data['ext_valeur_2']['valeur']  = $valeurTypeTraitement;

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        if(!empty($this->dossier)){

            $objFlux = BeanFactory::getBean('OPS_flux',$this->action->ext_valeur_1);
            $json = $objFlux->get_json_flux_elements($this->dossier);

            $objTypeTraitement = BeanFactory::getBean('OPS_type_traitement',$this->action->ext_valeur_2);
            $etape = $objTypeTraitement->get_linked_beans('ops_type_traitement_ops_type_traitement_etapes','OPS_type_traitement_etapes', '', 0, -1, 0, 'etape="1"');

            if(!empty($json)){
                $objTraitement = BeanFactory::newBean('OPS_traitement');
                $objTraitement->name = $objTraitement->getNumTraitement();
                $objTraitement->num_dossier = $this->dossier->num_dossier;
                $objTraitement->statut = 'recu';
                $objTraitement->requete = $json;
                $objTraitement->ops_type_traitement_id = $this->action->ext_valeur_2;
                $objTraitement->ops_type_traitement_etapes_id = $etape[0]->id;
                $objTraitement->save();
            }
        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne l'aide de l'action " Déclencher un Flux "
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "";
    }
}
