<?php
namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;
use ODE\Model\GenerateurFormulaireModel;
require_once("custom/modules/AOS_PDF_Templates/OPS_generate_PDF.php");

if (!defined('sugarEntry')) define('sugarEntry', true);

class GenererDocumentAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Générer un document "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'document';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Générer un document "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Générer un document";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Générer un document "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Générer un document";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        $data = [];

        $pdfTemplates = get_bean_select_array(true, 'AOS_PDF_Templates','name', "(type IS NULL OR type='OPS_dossier')",'name');

        $selectPdf = get_select_options_with_id($pdfTemplates, $this->action->ext_valeur_1);

        $checked_val_2 = '';
        if($this->action->ext_valeur_2 == 'on' || $this->action->ext_valeur_2 == 1){
            $checked_val_2 = 'checked';
        }

        $data['ext_valeur_1']['type'] = 'enum';
        $data['ext_valeur_1']['label'] = 'Type';
        $data['ext_valeur_1']['form'] = '<select name="ext_valeur_1" id="ext_valeur_1" style="width: 75%;">'. $selectPdf .'</select>';

        $data['ext_valeur_2']['type'] = 'bool';
        $data['ext_valeur_2']['label'] = 'Visible internet';
        $data['ext_valeur_2']['form'] = '<input type="hidden"  name="ext_valeur_2" value ="off" >';
        $data['ext_valeur_2']['form'] .= '<input type="checkbox" class="checkbox" name="ext_valeur_2" id="ext_valeur_2" '.$checked_val_2.' >';

        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        $data = [];

        $objPdfTemplate = (!empty($this->action->ext_valeur_1))?BeanFactory::getBean('AOS_PDF_Templates',$this->action->ext_valeur_1):null;
        $pdfTemplate = ($objPdfTemplate !== null && !empty($objPdfTemplate->name))?$objPdfTemplate->name:'';

        $checked_val_2 = '';
        if($this->action->ext_valeur_2 == 1 || $this->action->ext_valeur_2 == 'on'){
            $checked_val_2 = 'checked';
        }

        $data['ext_valeur_1']['type']  = 'text';
        $data['ext_valeur_1']['label'] = 'Type';
        $data['ext_valeur_1']['valeur']  = $pdfTemplate;

        $data['ext_valeur_2']['type'] = 'bool';
        $data['ext_valeur_2']['label'] = 'Visible internet';
        $data['ext_valeur_2']['valeur'] = '<input type="checkbox" class="checkbox" name="ext_valeur_2" id="ext_valeur_2" disabled '.$checked_val_2.' >';

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        if(!empty($this->dossier) && !empty($this->action->ext_valeur_1)){

            $module = '';
            $moduleId = '';
            $relation = '';

            $objTemplate = BeanFactory::getBean('AOS_PDF_Templates', $this->action->ext_valeur_1);
            $filename = $objTemplate->name;

            if($objTemplate->type == 'OPS_personne_morale'){
                $module = 'OPS_personne_morale';
                $moduleId = $this->dossier->ops_personne_morale;
                $relation = 'ops_personne_morale_documents';
            }
            if($objTemplate->type == 'OPS_dossier'){
                $module = 'OPS_dossier';
                $moduleId = $this->dossier->id;
                $relation = 'ops_dossier_documents';
            }
            if($objTemplate->type == 'OPS_individu'){
                $module = 'OPS_individu';
                $moduleId = $this->dossier->ops_individu_id ;
                $relation = 'ops_individu_documents';
            }
            
            $bean = BeanFactory::getBean($module, $moduleId);
            $opsGeneratePdf = 'OPS_generate_PDF';
            
            $importable = 0;
            if($this->action->ext_valeur_2 == 1 || $this->action->ext_valeur_2 == 'on'){
                $importable = 1;
            }

            $objDocument = BeanFactory::newBean('Documents');
            $objDocument->parent_type = $module;
            $objDocument->status_id = "nouveau";
            $objDocument->document_name = $filename . ".pdf";
            $objDocument->related_doc_id = $moduleId;
            
            $objDocument->filename = $filename;
            $objDocument->ops_type_document_id = $objTemplate->ops_type_document_id;
            $objDocument->save();
            $objDocument->importable = $importable;

            $pdfFile = $opsGeneratePdf::transform_to_pdf($bean, $objTemplate->id, array(), $filename . '.pdf',$objDocument->id);
            $pdfStreamb64 = base64_encode(file_get_contents($pdfFile['path']));

            if (!empty($objDocument->id)) {
                require_once('modules/Documents/DocumentSoap.php');
                $documentSoap = 'DocumentSoap';
                $objDocumentSoap = new $documentSoap();
                $decodedFile = base64_decode($pdfStreamb64);

                $objDocumentSoap->upload_file->set_for_soap($filename, $decodedFile);
                $extPos = strrpos($objDocumentSoap->upload_file->stored_file_name, ".");
                $objDocumentSoap->upload_file->file_ext = substr($objDocumentSoap->upload_file->stored_file_name, $extPos + 1);

                if (!empty($sugar_config['upload_badext']) && in_array($objDocumentSoap->upload_file->file_ext, $sugar_config['upload_badext'])) {
                    $objDocumentSoap->upload_file->stored_file_name .= ".txt";
                    $objDocumentSoap->upload_file->file_ext = "txt";
                }

                $revision                 = BeanFactory::newBean('DocumentRevisions');
                $revision->filename = $objDocumentSoap->upload_file->get_stored_file_name() . ".pdf";
                $revision->file_mime_type = $objDocumentSoap->upload_file->getMimeSoap($revision->filename);
                $revision->file_ext       = $objDocumentSoap->upload_file->file_ext;
                $revision->revision       = '1';
                $revision->document_id    = $objDocument->id;
                $revision->save();
                
                $objDocument->document_revision_id = $revision->id;
                $objDocument->save();
                
                $objDocumentSoap->upload_file->final_move($revision->id);
                
                $bean->load_relationship($relation);
                $bean->{$relation}->add($objDocument->id);
                $bean->save();
                
                if (!empty($objTemplate->ops_type_document_id)) {
                    $objTypeDocument = BeanFactory::getBean("OPS_type_document", $objTemplate->ops_type_document_id);

                    $objTypeDocument->load_relationship('ops_type_document_documents');
                    $objTypeDocument->ops_type_document_documents->add($objDocument->id);
                    $objTypeDocument->save();
                }
            }
            $erased = $opsGeneratePdf::erase_pdf($pdfFile['path']);
        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne l'aide de l'action " Déclencher un Flux "
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "";
    }
}