<?php

namespace ODE\ActionStatut;

if (!defined('sugarEntry')) define('sugarEntry', true);

class OdeActionStatut
{

    private $action_path;
    private $action_namespace;
    private $action;
    private $dossier;
    private $actions;


    /**
     * Constructeur de la classe OdeActionStatut
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action_path = "custom/include/Ode/ActionStatut/Action/";
        $this->action_namespace = 'ODE\\ActionStatut\\Action\\';
        $this->action = $action;
        $this->dossier = $dossier;
        $this->actions = $this->getActions();
    }

    /**
     * @access public
     * @name getActions()
     * Fonction qui retourne la liste des actions configurés sur le serveur 
     * 
     * 
     *  @return array       - $actions
     */
    public function getActions()
    {
        $actions = [];
        if (is_dir($this->action_path)) {
            $files = array_diff(scandir($this->action_path), ['.', '..']);
            foreach ($files as $file_name) {
                if( end( explode('.', $file_name) ) == 'php')
                {
                    $class_name = $this->action_namespace . str_replace('.php', '', $file_name);
                    $actions[strtolower(str_replace('.php', '', $file_name))] = new $class_name($this->action, $this->dossier);
                }
            }
        } else {
            $GLOBALS['log']->fatal(" OdeActionStatut :: getActions => Erreur initialisation des actions statuts, action_path (" . $this->action_path . ") introuvable");
        }
        return $actions;
    }

    /**
     * @access public
     * @name getOptions()
     * Fonction qui retourne la liste des options à afficher dans le select "fonctions" 
     * 
     * 
     *  @return array       - $options
     */
    public function getOptions()
    {
        $options = [];

        if (is_array($this->actions) && count($this->actions) > 0) {
            foreach ($this->actions as $action_name => $action_class) {
                $options[$this->getGroup($action_name)][strtolower($action_class->getTitle())] = [
                  "libelle" => $action_class->getTitle(),
                  "name" => $action_name,
                  "script_name" => $action_class->getScriptName(),
                ];

                ksort($options[$this->getGroup($action_name)]);
            }
            ksort($options);
        }

        return $options;
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données d'initialisation de la vue edition
     *  @param string           $action_name: le nom de l'action
     * 
     * 
     *  @return array         - $fonction_edition
     */
    public function getDataEdition($action_name)
    {
        $fonction_edition = ["title" => "", "form" => "", "aide" => ""];
        if (is_array($this->actions) && count($this->actions) > 0 && array_key_exists($action_name, $this->actions)) {
            $fonction_edition["title"] = $this->actions[$action_name]->getTitle();
            $fonction_edition["form"] = $this->actions[$action_name]->getForm();
            $fonction_edition["aide"] = $this->actions[$action_name]->getAide();
        }
        return $fonction_edition;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données d'initialisation de la vue detail
     *  @param string           $action_name: le nom de l'action
     * 
     * 
     *  @return array       - $fonction_detail
     */
    public function getDataDetail($action_name)
    {
        $fonction_detail = ["title" => "", "form" => "", "aide" => ""];
        if (is_array($this->actions) && count($this->actions) > 0 && array_key_exists($action_name, $this->actions)) {
            $fonction_detail["title"] = $this->actions[$action_name]->getTitle();
            $fonction_detail["data"] = $this->actions[$action_name]->getDataDetail();
        }
        return $fonction_detail;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui retourne les données d'initialisation de la vue detail
     * 
     * 
     *  @return void
     */
    public function execute()
    {
        if (is_array($this->actions) && count($this->actions) > 0 && array_key_exists($this->action->fonction, $this->actions)) {
            $this->actions[$this->action->fonction]->execute();
        }
    }

    /**
     * @access public
     * @name getOptions()
     * Fonction qui retourne la liste des options à afficher dans le select "fonctions"
     *
     *
     *  @return array       - $options
     */
    public function getScriptName($action_name)
    {
        $script_name = "";
        if (is_array($this->actions) && count($this->actions) > 0 && array_key_exists($action_name, $this->actions)) {
            $script_name = $this->actions[$action_name]->getScriptName();
        }
        return $script_name;
    }

    /**
     * @access public
     * @name getOptions()
     * Fonction qui retourne la liste des options à afficher dans le select "fonctions"
     *
     *
     *  @return array       - $options
     */
    public function getGroup($action_name)
    {
        $group = "";
        if (is_array($this->actions) && count($this->actions) > 0 && array_key_exists($action_name, $this->actions) && method_exists($this->actions[$action_name], 'getGroup')) {
            $group = $this->actions[$action_name]->getGroup();
        }
        return $group;
    }

    /**
     * @access public
     * @name getExtValeurText()
     * Fonction qui retourne la la veleur de la variable ext_valeur_text
     *
     *
     *  @return array       - $options
     */
    public function getExtValeurText($action_name)
    {
        $group = "";
        if (is_array($this->actions) && count($this->actions) > 0 && array_key_exists($action_name, $this->actions) && method_exists($this->actions[$action_name], 'getValues')) {
            $group = $this->actions[$action_name]->getValues();
        }
        return $group;
    }
}
