<?php

namespace ODE\CustomBlock;

if (!defined('sugarEntry')) define('sugarEntry', true);

/**
 * Classe OdeCustomBlock
 * Un "block" est un container custom qu'on souhaite ajouter sur une vue et action particulière d'un module
 * Cette classe a pour objectif de récuperer l'ensemble des containers supplémentaire a ajouter sur un module pour une action
 * Exemple : ListView pour OPS_dossier
 */
class OdeCustomBlock
{

    private $path;
    private $namespace;
    private $moduleName;
    private $actionName;

    /**
     * @string $moduleName = le nom du module (ex : OPS_dossier)
     * @string $action = le nom de l'action (ex : ListView)
     */
    public function __construct($moduleName, $actionName)
    {   
        $this->moduleName = $moduleName;
        $this->actionName = $actionName;
        $this->path = "custom/include/Ode/CustomBlock/modules/$moduleName/";
        $this->namespace = 'ODE\\CustomBlock\\modules\\'.$moduleName . '\\';
    }

    /**
     * Fonction qui scanne dans le dossier "custom/include/Ode/CustomBlock/modules/{MODULE}"
     * les blocks à ajouter sur le module
     * 
     * @return array une "config" des blocks 
     */ 
    public function getBlocks()
    {
        $infos = array();
        $files = array_diff(scandir($this->path), array('.', '..'));
        if (is_array($files) && count($files) > 0) {
            foreach ($files as $file_name) {
                $classe_name = $this->namespace . ucfirst(str_replace(".php", "", $file_name));
                $classe_obj = new $classe_name();
                $infosBlock = $classe_obj->getInfos();
                if($infosBlock['module_name'] != $this->moduleName || $infosBlock['action_name'] != $this->actionName ) continue;
                $infosBlock['objBlock'] = $classe_obj;
                $infos[] = $infosBlock;
            }
        }
        $valeursOrdre = array_column($infos, 'ordre'); 
        array_multisort($valeursOrdre, SORT_ASC, $infos);

        return $infos;
    }
}
