var Onglet = (function($,odeQueries,odeAjax,ligne,champ,section) {

    const log = false;
    return {

        setSortableBoutons: function(){
       
            var onglet = $('[rel="onglet"]');
            onglet.each(function( index ) {
                var form_onglet = $(this).tabs(); 
                form_onglet.find( ".ui-tabs-nav" ).sortable({
                    axis: "x",
                    stop: function(event, ui) {
                        var flag = false;

                        form_onglet.tabs("refresh");
                        var onglets = form_onglet.find(".ui-tabs-nav" ).sortable("toArray", {attribute: 'aria-controls'});
                        for (var i = 0; i < onglets.length; i++) {
                            if ( !onglets[i].isEmpty() ) {
                                if($(`#${onglets[i]}`).attr("data-ordre") != i+1){
                                    flag = true;
                                }
                                $(`#${onglets[i]}`).attr("data-ordre", i + 1);
                            }
                        }
                        if(flag === true){
                            //Flag modification
                            var vue = $(this).closest('[role=vue]');
                            Onglet.flagModification($(vue).attr('id'));
                        }
                    }
                }); 
            }); 

        },

        // http://jsfiddle.net/0tpb8o5d/3/ 
        setDroppableSortableContainers: function(){
            if(log)console.log("Onglet::setDroppableSortableContainers");
            $("[rel=onglet-container]").each(function() {
                    $(this).droppable({
                        hoverClass: 'ui-state-active',
                        tolerance: 'pointer',
                        accept: function (event, ui) {
                            return true;
                        },
                        drop: function (event, ui) {
                            if ($(ui.helper).hasClass('ligne-draggable')) {
                                $(this).append($(ligne.getHtml()));
                                champ.setDroppableContainers();
                            }
                            if ($(ui.helper).hasClass('section-draggable')) {
                                $(this).append($(section.getHtml()));
                                section.setEditableOnClick();
                            }
                        }
                    }).sortable({
                        axis: "y",
                        containment: "parent",
                        placeholder: 'ui-state-highlight',
                        handle: '[role="ligne-move-handle"]',

                        start: function(event, ui) {
                            ui.item.css("z-index",1)
                        },
                        stop: function(event, ui) {
                            //Flag modification
                            var vue = $(this).closest('[role=vue]');
                            Onglet.flagModification($(vue).attr('id'));
                        },
                        connectWith: '#trash-page',
                    }).disableSelection();
            });
        },

        create: function( data , loading , callBack ){
            var query = OdeQueries.getAjaxActionQuery();
            query.setModule('OPS_generateur_onglet');
            query.setAction("generate_uuid");
            query.setPostData(data);
            OdeAjax.getByAction( query, loading, callBack );
        },

        setLibelle: function( id, libelle ){
            console.log("Onglet::setLibelle => data =", id);
            console.log("Onglet::setLibelle => libelle =", libelle);
            if ( $(`#${id}`).length > 0 ) $(`#${id}`).attr("data-libelle", libelle); 
            $(".onglet-navigation-bar").find("li").each(function() {
                if ( $(this).attr("aria-controls") === id ) {
                    var divLibelle = $(this).find("div");
                    $(divLibelle[0]).text(libelle);
                }
            });
        },

        setConditions: function( id, conditions ){
            if ( $(`#${id}`).length > 0 ) $(`#${id}`).attr("data-conditions", conditions);
        },

        setDescription: function( id, description ){
            if ( $(`#${id}`).length > 0 ) $(`#${id}`).attr("data-description", description);
        },

        setVisible: function( id, visible ){
            if ( $(`#${id}`).length > 0 ) $(`#${id}`).attr("data-visible", visible);
        },

        setModifiable: function( id, modifiable ){
            if ( $(`#${id}`).length > 0 ) $(`#${id}`).attr("data-modifiable", modifiable);
        },

        update: function( data , loading , callBack ){
            var query = OdeQueries.getAjaxActionQuery();
            query.setModule('OPS_generateur_onglet');
            query.setAction("sauvegarder");
            query.setPostData(data);
            OdeAjax.getByAction( query, loading, callBack );
        },

        delete: function( id, onglet_btn, onglet_container ){

            var libelle = onglet_btn.text();

            //Flag modification
            var vue = $(onglet_btn).closest('[role=vue]');
            Onglet.flagModification($(vue).attr('id'));

            onglet_btn.remove();
            onglet_container.hide();
            onglet_container.attr("data-delete", "true");

            if ( $(`.onglet-navigation-bar a`).length > 0 ) {
                $(`.onglet-navigation-bar a`)[0].click();
            }

            var tab_onglet = onglet_container.parent().find($( "[role=tab]" ))
            $( tab_onglet ).each(function( index ) {
                $("#"+$(this).attr("aria-controls")).attr('data-ordre',index+1)
            });

            $.alert(`L'onglet <strong>${libelle}</strong> a bien été supprimé`);
        },

     
        getData: function( id ){
            var data = {};
            var onglet = $(`#${id}`);
            if ( onglet.length > 0 ) {
                data = {
                    nom: onglet.attr("data-nom"),
                    libelle: onglet.attr("data-libelle"),
                    ordre: onglet.attr("data-ordre"),
                    cle: onglet.attr("data-cle"),
                    conditions: onglet.attr("data-conditions"),
                    description: onglet.attr("data-description"),
                    visible: onglet.attr("data-visible"),
                    modifiable: onglet.attr("data-modifiable"),
                }; 
            }
            return data;
        },

        getEmptyData: function(){
            return {    
                nom: "",
                libelle: "",
                ordre: "",
                cle: "",
                conditions: "",
                description: "",
                visible: 1,
                modifiable: 1,
            };
        },

        getBoutonHtml: function( data ){
            var bouton_html =   `<li class="onglet-tab">`;
            bouton_html +=          `<a href="#${data.vue_type}-tab-${data.id}" style="width: 100%;padding: 10px 12px 10px 12px;position: relative;display: flex;align-items: center;cursor: pointer;" >`;
            bouton_html +=              `<div style="display: inline-block;">${data.libelle}</div>`;
            bouton_html +=              `<div class="tab-tools">`;
            bouton_html +=                  `<i class="far fa-edit" title="Modifier l'onglet" role="navigation" data-route="/formulaire/onglet/?vue_type=${data.vue_type}&vue_id=${data.vue_id}&onglet_id=${data.id}"></i>`;
            bouton_html +=                  `<i class="fas fa-trash-alt" title="Supprimer l'onglet" role="delete-onglet" data-onglet-id="${data.id}" data-id="#${data.vue_type}-tab-${data.id}" data-libelle="${data.libelle}" ></i>`;
            bouton_html +=              `</div>`; 
            bouton_html +=          `</a>`;
            bouton_html +=      `</li>`;
            return bouton_html;
        },

        getContainerHtml: function( data ){
            var container_html = `<div rel="onglet-container" id="${data.vue_type}-tab-${data.id}" data-id="${data.id}" data-nom="${data.nom}" data-libelle="${data.libelle}"`;
            container_html +=       `data-description="${data.description}" data-visible="${data.visible}" data-modifiable="${data.modifiable}" data-conditions="${data.conditions}" data-ordre="${data.ordre}" data-cle="" data-fake="${data.fake}">`;
            container_html +=   `</div>`;
            return container_html;
        },

        addContainerAndBtn: function( data ){
        
            var bouton_html = this.getBoutonHtml(data);
            var container_html = this.getContainerHtml(data);

            var onglet = $(`#${data.vue_type}`).find( $("[rel=onglet]") ); //current selected tab container
            var tabs = onglet.tabs(); 
            var ul = tabs.find("ul");

            $( bouton_html ).appendTo( ul );
            onglet.find('button[role="btn_add_ligne"].btn').closest('div').before(container_html);
            tabs.tabs( "refresh" );

            return true;
        },

        setDeleteOnglets: function(){
            const self = this;
            $('[role="delete-onglet"]').each(function() {
                $(this).off().click(function(){ 
                    var libelle = ( $(this).attr("data-libelle") !== undefined && !$(this).attr("data-libelle").isEmpty() ) ? $(this).attr("data-libelle") : "";
                    var id = $(this).attr("data-onglet-id");
                    var onglet_btn = $(this).parent().parent().parent();
                    var onglet_container = $(`${$(this).attr("data-id")}`);
                    $.confirm({
                        title: `${libelle}`,
                        content: `<strong> Voulez-vous réellement supprimer l'onglet ? </strong>`,
                        autoClose: 'Non|8000',
                        buttons: {
                            Oui: {
                                text: 'Oui',
                                class: 'custom-class',
                                action: function () {
                                    self.delete(id,onglet_btn,onglet_container);
                                }
                            },
                            Non: function () { }
                        }
                    });
                    
                });
            });
        },

        addLigne: function(){
            $('[role="btn_add_ligne"]').on('click', function() {
                    var id = $('.active[role="presentation"]')[0].firstElementChild['attributes']['aria-controls'].value;
                    var tab = $('#'+id).find('li[aria-expanded="true"]')[0]['attributes']['aria-controls'].value;

                    $('#'+tab).append(ligne.getHtml());
                    champ.setDroppableContainers();
                    Onglet.flagModification(id);

            })
            $('[role="btn_add_ligne_one_column"]').on('click', function() {
                    var id = $('.active[role="presentation"]')[0].firstElementChild['attributes']['aria-controls'].value;
                    var tab = $('#'+id).find('li[aria-expanded="true"]')[0]['attributes']['aria-controls'].value;

                    $('#'+tab).append(ligne.getHtmlOneColumn());
                    champ.setDroppableContainers();
                    //Flag modification
                    Onglet.flagModification(id);
            })
        },

        addSection: function(){
            $('[role="btn_add_section"]').on('click', function() {
                var id = $('.active[role="presentation"]')[0].firstElementChild['attributes']['aria-controls'].value;
                var tab = $('#'+id).find('li[aria-expanded="true"]')[0]['attributes']['aria-controls'].value;

                $('#'+tab).append(section.getHtml());
                section.setEditableOnClick();
                champ.setDroppableContainers();
                //Flag modification
                Onglet.flagModification(id);
            })
        },

        flagModification: function(id){

            var vue = $('#'+id);

            if($(vue).attr('data-modified') != 'true'){
                $(vue).attr('data-modified','true');
                var element = $($('#app-container').find('[aria-controls=' + $(vue).attr('id') + ']'));
                var existingStyle = element.attr('style');
                var newStyle = existingStyle + ' color: #f20000 !important';

                element.attr('style', newStyle);
            }
        }, 

    }
})(jQuery, OdeQueries, OdeAjax, Ligne, Champ, Section);