<?php

namespace ODE\Generateur\Factory;

use ODE\Generateur\Factory\OdeFieldFactory;
use ODE\Model\GenerateurVueModel;

class OdeViewFactory
{

    protected $bean;
    protected $editable;
    protected $donnees;
    private $typeDouble = array('wysiwyg','note','adresse','api_particulier','adresse_geoloc','tableau','api_r2p');


    function __construct($bean_dossier = null, $editable = false, $donnees = [])
    {
        $this->bean = $bean_dossier;
        $this->editable = $editable;
        $this->donnees = $donnees;
    }

    /** Méthode utilisée pour la création d'un dossier 
     * @param string $containerId
     *
     * @return callable
     */
    public function getHtml()
    {

        $vue_html = '<div id="onglets">';

        $vue_html .= $this->getStatutInput();

        if (!empty($this->donnees["vue"]["id"])) {

            $vueModel = new GenerateurVueModel($this->donnees["vue"]["id"]);
            $vue = $vueModel->getOnglets();

            $boutons_html = '<ul id="onglet-boutons">';
            $layouts_html = '<div id="onglet-content">';
            $count = 0;
            foreach ($vue as $ordre => $onglet) {
                $visible = ($onglet["visible"] == 0) ? "off" : "on";
                $modifiable = ($onglet["modifiable"] == 0) ? "off" : "on";                
                $classe = ($count === 0) ? 'class="active"' : '';
                $onglet_visible_midifiable .= '<input type="hidden" class="visible_modifiable_onglet" value="' . $onglet["id"] . '" data-visible="'.$visible.'" data-modifiable="'.$modifiable.'">';
                $boutons_html .= '<li><a id="bouton_' . $onglet["id"] . '" href="#" ' . $classe . '>' . $onglet["libelle"] . '</a></li>';
                $layouts_html .= '<div id="onglet_' . $onglet["id"] . '" role="onglet-formulaire" data-conditions="' . $onglet["conditions"] . '" class="onglet-layout" >';
                foreach ($onglet["lignes"] as $ligne) {
                    if ($ligne["type"] === "section") {
                        $layouts_html .=  $this->getSectionHtml($ligne);
                    } else if ($ligne["type"] === "ligne_double_champ") {
                        $layouts_html .=  $this->getLigneDoubleChampHtml($ligne["champs"]);
                    } else if ($ligne["type"] === "ligne_simple_champ") {
                        $layouts_html .=  $this->getLigneSimpleChampHtml($ligne["champs"]);
                    } else {
                        $GLOBALS['log']->fatal(" OdeViewFactory :: getHtml => type ");
                    }
                }
                $layouts_html .= '</div>';
                $count++;
            }
            $boutons_html .= '</ul>';
            $layouts_html .= '</div>';
            $vue_html .= $boutons_html . $layouts_html . $onglet_visible_midifiable;
        }
        $vue_html .= '</div>';


        return $vue_html;
    }

    /** Méthode utilisée pour le détail d'un dossier 
     * @param string $containerId
     *
     * @return callable
     */
    public function getOngletsHtml( $couverture = false )
    {


        if (!empty($this->donnees["vue"]["id"])) {

            $vueModel = new GenerateurVueModel($this->donnees["vue"]["id"]);
            $vue = $vueModel->getOnglets();

            $boutons_html = '';
            $onglet_visible_midifiable = '';

            $count = 0;
            if( $couverture == true ){
                $count = 1;
            }

            foreach ($vue as $ordre => $onglet) {
                $classe = ($count === 0) ? 'class="active"' : '';
                $visible = ($onglet["visible"] == 0) ? "off" : "on";
                $modifiable = ($onglet["modifiable"] == 0) ? "off" : "on";
                $onglet_visible_midifiable .= '<input type="hidden" class="visible_modifiable_onglet" value="' . $onglet["id"] . '" data-visible="'.$visible.'" data-modifiable="'.$modifiable.'">';
                $boutons_html .= '<li><a id="bouton_' . $onglet["id"] . '" href="#" ' . $classe . '>' . $onglet["libelle"] . '</a></li>';
                $count++;
            }
        }


        return $boutons_html . $onglet_visible_midifiable;
    }

    /** Méthode utilisée pour le détail d'un dossier 
     * @param string $containerId
     *
     * @return callable
     */
    public function getContenusHtml()
    {


        $vue_html .= $this->getStatutInput();

        if (!empty($this->donnees["vue"]["id"])) {

            $vueModel = new GenerateurVueModel($this->donnees["vue"]["id"]);
            $vue = $vueModel->getOnglets();

            $layouts_html = '';

            $count = 0;

            foreach ($vue as $ordre => $onglet) {
                $layouts_html .= '<div id="onglet_' . $onglet["id"] . '" role="onglet-formulaire" data-conditions="' . $onglet["conditions"] . '" class="onglet-layout" >';

                foreach ($onglet["lignes"] as $ligne) {

                    if ($ligne["type"] === "section") {
                        $layouts_html .=  $this->getSectionHtml($ligne);
                    } else if ($ligne["type"] === "ligne_double_champ") {
                        $layouts_html .=  $this->getLigneDoubleChampHtml($ligne["champs"]);
                    }else if ($ligne["type"] === "ligne_simple_champ") {
                        $layouts_html .=  $this->getLigneSimpleChampHtml($ligne["champs"]);
                    } else {
                        $GLOBALS['log']->fatal(" OdeViewFactory :: getHtml => type ");
                    }
                }
                $layouts_html .= '</div>';
                $count++;
            }
        }


        return $layouts_html;
    }

    /**
     * @access private
     * @name getChampHtml()
     * Fonction qui génere les lignes d'un onglet
     *
     *  @param array        $onglet: les informations de l'onglet sous forme de tableau
     *  @return string      $lignes: retour les lignes et les champs qu'ils contiennent sous forme html 
     */
    private function getStatutInput()
    {
        $statut_id = (!empty($this->bean->ops_statut_id)) ? $this->bean->ops_statut_id : "";
        return '<input id="ops_statut_id" type="hidden" value="' . $statut_id . '">';
    }

    /**
     * @access private
     * @name getChampHtml()
     * Fonction qui génere les lignes d'un onglet
     *
     *  @param array        $onglet: les informations de l'onglet sous forme de tableau
     *  @return string      $lignes: retour les lignes et les champs qu'ils contiennent sous forme html 
     */
    private function getChampHtml($champ)
    {

        $fieldFactory = new OdeFieldFactory($this->bean, $this->editable, $this->donnees);
        return $fieldFactory->getHtml($champ);
    }

    /**
     * @access private
     * @name getSectionHtml()
     * Fonction qui génere les lignes d'un onglet
     *
     *  @param array        $onglet: les informations de l'onglet sous forme de tableau
     *  @return string      $lignes: retour les lignes et les champs qu'ils contiennent sous forme html 
     */
    private function getSectionHtml($section)
    {
        $section_html = '<div class="row" role="section">';
        $section_html .= '<h3 style="border-bottom: 2px solid #757070; padding-bottom: 10px; font-size: 21px;margin-bottom: 20px;" role="section-formulaire" rel="section" data-name="'.$section['id'].'" data-conditions="'.$section['conditions'].'"> ' . $section['title'] . ' </h3>';
        $section_html .= '</div>';
        return $section_html;
    }

    /**
     * @access private
     * @name getChampVideHtml()
     * Fonction qui génere les lignes d'un onglet
     *
     *  @param array        $onglet: les informations de l'onglet sous forme de tableau
     *  @return string      $lignes: retour les lignes et les champs qu'ils contiennent sous forme html 
     */
    private function getChampVideHtml()
    {
        $champ_html =   '<div class="row" style="height: 50px;">';
        $champ_html .=  '</div>';
        return $champ_html;
    }

    /**
     * @access private
     * @name getLigneDoubleChampHtml()
     * Fonction qui génere les lignes d'un onglet
     *
     *  @param array        $onglet: les informations de l'onglet sous forme de tableau
     *  @return string      $lignes: retour les lignes et les champs qu'ils contiennent sous forme html 
     */
    private function getLigneDoubleChampHtml($champs)
    {
        $ligne_html = '<div class="row" style="padding-bottom: 8px;" >';
        if(is_array($champs) && in_array($champs[0]['type'], $this->typeDouble)){
            $ligne_html .= '<div class="col-md-12 align-items-center d-flex">';
            if (is_array($champs[0]) && count($champs[0]) > 0) {
                $ligne_html .= $this->getChampHtml($champs[0]);
            }
            $ligne_html .= '</div>';
        }
        else if(is_array($champs) && in_array($champs[1]['type'], $this->typeDouble)){
            $ligne_html .= '<div class="col-md-12 align-items-center d-flex">';
            if (is_array($champs[1]) && count($champs[1]) > 0) {
                $ligne_html .= $this->getChampHtml($champs[1]);
            }
            $ligne_html .= '</div>';
        }
        else if (is_array($champs) && count($champs) === 2) {
            $ligne_html .= '<div class="col-md-6 align-items-center d-flex">';
            if (is_array($champs[0]) && count($champs[0]) > 0) {
                $ligne_html .= $this->getChampHtml($champs[0]);
            } else {
                $ligne_html .= $this->getChampVideHtml();
            }
            $ligne_html .= '</div>';
            $ligne_html .= '<div class="col-md-6 align-items-center d-flex">';
            if (is_array($champs[1]) && count($champs[1]) > 0) {
                $ligne_html .= $this->getChampHtml($champs[1]);
            } else {
                $ligne_html .= $this->getChampVideHtml();
            }
            $ligne_html .= '</div>';
        }
        $ligne_html .= '</div>';
        return $ligne_html;
    }

    /**
     * @access private
     * @name getLigneSimpleChampHtml()
     * Fonction qui génere les lignes d'un onglet
     *
     *  @param array        $onglet: les informations de l'onglet sous forme de tableau
     *  @return string      $lignes: retour les lignes et les champs qu'ils contiennent sous forme html 
     */
    private function getLigneSimpleChampHtml($champs)
    {
        $ligne_html = '<div class="row" style="padding-bottom: 8px;" >';
        if(is_array($champs)){
            $ligne_html .= '<div class="col-md-12 align-items-center d-flex">';
            if (is_array($champs[0]) && count($champs[0]) > 0) {
                $champ_html = $this->getChampHtml($champs[0]);

                if(!strpos($champ_html, 'col-md-6'))
                {
                    $champ_html = str_replace('col-md-4', 'col-md-2', $champ_html);
                    $champ_html = str_replace('col-md-8', 'col-md-10', $champ_html);
                }
                $ligne_html .= $champ_html;
            }
            $ligne_html .= '</div>';
        }
        $ligne_html .= '</div>';
        return $ligne_html;
    }
}
