var OdeRelation = {};

OdeRelation.initialisation = function(){
    OdeRelation.initSelectRelation();
    OdeRelation.initDeleteRelation();
}

OdeRelation.isValid = function( field ){ return true;}

OdeRelation.getValue = function( field ){
    var field_tag = field.get(0).tagName;
    if ( field_tag === "SELECT" ){
        if ( field.attr("multiple") === "multiple") {
            if( typeof field.val() === "object" && field.val().length > 0 ){
                return ( field.val().length === 1 ) ? field.val().join("") : "^" +field.val().join("^,^") + "^";
            }
        } else {
            return (field.find(":selected").val() !== undefined ) ? field.find(":selected").val() : "";
        }
    }
    else if( typeof $(field).val() === 'string' ) {
        value = OdeDossier.escapeHTML($(field).val());
        return value.trim();
    }
    return '';
} 

OdeRelation.initSelectRelation = function() { 
    // On initilise le onclick sur les boutons de séléction des onglets
    $("[role=select-relation]").each(function() {
        var champ = $(this).parent().parent().parent().parent().find($("[role=champ-formulaire]"));
        var input_display = $(this).parent().parent().parent().find($("[role=display-relation]"));
        if ( champ.length > 0 && input_display.length > 0 ) {
            $(this).click(function() {
                var json_data = {
                    "call_back_function": "callBackSelectRelation",
                    "form_name":{
                        "display_id": input_display.attr("id"),
                        "champ_id": champ.attr("id"),
                        "module_name": champ.attr("data-module-name"),
                        "unique": champ.attr("data-unique")
                    },
                    "field_to_name_array":{"id":"id","name":"name"}
                };
                open_popup(champ.attr("data-module-name"), 600, 400, "", true, true, json_data , "", true );
            });
        }
    });
}

OdeRelation.initDeleteRelation = function() { 
    // On initilise le onClick sur le delete relation
    $("[role=delete-relation]").each(function() {
        var champ = $(this).parent().parent().parent().parent().find($("[role=champ-formulaire]"));
        var input_display = $(this).parent().parent().parent().find($("[role=display-relation]"));
        if ( champ.length > 0 && input_display.length > 0 ) {
            $(this).click(function() {
                const values = champ.val().split("|").filter(item => item !== input_display.attr("data-id") );
                champ.val(values.join("|"));
                input_display.attr("data-id","");
                input_display.val("");
            });
        }
    });
}

$(document).ready(function() {
    if ( typeof OdeFields !== 'undefined' ) {
        OdeFields['relation'] = OdeRelation;
    }
});
