<link rel="stylesheet" href="https://unpkg.com/leaflet@1.8.0/dist/leaflet.css" integrity="sha512-hoalWLoI8r4UszCkZ5kL8vayOGVae1oxXe/2A4AO6J9+580uKHDO3JdHb7NzwwzK5xr/Fs0W40kiNHxM9vyTtQ==" crossorigin=""/>

<!-- Make sure you put this AFTER Leaflet's CSS -->
<script src="https://unpkg.com/leaflet@1.8.0/dist/leaflet.js" integrity="sha512-BB3hKbKWOc9Ez/TAwyWxNXeoV9c1v6FIeYiBieIWkpLjauysF18NzgR1MBNBXf8/KABdlkX68nAhlwcDFLGPCQ==" crossorigin=""></script>

{if $leaflet_view eq 'static'}
<script src="https://unpkg.com/dom-to-image@2.6.0/dist/dom-to-image.min.js"></script>
{/if}




<div id="{$id}" data-type="{$adresse_geoloc}" data-latitude="{$latitude}" data-longitude="{$longitude}" data-zoom="{$zoom}" class="row field-line" style="width: -moz-available;width: -webkit-fill-available;">
    
    <div id="{$id}-map" class="col-md-12" style="height: {$hauteur}px; margin-bottom: 10px;"></div>

    <input role="champ-formulaire" data-name="{$name}" id="{$id}_value" type="hidden" value="{$value}" data-conditions="{$conditions}" {$autre}>
    
    {$bouton_position}


    {if $disable_api_ban eq '1'}

    <div class="col-md-12 align-items-center d-flex">
        <div class="row field-line " style="width: -moz-available;width: -webkit-fill-available;">
            
            <div style="padding-bottom: 8px;" class="col-md-6 align-items-center d-flex">
                <div class="row field-line " style="width: -moz-available;width: -webkit-fill-available;">
                    <div style="padding-bottom: 8px;" class="col-md-12 align-items-center d-flex field-box" {$data_required} >
                        <div class="col-md-4 field-label">
                            <label>Adresse : </label>
                            <small role="message-champ" style="display: none;">Le champ est obligatoire </small>
                        </div>
                        <div class="col-md-8">
                            <textarea data-name="{$name_adresse_libre}" data-type-field="text_long" style="min-height: 74px;" role="champ-formulaire" data-conditions="{$conditions}" {$required} {$disabled}>{$value_adresse_libre}</textarea>
                        </div>
                    </div>
                </div>
            </div>

            <div style="padding-bottom: 8px;" class="col-md-6 align-items-center d-flex field-box">
                <div class="row field-line " style="width: -moz-available;width: -webkit-fill-available;">
                    <div style="padding-bottom: 8px;" class="col-md-12 align-items-center d-flex">
                        <div class="col-md-4 field-label">
                            <label>Latitude : </label>
                        </div>
                        <div class="col-md-8">
                            <input data-name="{$name_latitude}" type="text" disabled="disabled" value="{$value_latitude}">
                        </div>
                    </div>
                    <div style="padding-bottom: 8px;" class="col-md-12 align-items-center d-flex">
                        <div class="col-md-4 field-label">
                            <label>Longitude : </label>
                        </div>
                        <div class="col-md-8">
                            <input data-name="{$name_longitude}" type="text" disabled="disabled" value="{$value_longitude}">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {else}

    <div class="col-md-6 align-items-center d-flex" style="padding-bottom: 8px;">
        <div class="col-md-4 field-label">
            <label>{$label_num_rue} : </label>
        </div>
        <div class="col-md-8">
            <input data-name="{$name_numero}" type="text" {$disabled} value="{$value_numero}">
        </div>
    </div>
    <div class="col-md-6 align-items-center d-flex field-box" style="padding-bottom: 8px;" {$data_required} >
        <div class="col-md-4 field-label">
            <label>{$label_rue} : </label>
            <small role="message-champ" style="display: none;">Le champ est obligatoire </small>
        </div>
        <div class="col-md-8">
            <input  data-name="{$name_rue}" type="text" role="champ-formulaire" {$required} {$disabled} value="{$value_rue}">
        </div>
    </div>

    <div class="col-md-6 align-items-center d-flex" style="padding-bottom: 8px;">
        <div class="col-md-4 field-label">
            <label>{$label_bat_etage} : </label>
        </div>
        <div class="col-md-8">
            <input data-name="{$name_complement_batiment}" type="text" {$disabled} value="{$value_complement_batiment}">
        </div>
    </div>
    <div class="col-md-6 align-items-center d-flex" style="padding-bottom: 8px;">
        <div class="col-md-4 field-label">
            <label>{$label_lieu_dit} : </label>
        </div>
        <div class="col-md-8">
            <input  data-name="{$name_complement_lieu}" type="text" {$disabled} value="{$value_complement_lieu}">
        </div>
    </div>

    <div class="col-md-6 align-items-center d-flex field-box" style="padding-bottom: 8px;" {$data_required} >
        <div class="col-md-4 field-label">
            <label>{$label_code_postal} : </label>
            <small role="message-champ" style="display: none;">Le champ est obligatoire </small>
        </div>
        <div class="col-md-8">
            <input data-name="{$name_code_postal}" type="text" role="champ-formulaire" {$required} {$disabled} value="{$value_code_postal}">
        </div>
    </div>
    <div class="col-md-6 align-items-center d-flex field-box" style="padding-bottom: 8px;" {$data_required} >
        <div class="col-md-4 field-label">
            <label>{$label_ville} : </label>
            <small role="message-champ" style="display: none;">Le champ est obligatoire </small>
        </div>
        <div class="col-md-8">
            <input data-name="{$name_ville}" type="text" role="champ-formulaire" {$required} {$disabled} value="{$value_ville}">
        </div>
    </div>
    <div class="col-md-6 align-items-center d-flex" style="padding-bottom: 8px;">
        <div class="col-md-4 field-label">
            <label>Latitude : </label>
        </div>
        <div class="col-md-8">
            <input data-name="{$name_latitude}" type="text" disabled="disabled" value="{$value_latitude}">
        </div>
    </div>
    <div class="col-md-6 align-items-center d-flex" style="padding-bottom: 8px;">
        <div class="col-md-4 field-label">
            <label>Longitude : </label>
        </div>
        <div class="col-md-8">
            <input data-name="{$name_longitude}" type="text" disabled="disabled" value="{$value_longitude}">
        </div>
    </div>
    
    {/if}

</div>


<!-- MODALE ADRESSE TROUVE -->
<div id="{$id}-modal-adresse" class="modal" tabindex="-1" role="dialog">
  <div class="modal-dialog" style="max-width: 800px;">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" id="{$id}-titre_modal_trouve">Adresses trouvées</h4>
        <i class="fa fa-2x fa-times btn" data-dismiss="modal" aria-hidden="true" onclick="jQuery('#{$id}-modal-adresse').modal('hide');"></i>
      </div>
      <div id="{$id}-modal-adresse-body" class="modal-body"></div>
    </div>
  </div>
</div>