<?php

namespace ODE\Model;

if (!defined('sugarEntry')) define('sugarEntry', true);

class DispositifModel
{

    private $time_start;
    private $time_end;
    private $id;

    /**
     * Constructeur de la classe DispositifModel
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($id)
    {

        $this->time_start = microtime(true);
        $this->time_end = microtime(true);
        $this->id = $id;
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données du dispositif en tableau
     *
     *  @return array               - $dispositif: dispositif
     */
    public function getBean()
    {

        global $db;
        $dispositifs = array();

        $sql = "SELECT * FROM `ops_dispositif` WHERE `id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $dispositifs[] = $row;
        }
        return (!empty($dispositifs) && count($dispositifs) === 1) ? $dispositifs[0] : array();
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données du dispositif en tableau
     *
     *  @return array               - $dispositif: dispositif
     */
    public function getChampsVueAgent()
    {
        // On récupere l'id du formulaire associé au dispositif
        $formulaire_id = $this->getFormulaireId();
        // On récupere les champs de la vue agent associé au formulaire
        $GenerateurFormulaireModel = new GenerateurFormulaireModel($formulaire_id);
        return $GenerateurFormulaireModel->getVueAgentChamps();
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données du dispositif en tableau
     *
     *  @return array               - $dispositif: dispositif
     */
    public function getChampsVueUsager()
    {
        // On récupere l'id du formulaire associé au dispositif
        $formulaire_id = $this->getFormulaireId();
        // On récupere les champs de la vue agent associé au formulaire
        $GenerateurFormulaireModel = new GenerateurFormulaireModel($formulaire_id);
        return $GenerateurFormulaireModel->getVueUsagerChamps();
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données du dispositif en tableau
     *
     *  @return array               - $dispositif: dispositif
     */
    public function getChampsVueUsagerByEtape($etape_ordre)
    {
        // On récupere l'id du formulaire associé au dispositif
        $formulaire_id = $this->getFormulaireId();
        // On récupere les champs de la vue agent associé au formulaire
        $GenerateurFormulaireModel = new GenerateurFormulaireModel($formulaire_id);
        return $GenerateurFormulaireModel->getVueUsagerChampsByEtape($etape_ordre);
    }

    /**
     * @access public
     * @name getEtapesVueUsager()
     * Fonction qui retourne les données du dispositif en tableau
     *
     *  @return array               - $dispositif: dispositif
     */
    public function getEtapesVueUsager()
    {
        // On récupere l'id du formulaire associé au dispositif
        $formulaire_id = $this->getFormulaireId();
        // On récupere les champs de la vue agent associé au formulaire
        $GenerateurFormulaireModel = new GenerateurFormulaireModel($formulaire_id);
        return $GenerateurFormulaireModel->getVueUsagerEtapes();
    }

    /**
     * @access public
     * @name getFormulaireId()
     * Fonction qui retourne l'id du formulaire
     *
     *  @return array               - $formulaire_id : retourne l'id du formulaire si il existe
     */
    public function getFormulaireId()
    {

        global $db;
        $formulaires = array();
        $sql = " SELECT `ops_generateur_formulaire_id` FROM `ops_generateur_formulaire_ops_dispositif` WHERE `ops_dispositif_id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $formulaires[] = $row;
        }
        return (!empty($formulaires) && count($formulaires) === 1) ? $formulaires[0]['ops_generateur_formulaire_id'] : "";
    }

    /**
     * @access public
     * @name getListe()
     * Fonction qui retourne l'id du formulaire
     *
     *  @return array               - $formulaire_id : retourne l'id du formulaire si il existe
     */
    public static function getListe()
    {

        global $db;
        $dispositifs = array();
        $sql = "SELECT * FROM `ops_dispositif` WHERE `deleted` = '0' ORDER BY name ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $dispositifs[$row["id"]] = $row;
        }
        return $dispositifs;
    }

    /**
     * @access public
     * @name getListeHc()
     * Fonction qui retourne la liste des téléservices disponibles en mode hors-compte
     *
     *  @return array - $dispositifs : retourne le tableau des dispositifs disponibles en hors-compte
     */
    public static function getListeHc()
    {
        global $db;
        $dispositifs = array();
        $sql = "SELECT * FROM `ops_dispositif` WHERE `deleted` = '0' AND `hors_compte` = 1 ORDER BY name ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $dispositifs[$row["id"]] = $row;
        }
        return $dispositifs;
    }

    public static function getEtapesGuideInstructionById($idDispositif, $getNombreParEtape = false){
        global $db; 

        $query = "SELECT e.id, e.name, e.instruction, '-' as 'nb'
        FROM ops_etape e
        INNER JOIN ops_guide_instruction_ops_etape ge ON e.id = ge.ops_etape_id
        INNER JOIN ops_guide_instruction_ops_dispositif gd ON ge.ops_guide_instruction_id = gd.ops_guide_instruction_id
        INNER JOIN ops_dispositif d ON gd.ops_dispositif_id = d.id";


        if($getNombreParEtape){
            $query .= " LEFT JOIN (
             SELECT od.ops_etape_id, od.id
             FROM ops_dossier od
             INNER JOIN ops_dispositif_ops_dossier dd ON od.id = dd.ops_dossier_id
             WHERE od.deleted = 0 AND dd.ops_dispositif_id = '$idDispositif'
            ) od ON e.id = od.ops_etape_id ";
            
            $query = str_replace("'-' as 'nb'", "COUNT(distinct od.id) AS nb", $query);

        }

        $suiteQuery = " WHERE gd.deleted = 0 AND ge.deleted = 0 AND e.deleted = 0 AND d.deleted = 0 and d.id='$idDispositif'
        GROUP BY e.id, e.name
        ORDER BY e.ordre";

        $query .= $suiteQuery;

        
        $query = $db->query($query);
        $resultats = [];

        while($row = $db->fetchRow($query)){
            $resultats[] = $row;
        }
        return $resultats;
    }
}
