<?php

namespace ODE\Sms;

use ODE\Helper\ReplaceVariable;

class OdeSms
{
    public $bean = false;

    public $token;
    public $erreur_token;
    public $api_sms;

    public function __construct($bean = false)
    {
        if ($bean !== false && !empty($bean->object_name)) {
            $this->bean = $bean;
        }
    }

    /**
     * Formatage du numéro récupéré
     * @param string : numéro du destinataire
     * @return bool|string : numero du demandeur au format  +33624545145 ou false
     */
    public function format_numero($numero)
    {
        $i = 0;
        $numero_retour = false;
        $numero_format = "";
        while ($i < strlen($numero)) {
            if (preg_match('/^[0-9]$/', $numero[$i])) { //si on a bien un chiffre on le garde
                $numero_format .= $numero[$i];
            }
            $i++;
        }
        if (strlen($numero_format) == 10) {
            $numero_retour = "+33" . substr($numero_format, 1, 9);
        }
        return $numero_retour;
    }

    /**
     * Envoie du sms
     *
     * @param string             -  numéro du destinataire
     * @param string             -  message à envoyer
     * @return string            -  confirmation
     */
    public function send_sms($numero, $message, $config = false)
    {
        $api = '';
        if(!$config)
        {
            global $sugar_config;
            $api = $sugar_config['ops_sms']['api'];
        }
        else
        {
            $api = $config['api'];
        }

        $message = $this->replaceVariables($message);

        switch ($api) {
            case 'ovh':
                require_once(__DIR__ . '/fournisseurs/ovh.php');
                $sms = new Ovh($config);
                break;
            case 'orange':
                require_once(__DIR__ . '/fournisseurs/orange.php');
                $sms = new Orange($config);
                break;
            case 'smsbox':
                require_once(__DIR__ . '/fournisseurs/smsbox.php');
                $sms = new Smsbox($config);
                break;
        }

        return $sms->post_sms($numero, $message);
    }

    /**
     * Fonction qui remplace les variables dans les differents textes du mail, il utilise la classe ODE\Helper\ReplaceVariable
     * 
     * @return void 
     */
    private function replaceVariables($message)
    {
        if($this->bean !== false)
        {
            $replaceVariable = new ReplaceVariable($this->bean);
            return $replaceVariable->replace($message);
        }

        return $message;
    }
}