<?php

namespace ODE\Traitements\API;

use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class Ops
{
	public function getTypeTraitement($connecteur){
		$objTypeTraitement = BeanFactory::newBean('OPS_type_traitement');
        $beanTypeTraitement = $objTypeTraitement->get_full_list('name','ops_type_traitement.pause = 0 AND ops_type_traitement.deleted = 0 AND ops_type_traitement.connecteur ="' . $connecteur . '"');
        return (!empty($beanTypeTraitement))?$beanTypeTraitement:'';
	}

	public function getTraitements($connecteur){
		$typeTraitements = $this->getTypeTraitement($connecteur);
		$traitements = array();
		if(!empty($typeTraitements)){
			foreach ($typeTraitements as $typeTraitement) {
				$objTypeTraitement = BeanFactory::getBean('OPS_type_traitement', $typeTraitement->id);
				$traitementsByType = $objTypeTraitement->get_linked_beans(
					'ops_type_traitement_ops_traitement',
					'OPS_traitement',
					'',
					0,
					-1,
					0,
					"ops_traitement.pause = 0 AND ops_traitement.termine = 0 AND ops_traitement.statut = 'recu'"
				);
				$traitements = array_merge($traitements, $traitementsByType);
			}
			return (!empty($traitements))?$traitements:false;
		}
	}

	public function getEtapeTraitement($traitement){
		$objTypeTraitementEtape = BeanFactory::getBean('OPS_type_traitement_etapes',$traitement);
		return (!empty($objTypeTraitementEtape))?$objTypeTraitementEtape->etape:false;
	}

	public function getTypeTraitementByEtate($typeTraitementId,$numEtape){
		if(!empty($typeTraitementId)){
			$objTypeTraitement = BeanFactory::getBean('OPS_type_traitement', $typeTraitementId);
			$typeTraitementEtape = $objTypeTraitement->get_linked_beans(
				'ops_type_traitement_ops_type_traitement_etapes',
				'OPS_type_traitement_etapes',
				'',
				0,
				-1,
				0,
				"ops_type_traitement_etapes.etape = '" . $numEtape . "'"
			);
			return (!empty($typeTraitementEtape))?$typeTraitementEtape[0]:false;
		}
	}

	public function addHistorique($traitement, $requete, $format){
		$objTraitementhistorique = BeanFactory::newBean('OPS_traitement_historique');

		$objTraitementhistorique->name = $traitement->name;
		$objTraitementhistorique->format = $format;
		$objTraitementhistorique->requete = $requete['requete'];
		$objTraitementhistorique->reponse = $requete['reponse'];
		$objTraitementhistorique->erreur = $requete['erreur'];
		$objTraitementhistorique->ops_traitement_id = $traitement->id;
		$objTraitementhistorique->etape = $traitement->ops_type_traitement_etapes_ops_traitement_name;

		$objTraitementhistorique->save();
	}
}