<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

global $current_user, $sugar_config;
if (!is_admin($current_user)) sugar_die("Unauthorized access to administration.");

require_once('modules/Configurator/Configurator.php');

$configuratorObj = new Configurator();
$sugar_smarty    = new Sugar_Smarty();
$errors        = array();
$array_categories = array('titre', 'onglet', 'label', 'champ');
$target_dir = "themes/default/images/";
$target_file = $target_dir . "pdf_logo.png";

$configuratorObj->loadConfig();

$key = "0-P7L}~)pd_R)3h7N=Za";

if (isset($_REQUEST['process']) && $_REQUEST['process'] == 'true') {

    //Paramètres de l'api particulier
    $configuratorObj->config['api_particulier']['url'] = $_REQUEST['url'];
    $configuratorObj->config['api_particulier']['jeton'] = $_REQUEST['jeton'];
    //Paramètres de l'api R2P
    $configuratorObj->config['api_r2p']['url'] = $_REQUEST['r2p_url'];
    $configuratorObj->config['api_r2p']['clef'] = $_REQUEST['r2p_clef'];
    $configuratorObj->config['api_r2p']['secret'] = openssl_encrypt($_REQUEST['r2p_secret'], "AES-128-ECB" ,$key);

    $configuratorObj->saveConfig();

    header('Location:index.php?module=Administration&action=index');
    
}

$sugar_smarty->assign('ARRAY_CATEGORIES', $array_categories);
$sugar_smarty->assign('URL', $configuratorObj->config['api_particulier']['url']);
$sugar_smarty->assign('JETON', $configuratorObj->config['api_particulier']['jeton']);

$sugar_smarty->assign('R2P_URL', $configuratorObj->config['api_r2p']['url']);
$sugar_smarty->assign('R2P_CLEF', $configuratorObj->config['api_r2p']['clef']);
$sugar_smarty->assign('R2P_SECRET', openssl_decrypt($configuratorObj->config['api_r2p']['secret'], "AES-128-ECB" ,$key));

$sugar_smarty->assign('MOD', $mod_strings);
$sugar_smarty->assign('APP', $app_strings);
$sugar_smarty->assign('APP_LIST', $app_list_strings);
$sugar_smarty->assign('LANGUAGES', get_languages());
$sugar_smarty->assign("JAVASCRIPT", get_set_focus_js());
$sugar_smarty->assign('config', $sugar_config);
$sugar_smarty->assign('error', $errors);

$sugar_smarty->clearCache('custom/modules/Administration/api_gouv.tpl');
$sugar_smarty->display('custom/modules/Administration/api_gouv.tpl');