<?php
if (!defined('sugarEntry') || !sugarEntry)
    die('Not A Valid Entry Point');

global $current_user, $sugar_config, $app_list_strings;
if (!is_admin($current_user))
    sugar_die("Unauthorized access to administration.");

require_once('modules/Configurator/Configurator.php');

$configuratorObj = new Configurator();
$sugar_smarty = new Sugar_Smarty();
$errors = array();

$configuratorObj->loadConfig();

$phone_masks_ini = parse_ini_file('assets/ini/phone_masking.ini', true);

if (isset($_REQUEST['process']) && $_REQUEST['process'] == 'true') {
    $array_reparation = array();

    foreach ($_REQUEST as $key => $value) {
        if (strpos($key, "libelle_") !== false) {
            # Si changement de valeur, une réparation des modules OPS_personne_morale & OPS_individu est nécessaire
            if ($value != $configuratorObj->config['opensocle']['adresse_libelles'][$key])
                !in_array("OPS_personne_morale", $array_reparation) ? array_push($array_reparation, 'OPS_personne_morale', 'OPS_individu') : '';

            $configuratorObj->config['opensocle']['adresse_libelles'][$key] = $value;
        } elseif (strpos($key, "dossier_bouton_") !== false) {
            $key_clean = explode('_', $key)[2];
            $configuratorObj->config['opensocle']['dossier_boutons_libelles'][$key_clean] = $value;
        } elseif ($key == "format_telephone") {
            # Si changement de valeur, une réparation des modules OPS_personne_morale & OPS_individu est nécessaire
            if (!array_equal(explode(",", $configuratorObj->config['opensocle']['pays_telephone']), $_REQUEST['format_telephone']))
                !in_array("OPS_personne_morale", $array_reparation) ? array_push($array_reparation, 'OPS_personne_morale', 'OPS_individu') : '';

            $configuratorObj->config['opensocle']['type_pays'] = $_REQUEST['type_pays'];
            $configuratorObj->config['opensocle']['pays_telephone'] = isset($_REQUEST['format_telephone']) ? implode(",", $_REQUEST['format_telephone']) : '';
            foreach ($_REQUEST['format_telephone'] as $mask_telephone) {
                $array_masks_tel[] = implode(",", $phone_masks_ini['phone_masking'][$mask_telephone]);
            }
            $configuratorObj->config['opensocle']['format_telephone'] = implode(",", $array_masks_tel);
        }
    }

    $configuratorObj->config['opensocle']['disable_api_ban'] = isset($_REQUEST['disable_api_ban']) ? 1 : 0;
    $configuratorObj->config['opensocle']['disable_fiche_agent'] = isset($_REQUEST['disable_fiche_agent']) ? 1 : 0;

    $configuratorObj->config['opensocle']['custom_couleur_delai_0'] = $_REQUEST['delai_0'] ?? "rgb(240,240,6)";
    $configuratorObj->config['opensocle']['custom_couleur_delai_1'] = $_REQUEST['delai_1'] ?? "rgb(240,240,6)";
    $configuratorObj->config['opensocle']['custom_couleur_delai_2'] = $_REQUEST['delai_2'] ?? "rgb(240,240,6)";
    $configuratorObj->config['opensocle']['custom_couleur_delai_3'] = $_REQUEST['delai_3'] ?? "rgb(240,240,6)";

    $configuratorObj->saveConfig();

    # Si on a un changement, on déclenche une réparation rapide des modules concernés uniquement (pas de réparation globale)
    if (!empty($array_reparation)) {
        require_once('modules/Administration/QuickRepairAndRebuild.php');
        $actions = array('clearAll');
        $randc = new RepairAndClear();
        $randc->repairAndClearAll($actions, $array_reparation, true, false);
    }

    header('Location:index.php?module=Administration&action=index');
}

foreach ($configuratorObj->config['opensocle']['adresse_libelles'] as $key => $value) {
    $sugar_smarty->assign("ADRESSE_" . strtoupper($key), $value);
}

foreach ($configuratorObj->config['opensocle']['dossier_boutons_libelles'] as $key => $value) {
    $sugar_smarty->assign("BOUTON_DOSSIER_" . strtoupper($key), $value);
}

$sugar_smarty->assign("DISABLE_API_BAN", $configuratorObj->config['opensocle']['disable_api_ban']);
$sugar_smarty->assign("DISABLE_FICHE_AGENT", $configuratorObj->config['opensocle']['disable_fiche_agent']);

$array_type_country = array(
    'france' => 'France (Métropolitaine, DOM, TOM, ...)',
    'international' => 'International',
);
$type_country = explode(",", $configuratorObj->config['opensocle']['type_pays']);
$select_type_countries = get_select_options_with_id($array_type_country, $type_country);
$sugar_smarty->assign("TYPE_PAYS", $select_type_countries);

$country = explode(",", $configuratorObj->config['opensocle']['pays_telephone']);
foreach ($phone_masks_ini['liste_pays_france'] as $key => $value) {
    $array_countries_france_clean[$key] = $value;
}
asort($array_countries_france_clean);
$select_countries = get_select_options_with_id($array_countries_france_clean, $country);
$sugar_smarty->assign("FORMAT_TELEPHONE_FRANCE", $select_countries);

foreach ($phone_masks_ini['liste_pays_international'] as $key => $value) {
    $array_countries_inter_clean[$key] = $value;
}
asort($array_countries_inter_clean);
$select_countries = get_select_options_with_id($array_countries_inter_clean, $country);
$sugar_smarty->assign("FORMAT_TELEPHONE_INTERNATIONAL", $select_countries);
$sugar_smarty->assign('MOD', $mod_strings);
$sugar_smarty->assign('APP', $app_strings);

$sugar_smarty->assign("DELAI_TITRE", $app_list_strings['ops_delai_list']);

$delai_color = translate('LIST_DEFAULT_COLOR_DELAI', 'OPS_dossier');
foreach($delai_color as $index => $color){
    $delai_color[$index] = $configuratorObj->config['opensocle']['custom_couleur_delai_'.$index] ?? $delai_color[$index];
}

$sugar_smarty->assign("DELAI_COLOR_DEFAULT", $delai_color);

$sugar_smarty->clearCache('custom/modules/Administration/ops_param_generaux.tpl');
$sugar_smarty->display('custom/modules/Administration/ops_param_generaux.tpl');

/**
 * Fonction de vérification de similitude entre 2 tableaux
 *
 * @param array $a
 * @param array $b
 * @return boolean
 */
function array_equal($a, $b) {
    return (
         is_array($a) 
         && is_array($b) 
         && count($a) == count($b) 
         && array_diff($a, $b) === array_diff($b, $a)
    );
}