<?php

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

require_once('custom/modules/Documents/Documents_editiques.php');


class ViewCreate extends SugarView
{

    public function __construct($bean = null, $view_object_map = array())
    {
        parent::SugarView($bean, $view_object_map);
    }

    public function preDisplay()
    {
        if (!$this->bean->ACLAccess('edit')) {
            ACLController::displayNoAccess();
            sugar_die('Access Denied');
        }
        
    }

    /**
     * @see SugarView::display()
     */
    public function display()
    {

        // Récupération des informations du bean Editique...
        if (!empty($this->bean->id) && !empty($_REQUEST['name_module']) && !empty($_REQUEST['id_bean']) ) {
            
            $smarty = new Sugar_Smarty();

            // On récupère les élément de navigation pour construire le volet gauche.
            // Assignation -»| ---
            $this->ss->assign( "navigation", $this->getNavigation() );
            $this->ss->assign( "filtres", $this->getFiltres() );

            // Récupération de la provenance pour redirection après sauvegarde ou téléchargement.
            // Assignation -»| ---
            $this->ss->assign( "bean", $this->bean );
            $this->ss->assign( "module_name", $_REQUEST['name_module'] );
            $this->ss->assign( "module_id", $_REQUEST['id_bean'] );

            $this->ss->assign( "rel_type", $this->bean->ops_type_document_id );

            // Permet de connnaitre et identifier un type qui ne serait plus disponible ou pas encore pré-sélectionné.
            // /!\ Le document peut être modifié au nivea meta et son type changé... 
            $obj_document_editique = new Documents_editiques();
            $related_type = $obj_document_editique->get_type_document_by_id( $this->bean->ops_type_document_id );

            $this->ss->assign( "rel_type_label", $related_type['name'] );
            $this->ss->assign( "rel_type_deleted", intval($related_type['deleted']) );
            $this->ss->assign( "rel_type_statut", intval($related_type['statut']) );

            
            $name_module = trim($_REQUEST['name_module']);

            switch ( strtolower($name_module) ) {
                case 'ops_dossier':
                    $document_attached_to = "Dossier";
                    break;
                case 'ops_individu':
                    $document_attached_to = "Individu";
                    break;
                case 'ops_personne_morale':
                    $document_attached_to = "Profil";
                    break;
                default:
                    $document_attached_to = "";
                    break;
            }
            $this->ss->assign( "document_attached_to", $document_attached_to );


            $document_caption = "•••";
            if( isset($_REQUEST['id_bean']) && !empty($_REQUEST['id_bean']) ){
                $id_bean = trim($_REQUEST['id_bean']);
                $obj_referer = BeanFactory::getBean( $name_module , $id_bean );

                switch ( strtolower($name_module) ) {
                    case 'ops_individu':
                        $document_caption = "« ". $obj_referer->full_name ." »";
                        break;
                    default:
                        $document_caption = "« ". $obj_referer->name ." »";
                        break;
                }
            }
            $this->ss->assign( "document_caption", $document_caption );



            echo $this->ss->fetch("custom/modules/Documents/App/tpls/app.tpl");
            $this->displayTMCE();

        }else{
        
            $module = ( empty($_REQUEST['name_module'])? 'Home':$_REQUEST['name_module'] );
            SugarApplication::redirect('index.php?module='.$module.'&action=index&error=missing-parameter');

        }

    }


    /**
     * @see SugarView::getNavigation()
     */
    public function getNavigation()
    {

        $Navigation = new stdClass();
        $items = []; // Items collector
        
        $obj_document_editique = new Documents_editiques();
        
        $type_module = ( empty($_REQUEST['name_module'])? '*' : $_REQUEST['name_module'] );

        $modeles = $obj_document_editique->get_modeles_documents($type_module);
        foreach ($modeles as $key => $modele) {
            array_push( $items, $this->fetchNavigationItem($modele) );
        }

        $Navigation->items = json_encode( $items );
        $Navigation->modeles = json_encode( $modeles );

        return $Navigation;

    }


    /**
     * @see SugarView::getFiltres()
     */
    public function getFiltres()
    {

        $Filtres = new stdClass();
        $items = []; // Items collector
        
        $obj_document_editique = new Documents_editiques();

        $type_module = ( empty($_REQUEST['name_module'])? '*' : $_REQUEST['name_module'] );

        $types = $obj_document_editique->get_types_documents($type_module);
        foreach ($types as $key => $type) {
            array_push( $items, $this->fetchFiltresItem($type) );
        }

        $Filtres->items = json_encode( $items );

        return $Filtres;

    }


    /**
     * @see SugarView::fetchNavigationItem()
     */
    public function fetchNavigationItem($modele)
    {

        return array(
            'id'        => $modele['id'],
            'slug'      => $this->slugify( $modele['name'] ),
            'label'     => $modele['name'],
            'type'      => $modele['type'],
            'icon'      => ( empty($modele['icone'])? 'pencil-alt' : $modele['icone'] ),
            'type_name' => $modele['type_name'],
            'type_id'   => $modele['type_id'],
            'content'   => base64_encode( $modele['description'] ),
        );

    }


    /**
     * @see SugarView::fetchFiltresItem()
     */
    public function fetchFiltresItem($filtre)
    {

        return array(
            'id'      => $filtre['id'],
            'label'   => $filtre['name'],
        );

    }



    /**
     * @see SugarView::slugify()
     */
    public function slugify($label)
    {

        $slug = strtolower( preg_replace('/([-])/', '-', preg_replace('/([-]+)/', '-', preg_replace('/([^a-zA-Z0-9])/', '-', $label) ) , 1) );
        return $slug;

    }


    function displayTMCE()
    {
        require_once("include/SugarTinyMCE.php");
        global $locale;

        $tiny = new SugarTinyMCE();
        $tinyMCE = $tiny->getConfig();

        $beanName = $this->name;

        $parsed_script_url = parse_url($_SERVER['SCRIPT_URI'], -1);
        $base_url_slots = array(
            $parsed_script_url['scheme'],
            '://',
            $parsed_script_url['host'],
        );
        $base_url = join('',$base_url_slots);


        # Config custom_TinyMCE_js scripts for TinyMCE Editor.
        $custom_TinyMCE_js = <<<JS

        <script language="javascript" type="text/javascript">
        $tinyMCE
        var df = '{$locale->getPrecedentPreference('default_date_format')}';

        let wysiwyg_id = 'corps';

        try{ 
            tinymce.execCommand('mceRemoveControl', true, wysiwyg_id);
        }
        catch(Exception){ /**/ }

        tinymce.init({
            theme : "advanced",
            theme_advanced_toolbar_align : "left",
            mode: "exact",
            elements : wysiwyg_id,
            theme_advanced_toolbar_location : "top",

            theme_advanced_buttons1: "code,separator, bold,italic,underline,separator, justifyleft,justifyright,justifycenter,justifyfull,separator, forecolor,separator, formatselect,fontselect,separator, styleprops,separator, bullist,numlist,separator, undo,redo,separator, sub,sup,separator, charmap,removeformat,separator, insertdate,separator, hr,separator, pagebreak,separator, cut,copy,paste,pastetext,pasteword",
            theme_advanced_fonts:"Garamond=garamond;Josefin Sans=Josefin Sans;Andale Mono=andale mono,times;Arial=arial,helvetica,sans-serif;Arial Black=arial black,avant garde;Book Antiqua=book antiqua,palatino;Comic Sans MS=comic sans ms,sans-serif;Courier New=courier new,courier;Georgia=georgia,palatino;Helvetica=helvetica;Helvetica Neu=helveticaneue,sans-serif;Impact=impact,chicago;Symbol=symbol;Tahoma=tahoma,arial,helvetica,sans-serif;Terminal=terminal,monaco;Times New Roman=times new roman,times;Trebuchet MS=trebuchet ms,geneva;Verdana=verdana,geneva;Webdings=webdings;Wingdings=wingdings,zapf dingbats",
            plugins : "insertdatetime,paste,directionality,style,table,pagebreak",

            width: "calc( 100% - 10px )",
            inline_styles : true,
            directionality : "ltr",
            remove_redundant_brs : true,
            entity_encoding: 'raw',
            cleanup_on_startup : true,
            strict_loading_mode : true,
            convert_urls : false,
            menubar: "table",
            table_grid: false,
            plugin_insertdate_dateFormat : '{DATE '+df+'}',
            pagebreak_separator : '<p style="page-break-before:auto;margin:0;height:1pt;border-top:dotted #FF0000 1px;" data-mce-style="page-break-before: auto; margin: 0; height: 1pt; border-top: dotted #FF0000 1px;">&nbsp;</p>',
            pagebreak_split_block: true,
            extended_valid_elements : "textblock",
            custom_elements: "textblock",
            content_css: "$base_url/custom/modules/Documents/css/tiny_editique.css",
        });

        </script>

JS;
        echo $custom_TinyMCE_js;
        # Write out custom_TinyMCE_js scripts.

    }
}
