<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

use ODE\Generateur\Factory\OdeFieldFactory;
use ODE\Generateur\Factory\OdeViewFactory;
use ODE\Model\DossierModel;
use ODE\Model\DispositifModel;
use ODE\Model\GenerateurFormulaireModel;

class DocumentsViewEdit extends ViewEdit
{

    public function __construct()
    {
        parent::__construct();
        $this->useForSubpanel = true;
    }

    function display()
    {
        global $app_list_strings,$mod_strings;
        $where = "";

        // On récupere le type_personne initial 
        $type_document_initial = ( !empty($this->bean->ops_type_document_id) ) ? $this->bean->ops_type_document_id : "";
        if( $_REQUEST['parent_type'] == "OPS_personne_morale" || $_REQUEST['return_relationship'] == "ops_personne_morale_documents" ){
            $where = "objet in ( 'tiers', 'transverse') ";
        } 
        elseif( $_REQUEST['parent_type'] == "OPS_dossier" || $_REQUEST['return_relationship'] == "ops_dossier_documents" ){
            $where = "objet in ( 'dossier', 'transverse') ";
        }

        // On récupere la liste des type_document
        $type_document = array( "" => "" );
        $type_document_info = array();
        $obj_document = BeanFactory::getBean("OPS_type_document");
        $liste_type_documents = $obj_document->get_full_list( "name", $where);
        if ( is_array($liste_type_documents) && count($liste_type_documents) > 0 ) {
            foreach ( $liste_type_documents as $typeDocument ) {
                $type_document[$typeDocument->id] = $typeDocument->name;

                $multi_fichier = '';

                $type_document_bean = BeanFactory::getBean('OPS_type_document', $fileParams->attache);
                $accept = str_replace('^', '', $typeDocument->format);

                $max_size = 0;
                if(!empty($typeDocument->taille_limite))
                {
                    $max_size = $typeDocument->taille_limite * pow(1024, 2);
                }
                //$multi_fichier = (($typeDocument->multi_fichier) ? 'multiple' : '' );

                $type_document_info[$typeDocument->id] = [
                    "accept" => $accept,
                    "max_size" => $max_size,
                    "multiple" => $multi_fichier,
                ];
            }
        }

        $select_type_document_initial = '<select id="ops_type_document_documents_name" onchange="document.getElementById(\'ops_type_document_id\').value = document.getElementById(\'ops_type_document_documents_name\').value;" style="width: 45%;margin-right: 5%;">';
        $select_type_document_initial .= get_select_options_with_id($type_document, $type_document_initial);
        $select_type_document_initial .='</select> ';

        
        
        $select_type_document_initial .= '<input type="hidden" name="ops_type_document_id" id="ops_type_document_id" value="' . $type_document_initial . '">';
        $select_type_document_initial .= '<input type="hidden" name="ops_type_document_info" id="ops_type_document_info" value="' . base64_encode ( json_encode($type_document_info) ) . '">';
        $this->ss->assign("type_document_initial", $select_type_document_initial);

        parent::display();
    }
    
}
