<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

require_once('include/MVC/View/views/view.list.php');

class DocumentsViewList extends ViewList {

    public function __construct(){
        parent::__construct();
    }

    function DocumentsViewList()
    {
        parent::ViewList();
    }


    /**
     * Override preDisplay
     */
    function preDisplay() 
    { 

        global $current_user; 

        $this->lv = new ListViewSmarty();

        parent::preDisplay(); 

    }

    /**
     * Override listViewProcess with addition to where clause to exclude project templates
     */
    function listViewProcess()
    {
        if( $this->isCustomRequestEditique() ) { 
            $this->processSearchForm(); // for search form 
        }

        if(!$this->headers) return;

        $this->lv->quickViewLinks = true;

        $this->lv->setup($this->seed, 'include/ListView/ListViewGeneric.tpl', $this->where, $this->params);
        echo $this->lv->display();

    }


    /**
     * Override processSearchForm with addition to where clause to fetch only Document Editique.
     */
    function processSearchForm(){
        
        // Extend Where clause only for origine...
        if( $this->isCustomRequestEditique() ) { 

            $this->where.=" origine = 'editique' AND status_id <> 'brouillon' AND status_id <> '' ";

            // Combinaison pour lister seulement les ♫ Édititiques du dossier de provenance..
            $reference_id_record = ( isset($_GET['id_bean']) && !empty($_GET['id_bean']) )? $_GET['id_bean'] : '';
            $table_ref_view_def  = ( isset($_GET['name_module']) && !empty($_GET['name_module']) )? strtolower(trim($_GET['name_module'])).'_documents' : '';


            if( in_array( $table_ref_view_def , [
                    'ops_dossier_documents',
                    'ops_personne_morale_documents',
                    'ops_individu_documents',
            ]) ){

                # 'ops_dossier_documents',
                # 'ops_personne_morale_documents',
                # 'ops_individu_documents',

                $field_ref_document = str_replace('_documents', '_id', $table_ref_view_def);

                // Extend Where clause conditoin IN :
                $extend_where =" AND document_id IN ( SELECT document_id 
                                 FROM `".$table_ref_view_def."` 
                                 WHERE ".$table_ref_view_def.".".$field_ref_document." = '".$reference_id_record."' )";

                /**/
                $this->where.=" ".$extend_where." ";
                /**/
        
            }


        }
    }

    
    /**
     * Override listViewProcess with addition to where clause to exclude project templates
     */
    protected function _getModuleTitleListParam($browserTitle = false)
    {
        global $mod_strings, $app_strings;

        # Custom spécial support dans la demande d'affichage de Document Éditiques :
        if( $this->isCustomRequestEditique() ) { 
            $param = $mod_strings['LBL_MODULE_CAPTION_DOC_PLR'];



            # On peut récupérer certains params passer via le lien du menu, si existant alors on customise un peu plus le titre.
            $extra = ''; // Complément par défaut.

            $reference_id_record = ( isset($_GET['id_bean']) && !empty($_GET['id_bean']) )? $_GET['id_bean'] : ''; // Id de provenance lié au module de provenance.
            $table_ref_view_def  = ( isset($_GET['name_module']) && !empty($_GET['name_module']) )? strtolower(trim($_GET['name_module'])).'_documents' : ''; // Construit à partir du module de provenance.
            $reference_bean_name = $_GET['name_module'];

            # Les Documents Éditiques sont contextuels à ces 3 modules (2003/06) :
            # 'ops_dossier_documents',
            # 'ops_personne_morale_documents',
            # 'ops_individu_documents',

            if( in_array( $table_ref_view_def , [
                    'ops_dossier_documents',
                    'ops_personne_morale_documents',
                    'ops_individu_documents',
            ]) ){

                switch ( strtolower($table_ref_view_def) ) {
                    case 'ops_dossier_documents':
                        $document_attached_to = "Dossier";
                        break;
                    case 'ops_individu_documents':
                        $document_attached_to = "Individu";
                        break;
                    case 'ops_personne_morale_documents':
                        $document_attached_to = "Profil";
                        break;
                    default:
                        $document_attached_to = "";
                        break;
                }

                $document_caption = "•••";
                $obj_referer = BeanFactory::getBean( $reference_bean_name , $reference_id_record );

                switch ( strtolower($table_ref_view_def) ) {
                    case 'ops_individu_documents':
                        $document_caption = "« ". $obj_referer->full_name ." »";
                        break;
                    default:
                        $document_caption = "« ". $obj_referer->name ." »";
                        break;
                }

                $extra = $document_attached_to ." ".$document_caption;

            }

            return $param ." / ". $extra; 
        }


        # Natif... Tous Documents :
        if (!empty($GLOBALS['app_list_strings']['moduleList'][$this->module])) {
            $firstParam = $GLOBALS['app_list_strings']['moduleList'][$this->module];
        } else {
            $firstParam = $this->module;
        }
        return $firstParam;

    }

    public function getBrowserTitle()
    {
        global $app_strings, $mod_strings;

        if( $this->isCustomRequestEditique() ) { 
            # Custom pour contexte des Documents Éditiques.

            $browserTitle = $app_strings['LBL_BROWSER_TITLE'];
            $moduleName   = $mod_strings['LBL_MODULE_NAME'];
            $viewName   = $mod_strings['LBL_MODULE_CAPTION_DOC_PLR'];

            $browserTitle = $viewName . ' &raquo; ' . $moduleName . ' &raquo; ' . $browserTitle;

            return $browserTitle;

        }

        else{
            # Natif : issu de la classe /SugarView :: getBrowserTitle()

            $browserTitle = $app_strings['LBL_BROWSER_TITLE'];
            if ($this->module == 'Users' && ($this->action == 'SetTimezone' || $this->action == 'Login')) {
                return $browserTitle;
            }
            $params = $this->_getModuleTitleParams(true);
            foreach ($params as $value) {
                $browserTitle = strip_tags($value) . ' &raquo; ' . $browserTitle;
            }

            return $browserTitle;

        }

    }



    public function isCustomRequestEditique(){

        if( isset($_GET['origine']) && !empty($_GET['origine']) && $_GET['origine'] == "editique" 
         && isset($_GET['module']) && !empty($_GET['module']) && $_GET['module'] == "Documents"
         && isset($_GET['name_module']) && !empty($_GET['name_module']) 
         && (
            $_GET['name_module'] == "OPS_dossier"
         || $_GET['name_module'] == "OPS_individu"
         || $_GET['name_module'] == "OPS_personne_morale"
            )
         && isset($_GET['id_bean']) && !empty($_GET['id_bean']) 
         && isset($_GET['record']) && !empty($_GET['record']) 
        ) { 
            return true;
        }else{
            return false;
        }

    }

}
