<?php

$job_strings[] = 'delai_dossier';

function delai_dossier(){

    global $db;
    $dossiers = "SELECT 
                DISTINCT ops_dossier.id, 
                ops_dossier.name, 
                ops_dossier.ops_etape_id, 
                ops_etape.nb_jour_retard, 
                ops_etape.nb_jour_avant_retard,
                ops_historisation.ops_etape_id, 
                ops_historisation.date_entered 
                FROM 
                ops_dossier 
                INNER JOIN ops_historisation_ops_dossier ON ops_dossier.id = ops_historisation_ops_dossier.ops_dossier_id 
                AND ops_historisation_ops_dossier.deleted = 0 
                INNER JOIN ops_historisation ON ops_historisation_ops_dossier.ops_historisation_id = ops_historisation.id 
                INNER JOIN ops_etape ON ops_etape.id = ops_dossier.ops_etape_id 
                WHERE 
                ops_dossier.deleted = 0 
                AND ops_dossier.cloture = 0 
                AND ops_dossier.name != 'TEMP' 
                AND ops_dossier.brouillon = 'non'
                AND ops_historisation.deleted = 0 
                AND ops_historisation.date_entered = (
                    SELECT 
                    ops_historisation.date_entered 
                    FROM 
                    ops_historisation 
                    INNER JOIN ops_historisation_ops_dossier ON ops_historisation.id = ops_historisation_ops_dossier.ops_historisation_id 
                    AND ops_historisation_ops_dossier.deleted = 0 
                    WHERE 
                    ops_historisation_ops_dossier.ops_dossier_id = ops_dossier.id 
                    AND ops_historisation.ops_etape_id = ops_dossier.ops_etape_id 
                    ORDER BY 
                    ops_historisation.date_entered ASC 
                    LIMIT 1
                ) 
                ORDER BY 
                ops_historisation.date_entered
            ";
    $result = $db->query($dossiers);
    $currentDate = new DateTime(date('Y-m-d H:i:s'));

    while($row = $db->fetchByAssoc($result)){
        $dateEtape = new DateTime($row['date_entered']);
        $delai = $currentDate->diff($dateEtape)->days;
        $nbJourRetard = $row["nb_jour_retard"];
        $nbJourAvantRetard = $row["nb_jour_avant_retard"];

        // 0 => gris, 1 => dans les temps, 2 => entre deux, 3 => en retard
        $couleur = "0";
        if(!$nbJourAvantRetard || !$nbJourRetard) $couleur = "0";
        else if($delai < $nbJourAvantRetard) $couleur = "1";
        else if($delai >= $nbJourAvantRetard && $delai < $nbJourRetard) $couleur = "2";
        else if($delai >= $nbJourRetard) $couleur = "3";


        $beanDossier = BeanFactory::getBean("OPS_dossier", $row['id']);

        $beanDossier->delai = $couleur;
        $beanDossier->save();
    }
    return true;
}