<?php 

$job_strings[] = 'notification_suppression_compte_usager';

/**
 * Tâche planifié qui permet de : 
 * - notifier un usager lorsque que son compte n'est plus utilisé depuis X jours 
 * - supprimer le compte de l'usager lorsque son compte n'est plus utilisé depuis Y jours
 */
function notification_suppression_compte_usager()
{

    global $db;
    $configuratorObj = new Configurator();
    $delaiNotif = $configuratorObj->config['opensocle']['delai_notification_compte_non_utilise'];
    $delaiSuppr = $configuratorObj->config['opensocle']['delai_suppression_compte_non_utilise'];
    $pointDeDepart = $configuratorObj->config['opensocle']['definition_compte_non_utilise'];
    $modeleDeMailNotif = $configuratorObj->config['opensocle']['notif_non_utilisation_compte'];

    $GLOBALS['log']->fatal(print_r("## LANCEMENT DE LA TÂCHE PLANIFIÉ DE NOTIFICATION ET SUPPRESSION DES COMPTES USAGERS",true));
    // debut preparation des fonctions pratique pour cette tache planifié

    // f() -> recuperation des individus considéré non utilisé depuis un certain delai
    $getIndividuParDelais = function($delai, $checkNotification) use($pointDeDepart, $db) {

        if($pointDeDepart == 'connexion'){
            $sql = "SELECT ind.id
                    FROM ops_historique_connexion_ops_individu r1 
                        JOIN ops_individu ind ON ind.id = r1.ops_individu_id 
                        JOIN ops_historique_connexion his on his.id = r1.ops_historique_connexion_id 
                    WHERE 
                        r1.deleted = 0 AND
                        his.deleted = 0 AND
                        ind.deleted = 0 AND 
                        DATE_ADD(his.derniere_connexion, INTERVAL $delai DAY) < CURDATE()" 
                        . ($checkNotification ? " AND ind.inactif_notification = 0" : "") ;
        }
        else if($pointDeDepart == 'dossier'){

            $sql = "SELECT distinct ind.id 
                    FROM ops_individu_ops_dossier r1 
                    JOIN ops_individu ind on r1.ops_individu_id = ind.id 
                    JOIN ops_dossier dos on dos.id = r1.ops_dossier_id 
                    WHERE 
                        ind.last_name not like 'anonyme' AND
                        (dos.deleted = 1 OR dos.cloture = 1) AND 
                        DATE_ADD(dos.date_modified, INTERVAL $delai DAY) < CURDATE()"
                        . ($checkNotification ? " AND ind.inactif_notification = 0" : "") ;
        }
        else return false;
        
        return $db->query($sql);
    };

    // f() -> supprimer un individu
    $actionSupprimer = function($idIndividu){
        $GLOBALS['log']->fatal(print_r("# Suppression du compte usager : " . $beanIndividu->first_name . " " . $beanIndividu->last_name . " (id = $idIndividu)" ,true));

        $beanIndividu = BeanFactory::getBean("OPS_individu", $idIndividu);
        $beanIndividu->mark_deleted($idIndividu);

    };

    // f() -> notifier un individu
    $actionNotifier = function($idIndividu) use ($modeleDeMailNotif) {
        $beanIndividu = BeanFactory::getBean("OPS_individu", $idIndividu);

        $GLOBALS['log']->fatal(print_r("# Notification à l'usager : " . $beanIndividu->first_name . " " . $beanIndividu->last_name . " (id = $idIndividu)" ,true));
        
        $mailIndividu = $beanIndividu->email1;
        $accepteMail = $beanIndividu->accepte_mail;

        if(empty($mailIndividu)) {
            $GLOBALS['log']->fatal(print_r("-> l'usager n'a pas d'adresse mail",true));
            return false;
        }

        if($accepteMail != 1){
            $GLOBALS['log']->fatal(print_r("-> l'usager n'accepte pas les mails",true));
            return false;
        }

        
        $mailer = new OdeMailer();

        $ode_email = new OdeEmail([
            'bean_source_id' => $idIndividu,
            'bean_source_name' => "OPS_individu",
            'bean_historisation_id' => $idIndividu,
            'bean_historisation_name' => "OPS_individu",
            'email_template_id' => $modeleDeMailNotif,
            'dest_to' => $mailIndividu,
        ]);

        # On déclenche l'envoie
        $mailer->send($ode_email);

        // l'usager a ete notifie
        $beanIndividu->inactif_notification = 1;
        $beanIndividu->save();

        return true;

    };

    // fin preparation des fonctions pratique pour cette tache planifié



    $individuANotifier = $getIndividuParDelais($delaiNotif, true);

    $GLOBALS['log']->fatal(print_r("## Traitement des notifications",true));

    if(!empty($modeleDeMailNotif)){
        while($row = $db->fetchByAssoc($individuANotifier)){
            $actionNotifier($row['id']);
        }
    }
    else $GLOBALS['log']->fatal(print_r("# Les notifications aux usagers n'a pas pu être réalisé : aucun modèle de mail n'a été paramétré",true));

    

    $GLOBALS['log']->fatal(print_r("## Fin traitement des notifications",true));


    $individuASupprimer = $getIndividuParDelais($delaiSuppr, false);

    $GLOBALS['log']->fatal(print_r("## Traitement des suppressions",true));
    
    while($row = $db->fetchByAssoc($individuASupprimer)){
        $actionSupprimer($row['id']);
    }

    $GLOBALS['log']->fatal(print_r("## Fin traitement des suppressions",true));


    $GLOBALS['log']->fatal(print_r("## FIN DE LA TÂCHE PLANIFIÉ DE NOTIFICATION ET SUPPRESSION DES COMPTES USAGERS",true));

    return true;
}