<?php 

$job_strings[] = 'suppression_dossier_cloture';

function suppression_dossier_cloture(){

    global $db;


    $GLOBALS['log']->fatal(print_r("## LANCEMENT DE LA TÂCHE PLANIFIÉ DE SUPPRESSION DES DOSSIERS",true));

    /* Recuperation des dossier qui cloturé qui ont dépassé le delai */
    /* DATE_ADD(ops_dossier.date_modified, INTERVAL ops_dispositif.delai_suppression DAY) < CURDATE() renvoi null si le delai de suppression est a null */
    $sql = "SELECT ops_dossier_id AS dossierId
            FROM   ops_dispositif_ops_dossier
            INNER JOIN ops_dispositif
                ON ops_dispositif_id = ops_dispositif.id
            INNER JOIN ops_dossier
                ON ops_dossier.id = ops_dossier_id
            WHERE  ops_dispositif_ops_dossier.deleted = 0
            AND ops_dispositif.deleted = 0
            AND ops_dossier.cloture = 1
            AND DATE_ADD(ops_dossier.date_modified, INTERVAL ops_dispositif.delai_suppression_cloture DAY) < CURDATE()";

    $res = $db->query($sql);


    while ($dossier = $db->fetchByAssoc($res, false)) {
        $GLOBALS['log']->fatal(print_r("# Suppression du dossier d'id : " . $dossier['dossierId'],true));
        $bean = BeanFactory::getBean("OPS_dossier", $dossier['dossierId']);
        $bean->mark_deleted($dossier['dossierId']); 
        $bean->save(); // lancement des hooks
    }

    $GLOBALS['log']->fatal(print_r("## FIN DE LA TÂCHE PLANIFIÉ DE SUPPRESSION DES DOSSIERS",true));
    return true;
}
